/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */
/************************************************************************
 *									*
 *		Code to	deal with user defined menus			*
 *									*
 *		NodeMenu - is to be bound to mouse button3 on a node	*
 *		LinkMenu - is to be bound to mouse button3 on a link	*
 *									*
 *					( Activate in Resource file )	*
 *					or hardcode button3 binding	*
 *									*
 ************************************************************************/
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "motif.h"
#include "xmap.h"

Widget nodemenu, linkmenu;			/* Menu	RowColumn Widgets */
Widget nodemenutitle, linkmenutitle;		/* Menu	RowColumn Widgets */

#ifdef STANDALONE
	Widget drawarea;
#else
	extern Widget drawarea;
#endif

typedef	struct MenuItemArray {
	char *NodeMenuItem[ MAX_MENU_ENTRIES ];	/* Node	Menu Commands */
	char *LinkMenuItem[ MAX_MENU_ENTRIES ];	/* Link	Menu Commands */
} ApplicationData, *ApplicationDataPtr;

static ApplicationData UserDefinedMenus;		/* Acture structure */


static char *MenuNode1IPAddr, *MenuNode2IPAddr;	/* Which link/node activated */
static char *MenuNode1, *MenuNode2;		/* and again by name for menu*/

/************************************************************************
 *	PostNodeMenu()	- Action routine to display userdefined	menu	*
 * It might be nice to have user see addresses filled in, showing exact	*
 * command that will be executed.   $1 and $2 may confuse....		*
 ************************************************************************/
/*ARGSUSED*/
void PostNodeMenu(w, event, params, num_params	)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	Arg myArgs[MAX_X_ARGS];
	XmString xmstr;
	char *name, MenuTitle[100];
	extern char *GetIPAddr();

    	XtSetArg( myArgs[0], XmNlabelString, &xmstr );
    	XtGetValues( w, myArgs, 1 );
    	if (XmStringGetLtoR( xmstr, XmSTRING_DEFAULT_CHARSET, &name) != True) {
            	printf("Weird - couldn't get label on node - aborting\n");
            	return;
	}
	sprintf( MenuTitle, "Node %s Action Menu", name);
	xmstr=XmStringCreate( MenuTitle, XmSTRING_DEFAULT_CHARSET);
	XtSetArg( myArgs[0], XmNlabelString, xmstr);
	XtSetValues( nodemenutitle, myArgs, 1);
	MenuNode1IPAddr = GetIPAddr(name);
	MenuNode2IPAddr = NULL;
	XmMenuPosition(nodemenu, event);
	XtManageChild(nodemenu);
}

/************************************************************************
 *	PostLinkMenu()	- Action routine to display userdefined	menu	*
 * It might be nice to have user see addresses filled in, showing exact	*
 * command that will be executed.   $1 and $2 may confuse....		*
 ************************************************************************/
/*ARGSUSED*/
void PostLinkMenu(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	Arg myArgs[MAX_X_ARGS];
	int Node1, Node2;
	Cardinal MenuX, MenuY;
	XmString xmstr;
	char MenuTitle[100];

	printf("PostLinkMenu()\n");
    	MenuX = event->xbutton.x;
    	MenuY = event->xbutton.y;
	if (Link2Nodes((int) MenuX, (int) MenuY, &Node1, &Node2) != 0 ) {
	    	MenuNode1IPAddr = MapNode[Node1].IPAddr;
        	MenuNode2IPAddr = MapNode[Node2].IPAddr;
	    	MenuNode1 = MapNode[Node1].Name;
        	MenuNode2 = MapNode[Node2].Name;
		sprintf(MenuTitle, "Link %s-%s Action Menu", 
						MenuNode1, MenuNode2);
		xmstr = XmStringCreate(MenuTitle, XmSTRING_DEFAULT_CHARSET);
		XtSetArg(myArgs[0], XmNlabelString, xmstr);
		XtSetValues(linkmenutitle, myArgs, 1);
		XmMenuPosition(linkmenu, event);
		XtManageChild(linkmenu);
	};
}

/***************************************************************************
 *	do_it -	Perform	users defined action; callback for menu	pushbutton *
 ***************************************************************************/
/*ARGSUSED*/
static void do_it(w, client_data, call_data)
Widget w;
char *client_data;
caddr_t	call_data;
{
	char buffer[ MAXCOMMAND	];
	char *ProcessCmd();
	extern void FeedSystem();

	strcpy(buffer, client_data);
	FeedSystem(MenuNode1IPAddr, MenuNode2IPAddr, client_data);
#ifdef OLD
	for( num_params=0, param[num_params++]=strtok(buffer," \t\n"); 
					param[num_params]=strtok(NULL,"	\t\n");	num_params++ );
	for( i=0; i<num_params;	i++ )
		printf("param[%d]=%s\n",i,param[i]);

    strcpy(cmd,"");
    for( i=0; i<num_params; i++ )
        strcat(cmd,ProcessCmd( param[i], MenuNode1IPAddr, MenuNode2IPAddr ));
    strcat( cmd, " & ");
    printf("system( %s )\n",cmd);
    system( cmd );
#endif
}

/****************************************************************************
 *		BuildMyAppResources() -	Read in	user defined menu buttons   *
 ****************************************************************************/
void BuildMyAppResources(toplevel)
Widget toplevel;
{
	XtResource *resources = NULL;
	static char Name[MAX_MENU_ENTRIES*2][30],
			Class[MAX_MENU_ENTRIES*2][30], Type[20];
	int i, Debug = 0;
	extern XtResource * malloc();

	/*
	 * Set-up Node Menu Resources
	 */
	strcpy(Type, XtRString);
	resources = malloc(sizeof(XtResource) * MAX_MENU_ENTRIES * 2);
	for (i = 0; i < MAX_MENU_ENTRIES; i++) {
		sprintf(Name[i], "nodeMenuItem%d", i);
		resources[i].resource_name = Name[i];
		sprintf(Class[i], "NodeMenuItem%d", i);
		resources[i].resource_class = Class[ i ];
		resources[i].resource_type = Type;
		resources[i].resource_size = MAXCOMMAND;
		resources[i].resource_offset = XtOffset(ApplicationDataPtr, 
							NodeMenuItem[i] );
		resources[i].default_type = Type;
		resources[i].default_addr = NULL;
	}

	/*
	 * Set-up Link Menu Resources
	 */
	for ( ; i < MAX_MENU_ENTRIES*2; i++) {
		sprintf(Name[i], "linkMenuItem%d", i - MAX_MENU_ENTRIES);
		resources[i].resource_name = Name[i];
		sprintf(Class[i], "LinkMenuItem%d", i - MAX_MENU_ENTRIES);
		resources[i].resource_class=Class[i];
		resources[i].resource_type = Type;
		resources[i].resource_size = MAXCOMMAND;
		resources[i].resource_offset = XtOffset(ApplicationDataPtr,
					  LinkMenuItem[i - MAX_MENU_ENTRIES]);
		resources[i].default_type = Type;
		resources[i].default_addr = NULL;
	}

	/*******************************************/
	/* Get Menu Resources and print	out values */
	/*******************************************/
	XtGetApplicationResources(toplevel, &UserDefinedMenus, resources, 
					MAX_MENU_ENTRIES * 2, NULL, 0);
	if (Debug) {
		for (i = 0; i < MAX_MENU_ENTRIES; i++) {	
			if (UserDefinedMenus.NodeMenuItem[i] != NULL) 
				printf("nodeMenuItem%d=%s\n", i,
					UserDefinedMenus.NodeMenuItem[i]);
		}
		for (i = 0; i < MAX_MENU_ENTRIES; i++) {	
			if (UserDefinedMenus.LinkMenuItem[i] != NULL) 
				printf("linkMenuItem%d=%s\n", i,
					UserDefinedMenus.LinkMenuItem[i]);
		}
	}
	free(resources);		/* I now have my defaults */
}

/******************************************************************************
 *	CreateMenus( ) - Using user-defined menu Entries, build	a pop-up menu *
 ******************************************************************************/
void CreateMenus(Parent)
Widget Parent;
{
	static Widget button[ MAX_MENU_ENTRIES*2 ];
	static XtActionsRec actionsTable[] = {
	  { "PostNodeMenu", PostNodeMenu },	/* PostNodeMenu	Action Proc */
	  { "PostLinkMenu", PostLinkMenu },	/* PostLinkMenu	Action Proc */
	};
	register int i;

	/*************************************************/
	/* Create NodeMenu using UserDefinedMenu Entries */
	/*************************************************/
    	nodemenu = XmCreatePopupMenu( Parent, "nodemenu", NULL, 0);
    	nodemenutitle = XtCreateManagedWidget( "NodeActionMenu", 
				xmLabelWidgetClass, nodemenu, (Arg *) NULL, 0);
    	(void) XtCreateManagedWidget("separator", xmSeparatorWidgetClass, 
				nodemenu, (Arg *) NULL, 0);
	
	for (i = 0; i < MAX_MENU_ENTRIES; i++) {
		if (UserDefinedMenus.NodeMenuItem[i] != NULL) {
			button[i] = XtCreateManagedWidget(
					UserDefinedMenus.NodeMenuItem[i], 
					xmPushButtonWidgetClass, nodemenu, 
					(Arg *) NULL, 0);
			XtAddCallback(button[i], XmNactivateCallback, do_it, 
				(caddr_t) UserDefinedMenus.NodeMenuItem[i]);
		}
	}

	/*************************************************/
	/* Create LinkMenu using UserDefinedMenu Entries */
	/*************************************************/
    	linkmenu = XmCreatePopupMenu( Parent, "linkmenu", NULL, 0);
    	linkmenutitle=XtCreateManagedWidget( "LinkActionMenu", 
			xmLabelWidgetClass, linkmenu, (Arg *) NULL, 0);
    	(void) XtCreateManagedWidget("separator", xmSeparatorWidgetClass, 
					linkmenu, (Arg *) NULL, 0);
	for (i = 0; i < MAX_MENU_ENTRIES; i++) {
		if (UserDefinedMenus.LinkMenuItem[i] != NULL) {
			button[i + MAX_MENU_ENTRIES] = XtCreateManagedWidget( 
				UserDefinedMenus.LinkMenuItem[i], 
				xmPushButtonWidgetClass, linkmenu, 
				(Arg *) NULL, 0);
			XtAddCallback(button[i + MAX_MENU_ENTRIES], 
				XmNactivateCallback, do_it, 
				(caddr_t) UserDefinedMenus.LinkMenuItem[i]);
		}
	}
	/************************************************/
	/* Install Action Table	for Node and Link Menus	*/
	/************************************************/
    	XtAddActions(actionsTable, XtNumber(actionsTable));
}


#ifdef STANDALONE

/*
 *		main - this is the test	environment
 *
 */

main(argc, argv)
int argc;
char *argv[];
{
	Widget toplevel, pb, pb2;
	Arg wargs[MAX_X_ARGS];


	toplevel = XtInitialize( argv[0],"MenuTest", NULL, 0, &argc, argv );
	XtSetArg( wargs[0], XmNwidth, 400 );
	XtSetArg( wargs[1], XmNheight, 400 );
    	drawarea = XtCreateManagedWidget( "drawarea", xmDrawingAreaWidgetClass,
				toplevel, wargs, 2 );

    	pb = XtCreateManagedWidget("pb", xmPushButtonWidgetClass, drawarea, 
				NULL, 0);

	XtSetArg( wargs[0], XmNx, 20 );
	XtSetArg( wargs[1], XmNy, 20 );
    	pb2 = XtCreateManagedWidget("pb2", xmPushButtonWidgetClass,
				drawarea, wargs, 1);

	/**** Add Event	Handler	for each PushButton directly? ****/
	/**** or add it	through	the translation	manager		  ****/
	/**** Perhaps we need to create	node menu under	the pb	  ****/
	/* Is DrawArea translation taking over translations from pushbutton */

    	BuildMyAppResources(toplevel);
	CreateMenus(pb);
    	XtRealizeWidget(toplevel);
    	XtMainLoop();
}
#endif
