/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *			ifchk.c - Check  Counts
 *						
 *	Use fastsnmp API to get interface state
 *								
 *		Blast Out Queries to nodes		
 *		Process Received Table			
 *						
 * This program expects the LinkDetail file to contain accurate info	
 *	We are sending out one packet for each interface...could be optimized
 *	later.							
 */

#include <stdio.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include "CommonDefs.h"
#include "pathnames.h"
#include "snmptable2.h"
#include "Linkfileio.h"
#include "mib.h"

#ifdef PROFILING
#include <mon.h>
#endif
char *progname;



void Usage()
{
	extern void exit();

	fprintf(stderr,"Usage: %s [-r numretries ] [ -t timebetweenretires ] [-v] -c <community> -n <netname>\n",progname);
	exit(1);
}

/************************************************************************
 ************************************************************************/
static char *IfVars[]={
                        "ifOperStatus"
};

/************************************************************************
 *	AddData2Query() - Create VarList for this  interface	*
 ************************************************************************/
struct VarList * AddData2Query(head, ifnum)
struct VarList *head;
int ifnum;
{
	register struct VarList *vp;
	register int i;
	char Index[40], Var[50];

	sprintf(Index, "%d", ifnum);
	for (i = 0; i < ((sizeof(IfVars)) / (sizeof(char *))); i++) {
		strcpy( Var, IfVars[i] );
		head=AddVar( head , Var );
		for ( vp = head; vp->Next != NULL; vp = vp->Next )
			;
		strcat( vp->Prefix, Index );
	}
	return( head );
}

/************************************************************************
 *	MakeAddressList() - Make Address List with appropriate 	*
 *				VarList for the s this box has	*
 *	Note that this creates one packet per  - could be optimized  *
 ************************************************************************/
struct AddressListType * MakeAddressList(new)
struct AddressListType *new;
{
	struct AddressListType *ap;
	register struct LinkDetail *lp;
	extern struct LinkDetail *LinkDetailHead;
	struct in_addr remote, local;

	for (lp = LinkDetailHead; lp != NULL; lp = lp->Next) {
		for( ap=new; ap!=NULL; ap=ap->Next )
			if ( strcmp( ap->Address, lp->LocalNode ) == 0 )
				break;
		if ( ap == NULL ) {
			new = AddAddress(new, lp->LocalNode);
			for (ap = new; ap->Next != NULL; ap=ap->Next) ;
		}
		if (verbose) 
			printf("Adding %s  #%d\n", lp->LocalNode, 
							lp->LocalDSUNumber);
		ap->QueryListHead = AddData2Query(ap->QueryListHead, 
							lp->LocalDSUNumber);
		/*
		 *  Remote Address and 
		 */
                for( ap=new; ap!=NULL; ap=ap->Next )
                        if ( strcmp( ap->Address, lp->RemoteNode ) == 0 )
                                break;
                if ( ap == NULL ) {
			new = AddAddress(new, lp->RemoteNode);
			for (ap = new; ap->Next != NULL; ap = ap->Next) ;
		}
		if (verbose) 
			printf("Adding %s  #%d\n", lp->RemoteNode, 
						lp->RemoteDSUNumber);
		ap->QueryListHead = AddData2Query(ap->QueryListHead, 
							lp->RemoteDSUNumber);
	}
#ifdef TESTING
	for ( ap=new; ap!=NULL; ap=ap->Next ) {
		fprintf(stderr,"Address: %s\n",ap->Address );
	}
#endif
	return(new);
}

/**************************************************************************
 *	PrintReport() - Print Report on the Variables Each  returned.  *
 **************************************************************************/
void PrintReport(AddressListHead)
struct AddressListType *AddressListHead;
{
	register struct AddressListType *A;
	register struct VarList *V;
	struct LinkDetail *LPtr;
	struct bindings *b;
	char *lookup_SNMP_name();
	int ifnum, bucket1, bucket2, bucket3, t, State;
	char buffer[100],temp[40], dataline[300], *s;
	extern void WriteDataLine(), DealWithDirtyLinks();

	for (A = AddressListHead; A != NULL; A = A->Next) {
		if (A->ResponseListHead == NULL) { 
			fprintf(stderr, "%s did not respond to if query\n",
								A->Address);
			continue;
		}
		if (A->QueryListHead != NULL) {
			printf("%s did not completely answer  Query\n",
								A->Address);
			continue;
		}
		
		for (V = A->ResponseListHead; V != NULL; V = V->Next) {
			if ((b=V->Head) == NULL) {
				fprintf(stderr,"%s %s (%s) did NOT respond\n",
					A->Address, V->VarName, V->Prefix);
				continue;
			}

			s = b->instance+strlen(lookup_SNMP_name(V->VarName));
			strcpy( dataline, buffer );
			ifnum = atoi(s);
			State = atoi(b->value);

			if ((LPtr = FindLinkDetail( A->Address, ifnum)) == NULL) {
				fprintf( stderr, "WriteDataLine - can't write %s dsu %d data - no link available\n", A->Address, ifnum );
				continue;
			}
			UpdateLinkTimeStamp( A->Address, ifnum );

			if ( strcmp(LPtr->LocalNode,A->Address) == 0 ) 
                		printf("%s LINK GENLINK %s %s %s %s %s\n",
                                	LPtr->LocalNode,
                                	LPtr->LocalNode,
                                	LPtr->LocalIPAddr,
                                	LPtr->RemoteIPAddr,
                                	LPtr->RemoteNode,
                                	State==1?"UP":"DOWN");
			else
                		printf("%s LINK GENLINK %s %s %s %s %s\n",
                                	LPtr->RemoteNode,
                                	LPtr->RemoteNode,
                                	LPtr->RemoteIPAddr,
                                	LPtr->LocalIPAddr,
                                	LPtr->LocalNode,
                                	State==1?"UP":"DOWN");
		}
	}
}

main(argc, argv)
int argc;
char *argv[];
{
	char *community = NULL, *workdir;
	struct AddressListType *NewAddressListHead = NULL;
	int c;
	extern int io_debug, DebugOnFailure;
	extern char *optarg, *getenv();
	char *network="nsfnett3";

#ifdef PROFILING
	monitor((caddr_t) NULL);
#endif
	progname = argv[0];
	while ((c = getopt(argc, argv, "n:c:dr:t:v")) != EOF)
		switch (c) {

                case 'd':
			io_debug = 1;
			/* now fall through */

                case 'v':       
			fprintf(stderr, "Verbose Mode = ON\n");
			DebugOnFailure = 1;
			verbose = 1;
			break;

                case 'c':
                        community = optarg;
                        break;

                case 'n':
                        network = optarg;
                        break;

                case 'r':
                        MaxSNMPRetries = atoi(optarg);
                        break;

                case 't':
                        MaxSecsB4Retry = atoi(optarg);
                        break;

                default:
			Usage();
			/*NOTREACHED*/
                }
	if (community == NULL) {
		fprintf( stderr," You MUST specify a community name\n");
		Usage();
	}
	
	if ((workdir = getenv("PINGKYDIR")) == NULL)
		workdir = DEFAULT_PINGKY_DIR;

	if ( network == NULL ) {
		fprintf(stderr,"You MUST specify a network that has a corresponding LINKS file in $PINGKYDIR\n");
		Usage();
	}

	Read_LinkDetail_File( network );
	NewAddressListHead = MakeAddressList( NewAddressListHead );
	NewAddressListHead=Get( NewAddressListHead, community, NULL );
	PrintReport( NewAddressListHead );
	NewAddressListHead = FreeAddressList( NewAddressListHead );
	Write_LinkDetail_File();
	return(0);
}
