/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *	Use fastsnmp API to get interface counters to make link width files
 *								
 *		Blast Out Queries to nodes		
 *		Process Received Table			
 *						
 * This program expects the LinkDetail file to contain accurate info	
 *	We are sending out one packet for each interface...could be optimized
 *	later.							
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include "CommonDefs.h"
#include "pathnames.h"
#include "snmptable2.h"
#include "Linkfileio.h"
#include "mib.h"
#include "LinkWidth.h"

#ifdef PROFILING
#include <mon.h>
#endif
char *progname;
char *label,*var;
char LinkWidthFileName[ MAXPATHLEN ];
int factor=100;

void Usage()
{
	extern void exit();

	fprintf(stderr,"Usage: %s [-r numretries ] [ -t timebetweenretires ] [-v] -c <community> -n <netname> -f <dividebyfactor> -l <label> -V <var>\n",progname);
	exit(1);
}

/************************************************************************
 *	AddData2Query() - Create VarList for this  interface	*
 ************************************************************************/
struct VarList * AddData2Query(head, ifnum)
struct VarList *head;
int ifnum;
{
	register struct VarList *vp;
	register int i;
	char Index[40], Var[50];

	sprintf(Index, "%d", ifnum);
	head=AddVar( head , var );
	for ( vp = head; vp->Next != NULL; vp = vp->Next )
			;
	strcat( vp->Prefix, Index );
	return( head );
}

/*
 *	ShiftAllCounters() - Take current counter and call it last counter
 *
 */
ShiftAllCounters()
{
int i;
	for ( i=0; i<LinkWidthCount; i++ ) {
		LinkWidthArray[i].LocalTimeLastCount=LinkWidthArray[i].LocalTimeCurrentCount;
		LinkWidthArray[i].LocalLastCount=LinkWidthArray[i].LocalCurrentCount;
		LinkWidthArray[i].LocalTimeCurrentCount=-1;
		LinkWidthArray[i].LocalCurrentCount=-1;
		LinkWidthArray[i].RemoteTimeLastCount=LinkWidthArray[i].RemoteTimeCurrentCount;
		LinkWidthArray[i].RemoteLastCount=LinkWidthArray[i].RemoteCurrentCount;
		LinkWidthArray[i].RemoteTimeCurrentCount=-1;
		LinkWidthArray[i].RemoteCurrentCount=-1;
	}
}

/************************************************************************
 *	MakeAddressList() - Make Address List with appropriate 	*
 *				VarList for the s this box has	*
 *	Note that this creates one packet per  - could be optimized  *
 ************************************************************************/
struct AddressListType * MakeAddressList(new)
struct AddressListType *new;
{
	struct AddressListType *ap;
	register struct LinkDetail *lp;
	extern struct LinkDetail *LinkDetailHead;
	struct in_addr remote, local;

	for (lp = LinkDetailHead; lp != NULL; lp = lp->Next) {
		for( ap=new; ap!=NULL; ap=ap->Next )
			if ( strcmp( ap->Address, lp->LocalNode ) == 0 )
				break;
		if ( ap == NULL ) {
			new = AddAddress(new, lp->LocalNode);
			for (ap = new; ap->Next != NULL; ap=ap->Next) ;
		}
		if (verbose) 
			printf("Adding %s  #%d\n", lp->LocalNode, 
							lp->LocalDSUNumber);
		ap->QueryListHead = AddData2Query(ap->QueryListHead, 
							lp->LocalDSUNumber);
		/*
		 *  Remote Address and 
		 */
                for( ap=new; ap!=NULL; ap=ap->Next )
                        if ( strcmp( ap->Address, lp->RemoteNode ) == 0 )
                                break;
                if ( ap == NULL ) {
			new = AddAddress(new, lp->RemoteNode);
			for (ap = new; ap->Next != NULL; ap = ap->Next) ;
		}
		if (verbose) 
			printf("Adding %s  #%d\n", lp->RemoteNode, 
						lp->RemoteDSUNumber);
		ap->QueryListHead = AddData2Query(ap->QueryListHead, 
							lp->RemoteDSUNumber);
		if ( FindLinkWidthEntry( lp->LocalNode, lp->RemoteNode ) == NULL )
			AddLinkWidthEntry( lp->LocalNode, lp->RemoteNode, 0,
						0,0,0,0,0,0,0,0,0,0 );
	}
#ifdef TESTING
	for ( ap=new; ap!=NULL; ap=ap->Next ) {
		fprintf(stderr,"Address: %s\n",ap->Address );
	}
#endif
	return(new);
}

/**************************************************************************
 * Process Returned variables
 **************************************************************************/
void ProcessReturnedVars(AddressListHead)
struct AddressListType *AddressListHead;
{
	register struct AddressListType *A;
	register struct VarList *V;
	struct LinkDetail *LPtr;
	struct LinkWidth *LW;
	time_t TimeNow=time(&TimeNow);
	struct bindings *b;
	char *lookup_SNMP_name();
	int ifnum, bucket1, bucket2, bucket3, t;
	char buffer[100],temp[40], dataline[300], *s;

	for (A = AddressListHead; A != NULL; A = A->Next) {
		if (A->ResponseListHead == NULL) { 
			fprintf(stderr, "%s did not respond to if query\n",
								A->Address);
			continue;
		}
		if (A->QueryListHead != NULL) {
			printf("%s did not completely answer  Query\n",
								A->Address);
			continue;
		}
		
		for (V = A->ResponseListHead; V != NULL; V = V->Next) {
			if ((b=V->Head) == NULL) {
				fprintf(stderr,"%s %s (%s) did NOT respond\n",
					A->Address, V->VarName, V->Prefix);
				continue;
			}

			s = b->instance+strlen(lookup_SNMP_name(V->VarName));
			strcpy( dataline, buffer );
			ifnum = atoi(s);

			if ((LPtr = FindLinkDetail( A->Address, ifnum)) == NULL) {
				fprintf( stderr, "WriteDataLine - can't write %s dsu %d data - no link available\n", A->Address, ifnum );
				continue;
			}
			if ((LW=FindLinkWidthEntry( LPtr->LocalNode, LPtr->RemoteNode ) ) == NULL ) {
				fprintf(stderr,"Can't find %s - %s in link width file\n",
					LPtr->LocalNode,LPtr->RemoteNode);
				continue;
			}
			/* Convert from the ASCII form the lower layers provide
			   into an unsigned long				 */
			if ( strcmp( A->Address, LW->Node1 ) == 0 ) {
				LW->LocalTimeCurrentCount=TimeNow;
				{
					unsigned long u=0;
					char *p=b->value;

					while( *p )
						u = u*10 + ( *p++ - '0' );
					LW->LocalCurrentCount=u;
					/*printf("After conversion s=%s u=%lu\n",b->value, u );*/
				}
			}
			else {
				LW->RemoteTimeCurrentCount=TimeNow;
				{
					unsigned long u=0;
					char *p=b->value;

					while( *p )
						u = u*10 + ( *p++ - '0' );
					LW->RemoteCurrentCount=u;
					/*printf("After conversion s=%s u=%lu\n",b->value, u );*/
				}
			}
		}
	}
}

/**************************************************************************
 * PrintReport
 **************************************************************************/
void PrintReport()
{
int i,LocalSideAnswered,RemoteSideAnswered;
long LocalDeltaCount,LocalDeltaTime,LocalPS;
long RemoteDeltaCount,RemoteDeltaTime,RemotePS;

	for ( i=0; i<LinkWidthCount; i++ ) {
		LocalSideAnswered=RemoteSideAnswered=1;	/* Assume both sides answered */
		if ( LinkWidthArray[i].LocalCurrentCount == -1 ) {  /* NO ANSWER ? */
			LinkWidthArray[i].LocalTimeCurrentCount=LinkWidthArray[i].LocalTimeLastCount;
			LinkWidthArray[i].LocalCurrentCount=LinkWidthArray[i].LocalLastCount;
			LocalSideAnswered=0;
			fprintf(stderr,"Local side (%s-%s) didn't answer - assuming no change\n",LinkWidthArray[i].Node1,LinkWidthArray[i].Node2);
		}
		if ( LinkWidthArray[i].RemoteCurrentCount == -1 ) {
			LinkWidthArray[i].RemoteTimeCurrentCount=LinkWidthArray[i].RemoteTimeLastCount;
			LinkWidthArray[i].RemoteCurrentCount=LinkWidthArray[i].RemoteLastCount;
			RemoteSideAnswered=0;
			fprintf(stderr,"Remote side (%s-%s) didn't answer - assuming no change\n",LinkWidthArray[i].Node1,LinkWidthArray[i].Node2);
		}
		/* Calculate delta counts and delta times */
		LocalDeltaCount=LinkWidthArray[i].LocalCurrentCount-LinkWidthArray[i].LocalLastCount;
		LocalDeltaTime=LinkWidthArray[i].LocalTimeCurrentCount-LinkWidthArray[i].LocalTimeLastCount;
		RemoteDeltaCount=LinkWidthArray[i].RemoteCurrentCount-LinkWidthArray[i].RemoteLastCount;
		RemoteDeltaTime=LinkWidthArray[i].RemoteTimeCurrentCount-LinkWidthArray[i].RemoteTimeLastCount;

		/* Calculate delta per second */
		if ( LocalSideAnswered ) LocalPS=LocalDeltaCount/LocalDeltaTime;
		else LocalPS=0;
		if ( RemoteSideAnswered ) RemotePS=RemoteDeltaCount/RemoteDeltaTime;
		else RemotePS=0;
		LinkWidthArray[i].LocalPS=LocalPS;
		LinkWidthArray[i].RemotePS=RemotePS;

		/* Take larger of the two rates, and divide by the factor */
		if ( LocalPS > RemotePS )
			LinkWidthArray[i].LinkWidth=LocalPS/factor;
		else
			LinkWidthArray[i].LinkWidth=RemotePS/factor;

		fprintf(stderr,"%s %ld %ld %ld (%ld) %ld %ld %ld %s\n",
			LinkWidthArray[i].Node1,
			LocalDeltaTime, LocalDeltaCount, LocalPS, 
			LinkWidthArray[i].LinkWidth,
			RemoteDeltaTime, RemoteDeltaCount, RemotePS,
			LinkWidthArray[i].Node2);
		
#define RAWREPORT 
#ifdef RAWREPORT
		fprintf(stderr,"%s %ld %ld %ld %ld (%d) %ld %ld %ld %ld %s\n",
		LinkWidthArray[i].Node1,
		LinkWidthArray[i].LocalTimeCurrentCount,
		LinkWidthArray[i].LocalCurrentCount,
		LinkWidthArray[i].LocalTimeLastCount,
		LinkWidthArray[i].LocalLastCount,
		LinkWidthArray[i].LinkWidth,
		LinkWidthArray[i].RemoteTimeCurrentCount,
		LinkWidthArray[i].RemoteCurrentCount,
		LinkWidthArray[i].RemoteTimeLastCount,
		LinkWidthArray[i].RemoteLastCount,
		LinkWidthArray[i].Node2);
		fprintf( stderr,"LocalDeltaCount=%ld LocalDeltaTime=%ld LocalPS=%ld\nRemoteDeltaCount=%ld RemoteDeltaTime=%ld RemotePS=%ld\n",LocalDeltaCount,LocalDeltaTime,LocalPS,RemoteDeltaCount,RemoteDeltaTime,RemotePS );
#endif
	}
}

main(argc, argv)
int argc;
char *argv[];
{
	char *community = NULL, *workdir;
	struct AddressListType *NewAddressListHead = NULL;
	int c;
	extern int io_debug, DebugOnFailure;
	extern char *optarg, *getenv();
	char *network,*Class;

#ifdef PROFILING
	monitor((caddr_t) NULL);
#endif
	progname = argv[0];
	while ((c = getopt(argc, argv, "V:l:vf:n:c:dr:t:v")) != EOF)
		switch (c) {

                case 'd':
			io_debug = 1;
			/* now fall through */

                case 'v':       
			fprintf(stderr, "Verbose Mode = ON\n");
			DebugOnFailure = 1;
			verbose = 1;
			break;

                case 'c':
                        community = optarg;
                        break;

                case 'n':
                        network = optarg;
                        break;

                case 'r':
                        MaxSNMPRetries = atoi(optarg);
                        break;

                case 't':
                        MaxSecsB4Retry = atoi(optarg);
                        break;
		case 'l':
			label=optarg;
			break;
		case 'V':
			var=optarg;
			break;
		case 'f':
			factor=atoi(optarg);
			if ( factor <= 0 ) {
				fprintf(stderr,"factor must be a positive int\n");
				Usage();
			}
			break;
                default:
			Usage();
			/*NOTREACHED*/
                }
	if (community == NULL) {
		fprintf( stderr," You MUST specify a community name\n");
		Usage();
	}
	if ( label == NULL) {
		fprintf( stderr," You MUST specify a linkwidth label\n");
		Usage();
	}
	if ( var == NULL) {
		fprintf( stderr," You MUST specify a MIB var to query\n");
		Usage();
	}
	
	if ((workdir = getenv("PINGKYDIR")) == NULL)
		workdir = DEFAULT_PINGKY_DIR;

	if ( network == NULL ) {
		fprintf(stderr,"You MUST specify a network that has a corresponding LINKS file in $PINGKYDIR\n");
		Usage();
	}
	Class=(char *) malloc( strlen(network + 1 ) );
	if ( Class==NULL ) {
		fprintf(stderr,"malloc failed in main()\n"); 
		exit(1); 
	}
	strcpy( Class, network );
	if ( islower(*Class) ) *Class=toupper( *network );

	Read_LinkDetail_File( network );
	sprintf( LinkWidthFileName, "%s/%s.%s.LW",workdir,Class,label);
	ReadLinkWidthFile( LinkWidthFileName );
	NewAddressListHead = MakeAddressList( NewAddressListHead );
	if ( NewAddressListHead == NULL ) {
		fprintf(stderr,"No nodes to query\n");
		exit(1);
	}
	ShiftAllCounters( );	/* Make last counters=current */
				/* Now fetch current counters */
	NewAddressListHead=Get( NewAddressListHead, community, NULL );
	ProcessReturnedVars( NewAddressListHead );
	PrintReport( );
	WriteLinkWidthFile( LinkWidthFileName );
	return(0);
}
