/************************************************************************
 *		snmpstats.c	-Poll nodes in hostfile for stats	* 
 *									*
 *	The community and host list is currently statically configured	*
 * as being in a file in /u/snmp/etc/%s.snmp.hosts and community.	*
 ************************************************************************/

/*#define TESTING	/*  Don't actually DO anything - just print out data */
#define _BSD 1
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "snmptable2.h"

char *progname;

char *NetworkName;
char *CommunityName=NULL;
char *RtdataPrefix="/";
char OutputFilePrefix[1000];
int appverbose=0;

char *datestr( timenow )
long *timenow;
{
static char buffer[20];
struct tm *timestruct;
char *timestr;

    timestruct = localtime( timenow );
    sprintf(buffer,"%.2d%.2d%.2d",
        timestruct->tm_year,
        timestruct->tm_mon+1,
        timestruct->tm_mday);
   return(buffer);
}

struct AddressListType *GetHostList( Net )
char *Net;
{
char hostfile[150], communityfile[50];
char buffer[1024];
char *p;
FILE *stream;
struct AddressListType *AddressListHead=NULL;
char *home, *getenv();

	if ((home=getenv("HOME"))==NULL) home=".";
	sprintf( hostfile, "%s/etc/%s.snmp.hosts",home,Net );
	sprintf( communityfile, "%s/etc/%s.snmp.community",home,Net );
	if ((stream=fopen(hostfile,"r"))==NULL) {
		fprintf(stderr,"fopen hostfile %s\n",hostfile);
		exit(1);
	}
	while( fgets( buffer, sizeof(buffer), stream) != NULL ) 
		AddressListHead=AddAddress(AddressListHead, strtok(buffer," \t\n"));
	fclose( stream );
	if ( CommunityName == NULL ) {
		if ((stream=fopen(communityfile,"r"))==NULL) {
			fprintf(stderr,"fopen community file %s - defaulting to public\n",communityfile);
			CommunityName="public";
		} else {
			fgets( buffer, sizeof(buffer), stream);
			p=strtok( buffer, " \t\n");
			
			CommunityName=(char *)malloc(strlen(p)+1);
			strcpy( CommunityName, p );
			fclose( stream );
		}
	}
	strcpy(OutputFilePrefix,RtdataPrefix);
	strcat(OutputFilePrefix,"/rtdata");
	if ( mkdir( OutputFilePrefix, 0755 ) != 0 )
		if ( appverbose )
			perror( "Create OutputFilePrefix with rtdata failed");
	strcat(OutputFilePrefix,"/");
	strcat(OutputFilePrefix,Net);
	if ( mkdir( OutputFilePrefix, 0755 ) != 0 )
		if ( appverbose )
			perror( "Create OutputFilePrefix with rtdata and net failed");
	strcat(OutputFilePrefix,"/snmp");
	if ( mkdir( OutputFilePrefix, 0755 ) != 0 )
		if ( appverbose )
			perror( "Create OutputFilePrefix with rtdata net and snmp failed");
	strcat(OutputFilePrefix,"/");
	return( AddressListHead );
}

ProcessSNMPData( host, ResponseList, collectedtime )
char *host;
struct VarList *ResponseList;
long collectedtime;
{
char OutputFileDir[200];
char OutputFileName[300];
char TimeStamp[30];
struct VarList *R;
struct bindings *B;
FILE *stream;
struct stat statstruct;

	if ( ResponseList == NULL ) return;

	if (collectedtime==0) collectedtime=time(&collectedtime);
	strcpy(OutputFileDir,OutputFilePrefix); 
	strcat(OutputFileDir,host);
	if ( stat( OutputFileDir, &statstruct ) == -1 ) {
		printf("Creating output directory: %s\n",OutputFileDir );
#ifndef TESTING
		if (mkdir( OutputFileDir, 0755 )==-1) fprintf(stderr,"mkdir %s failed\n",OutputFileDir);
#endif
	}
	strcat(OutputFileDir,"/");	
	for( R=ResponseList; R!=NULL; R=R->Next ) {
		strcpy(TimeStamp,ctime(&collectedtime));
		strcpy(OutputFileName,OutputFileDir);
		strcat(OutputFileName,R->VarName); strcat(OutputFileName,".");
		strcat(OutputFileName,datestr(&collectedtime));
#ifndef TESTING
		if ((stream=fopen(OutputFileName,"a"))==NULL) {
			printf("Unable to open output file %s\n",OutputFileName);
			perror("fopen ");
		}
		else {
			fputs(TimeStamp,stream);
#else
			fprintf(stderr,"File=%s\n",OutputFileName);
			fputs(TimeStamp,stderr);
#endif
			for( B=R->Head; B!=NULL; B=B->Next ) {
#ifdef TESTING
				fprintf(stderr,"%s %s\n",
					B->instance+strlen(R->Prefix),B->value);
#else
				fprintf(stream,"%s %s\n",B->instance+strlen(R->Prefix),B->value);
#endif
			}
#ifndef TESTING
			fclose(stream);
		}
#endif

	}
}

Usage()
{
	fprintf(stderr,"Usage: %s [-g -d -v [-h [host]] [-c [community]] ] NETWORK vars\n\
Where:\n\
-g - means do a get\n\
-v - means verbose\n\
-a - means application verbose\n\
-d - means io_debug and verbose\n\
-h host - allows you to ask only certain hosts\n\
-c community - allows you to override the default community\n\
-r # - specifies the number of retries before giving up\n\
-t # - specifies the number of seconds bewteen retries\n\
-p prefix - specifies where in the file struture to START the /rtdata tree\n\n\
Note:   there is expected to exist a file named: %s/etc/%s.snmp.hosts\n\
        that contains the names or ipaddresses of the nodes in the NETWORK\n\n\
        there is expected to exist a file named: %s/etc/%s.snmp.community\n\
	that contains the community name for the network.  \n",progname);
	exit(1);
}

main( argc, argv )
int argc;
char *argv[];
{
struct AddressListType *AddressListHead=NULL, *A;
struct VarList *QueryListHead=NULL;
int hostcount=0,i;
long TimeNow=time(&TimeNow),StopTime;
int RespondingNodes=0,NonRespondingNodes=0;
int Function=3;
extern int io_debug;

	progname=argv[0];

        argv++; argc--;
        while(*argv && argv[0][0] == '-') {
                switch(argv[0][1]) {
                case 'd':
			io_debug=1;
                case 'v':
                        fprintf(stderr,"Verbose Mode=ON\n");
                        verbose=1;
                        argv++; argc--;
                        break;
                case 'a':
                        fprintf(stderr,"Application Verbose Mode=ON\n");
                        appverbose=1;
                        argv++; argc--;
                        break;
                case 'h':
                        AddressListHead=AddAddress( AddressListHead, argv[1] );
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'c':
                        CommunityName=argv[1];
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'p':
                        RtdataPrefix=argv[1];
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'g':
                        Function=1;
                        argv++; argc--;
                        break;
                case 'r':
                        argv++; argc--;
                        if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
                                MaxSNMPRetries=atoi(argv[0]);
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;
                case 't':
                        argv++; argc--;
                        if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
                                MaxSecsB4Retry=atoi(argv[0]);
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;

                default:
                        fprintf(stderr,"unknown option %s ignored\n(Valid options are: -v )\n",argv[1]);
                        argv++; argc--;
                        break;
                }
        }

	if ( argc < 2 ) Usage();
	NetworkName=argv[0];
	if ( AddressListHead == NULL )
		AddressListHead=GetHostList( NetworkName );

	for ( i=1; i<argc; i ++ )
		QueryListHead=AddVar( QueryListHead, strtok(argv[i]," \t\n") );

	switch( Function ) {
	case 1:
		AddressListHead=Get( AddressListHead, CommunityName, QueryListHead );
		break;
	case 3:
		AddressListHead=GetTable( AddressListHead, CommunityName, QueryListHead );
		break;
	}
        for( A=AddressListHead; A!=NULL; A=A->Next ) {
		hostcount++;
                if (A->QueryListHead!=NULL) {
			fprintf(stderr,"%s did not respond \n",A->Address);
			NonRespondingNodes++;
		}
		else RespondingNodes++;
		ProcessSNMPData( A->Address, A->ResponseListHead, A->LastResponded );
		/** Why process the unanswered queries?  So we have alog that
		the data collection attempt occured.. So, here we go. **/
		ProcessSNMPData( A->Address, A->QueryListHead, A->LastResponded );
	}
	StopTime=time(&StopTime);
	printf("%s Elapsed Time SNMP polling %s was %d seconds\nQuerying %d nodes for %d vars or tables:\n",ctime(&StopTime),
			NetworkName,StopTime-TimeNow,hostcount,argc-1);
	for ( i=1; i< argc; i++ ) printf("%s ",argv[i]);
	printf("\n");
	printf("Statistics: %d Nodes Responded, %d Nodes Did Not\n",RespondingNodes,NonRespondingNodes);
}

