/* Routines that deal with VarList Structures */

#include <stdio.h>
#include <time.h>
#include <string.h>
#include "ctools.h"
#include "VarList.h"

/************************************************************************
 * struct VarList *MakeVar( char *var, char *encoding )                 *
 *      Makes a VarList structure and returns a pointer to it           *
 ************************************************************************/
struct VarList *MakeVar(var, encoding)
     char *var;
     char *encoding;
{
struct VarList *v;
void fastsnmpsyserr();

     if ((v = (struct VarList *)malloc( sizeof( struct VarList ) ))== NULL)
             fastsnmpsyserr("AddVarList VarList malloc Failed");

	/****** Allow for instance to be added to the end of Var Prefix ***/
     if ((v->Prefix=(char *)malloc( strlen(encoding)+20 ))==NULL)
             fastsnmpsyserr("AddVarList Prefix malloc Failed");
     strcpy( v->Prefix, encoding );
     if ((v->VarName=(char *)malloc(strlen(var)+1))==NULL)
             fastsnmpsyserr("AddVarList() VarName malloc Failed");
     strcpy( v->VarName, var );
     return( v );
}

/************************************************************************
 * struct VarList *AddVarToChain( VarListHead, v )                      *
 *      Adds a VarListStructure to chain pointer to by VarListHead      *
 *      returns Pointer to Head of Varlist Chain                        *
 ************************************************************************/
struct VarList *AddVarToChain(VarListHead, v)
     struct VarList *VarListHead;
     struct VarList *v;
{
struct VarList *v2;

     if ( VarListHead==NULL) {
	VarListHead=v;
	v->Prev = NULL;
     } else {
	for( v2=VarListHead; v2->Next!=NULL; v2=v2->Next);
        v->Prev=v2;
        v2->Next=v;
     }
     v->Next=NULL;
     v->Head=NULL;
     return( VarListHead );
}

/************************************************************************
 * DupVarAndChain( Head,v )                                             *
 *      Duplicates a VarList structure and adds to the passed chain     *
 *      returns updated chain pointer                                   *
 ************************************************************************/
struct VarList *DupVarAndChain(Head, v)
     struct VarList *Head;
     struct VarList *v;
{
	return(AddVarToChain( Head, MakeVar( v->VarName, v->Prefix )));
}

/************************************************************************
 * AddVar() - Creates a VarList structure and adds to VarList Chain     *
 *              returns updated VarList chain pointer                   *
 ************************************************************************/
struct VarList *AddVar(VarListHead, var)
     struct VarList *VarListHead;
     char *var; 
{
char *encoding=NULL,*NametoID();
char variable[200],*p;
int once;

        if ( var == NULL ) {
                fprintf(stderr,"AddVarList(): called with NULL var\n");
		return( VarListHead );
        } 
        for( p=var; *p!='\0'; p++ )	/*  made this inline @wbn */
                if ( (*p=='\t') || (*p=='\n')) *p=' ';
        /*var=trim(var);          /* remove newlines and tabs */
	if ( isdigit(*var)) {
		fprintf(stderr,"Numeric coding not allowed in this preliminary version\n");
		return( VarListHead );;
	}
#ifdef BROKEN
	strcpy( variable, var );
	while( strlen(variable)!=0 ) {
		encoding= (char *) NametoID(variable);
		if ( (encoding==NULL) || (strlen(encoding)==0) ) 
			variable[strlen(variable)-1]='\0';
		else break;
	}

	if ( strlen(variable)==0 )
                fprintf(stderr,"Unknown SNMP var: %s\n",var);
         else {
		/*** Copy object ID after encoding ***/
		if ( strlen(variable) != strlen(var) )
			strcat( encoding, &var[ strlen(variable) +1 ] );
		VarListHead=AddVarToChain( VarListHead, MakeVar( var, encoding));
	}
#endif
	strcpy( variable, var );
	p=variable;
	for( p=variable; ((*p!='\0') && (*p!='.')); p++ );
	if ( *p=='.' ) {
		*p='\0'; 
		p++;
	} else p=NULL;
        if (((encoding=NametoID(variable))==NULL)||(strlen(var)==0)) {
                fprintf(stderr,"Unknown SNMP variable: %s\n",variable);
        } else {
		if ( p ) {	/* instance was included by caller */
			once=0;
			for( p=strtok( p,". \t\n"); p; p=strtok(NULL,". \t\n")) {
				if( once++ ) strcat( encoding,".");
				strcat( encoding, p );
			}
		}
		VarListHead=AddVarToChain( VarListHead, MakeVar( var, encoding));
	}

#ifdef OLD
        if (((encoding=NametoID(var))==NULL)||(strlen(var)==0)) {
                fprintf(stderr,"Unknown SNMP var: %s\n",var);
        } else 
		VarListHead=AddVarToChain( VarListHead, MakeVar( var, encoding));
#endif
        return( VarListHead );
}

/************************************************************************
 * FreeVarListChain( ) - Free a VarListChain                            *
 *      Always Returns NULL                                             *
 ************************************************************************/
struct VarList *FreeVarListChain(vptr)
     struct VarList *vptr;
{
struct VarList *v,*v2;

        for( v=vptr; v!=NULL; v=v2 ) {
		v->Head=FreeBindingChain( v->Head );
                v2=v->Next;
                free(v);
        }
	return( NULL );
}
