/*
 * rtdata.c
 *
 * Simple client for the real-time data server.
 *
 * Tom Libert
 * Copyright 1991 Merit/NSFNET.  All Rights Reserved.
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include <pwd.h>

#define VPRINTF if (vflag) printf

#define TRUE 1
#define FALSE 0

#define EVER ;;

#define PORT 3001

#define SECS_PER_HOUR 60*60
#define SECS_PER_MIN  60

#define DEFAULT_OBJECT    "problemlog"
#define DEFAULT_DIRECTORY "rover/logs/InetRover"
#define DEFAULT_FILE      "hostfile"
#define DEFAULT_HOURS     24

char *server_name, new_server[30];

static char *servers[] =
{
        " ",
	"whitman.merit.edu",
	"melville.merit.edu",
	0
};

/*
 * Telnet option negotiation stuff
 */
#define IAC  255
#define WILL 251
#define WONT 252
#define DO   253
#define DONT 254
#define ECHO 1

FILE *outfp, *readfp, *writefp;

#define RANGE "1234567890."

int Argc;
char **Argv;

typedef unsigned char BOOLEAN;
BOOLEAN eflag, hflag, sflag, lflag, uflag, oflag, pflag, mflag, vflag;

extern char *getpass();
extern char *getlogin();

extern char *optarg;
extern int optind;

unsigned long minute;
char pattern[36]; /* for pattern matching */
char utol[128];	/* For performing case conversion */

time_t s_unixtime, e_unixtime;

typedef struct GROUP {
   char name1[40];
   unsigned long sum;
   short total;
   float avg;
   struct GROUP *prev;
   struct GROUP *next;
   struct UNIT  *uhead;
} group;

typedef struct UNIT {
   char name2[40];
   unsigned long sum;
   unsigned int	max;
   unsigned int num;
   struct UNIT *prev;
   struct UNIT *next;
} unit;

typedef struct ETHER {
   char name[40];
   unsigned long sum;
   struct ETHER *next;
} ether;

static group *ghead;
static ether *ehead;
