/*
 * $Header$
 */

/*
 * To lock a file for a specified period of time. Use to check how netlog
 * handles extended locks on lockfiles. Netlog should mail the entry out
 *
 *	Vikas@jvnc.net
 */

#include "netlog.h" ;

main(ac, av)
     char **av ;
{
    int sleeptime ;
    int lockfd ;

    if (ac == 1)
      sleeptime = 60 ;			/* default lock for 60 secs */
    else
      sscanf(av[1], "%d", &sleeptime) ;

    umask(NETUMASK) ;

    chdir (LOCKDIR);

    printf("Locking file: '%s/%s' for %d secs...", LOCKDIR, LOGLOCK, sleeptime) ;
    fflush(stdout) ;
    lockfd = open(LOGLOCK, O_WRONLY, 0666);
    lock_file(lockfd, "w", 0, 2) ;
    sleep ( (unsigned) sleeptime) ;
    unlock_file (lockfd) , close(lockfd);
    printf(" unlocked\n");


    printf("Locking file: '%s' for %d secs...", OTLOCK, sleeptime) ;
    fflush(stdout) ;
    lockfd = open(OTLOCK, O_WRONLY, 0666);
    lock_file(lockfd, "w", 0, 2) ;
    sleep ( (unsigned) sleeptime) ;
    unlock_file (lockfd) , close (lockfd) ;
    printf(" unlocked\n");


    printf("Locking file: '%s' for %d secs...", PTLOCK, sleeptime) ;
    fflush(stdout) ;
    lockfd = open(PTLOCK, O_WRONLY, 0666);
    lock_file(lockfd, "w", 0, 2) ;
    sleep ( (unsigned) sleeptime) ;
    unlock_file (lockfd) , close (lockfd);
    printf(" unlocked\n");


    exit(0) ;
}
    
