
/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: buildbms.c   SID: 2.1 8/6/89 22:24:29
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 *
 ******************************************************************************/
/*
 * Multi-user DBMS simulation.
 * Initialization
 * Database has the form:
 * IIIINNNNNNNNNNNNNNNNNNNNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPPPPPPPPPP
 * Where IIII is the 4-digit id number (0-padded)
 *       NN... is the 20-character name
 *       AA... is the 40-character address
 *       PP... is the 10-character phone number
 * Records are accessed by ID number (1 is the 0th record, 2 is 1st..etc.)
 *
 * Execute this program with:
 *    buildbms <filename> <n>
 *      where <filename> is the name of the database file and
 *            <n> is the number of records to create in the database.
 */
char id[] = "@(#) @(#)buildbms.c:2.1 -- 8/6/89 22:24:29";

#include <stdio.h>

#define ERROR (-1)

/*
** Record definitions.
*/

#define IDLEN 4
#define NAMELEN 20
#define ADDRLEN 40
#define PHONLEN 10
#define RECLEN  74	/* Sum of the above. */

/*
** Structures.
*/

struct dbrec {			/* Database record */
	char id[IDLEN];
	char name[NAMELEN];
	char address[ADDRLEN];
	char phone[PHONLEN];
	};

/*
** Structure instances.
*/
struct dbrec myrec;

FILE *dbfp;			/* Pointer for database file */

main(argc,argv)
int argc;
char *argv[];

{

	int i,j;		/* Loop variables */

	/*
	** Make sure we have the proper data.
	*/
	if(argc!=3)
	{
		fprintf(stderr,"usage: %s <filename> <n>\n",argv[0]);
		exit(1);
	}
	/*
	** Create the file. 
	** Also notice that we are using binary mode.
	*/
	if((dbfp=fopen(argv[1],"a+"))==NULL)
	{
		fprintf(stderr,"**Open error on: %s\n",argv[1]);
		exit(1);
	}

	j=atoi(argv[2]);
	for(i=0;i<j;i++)
	{
		sprintf(myrec.id,"%#04d",i+1);
		loadrec(i%10);
		fwrite((char *)&myrec,RECLEN,1,dbfp);
	}

	fclose(dbfp);
	exit(0);
}

/*
** Load the record up with random data.
*/
loadrec(sel)
int sel;		/* Select which fake record */

{

	char *nname;
	char *naddr;
	char *nphon;

	switch(sel)
	{
	case 0:	nname="Tom Thompson        ";
		naddr="9401 Billy Willy Road                   ";
		nphon="3334442222";
		break;
	case 1: nname="Steve Apiki         ";
		naddr="50 Hawaii Way c/o Jack Lord             ";
		nphon="1234443333";
		break;
	case 2: nname="Stan Diehl          ";
		naddr="27 Hoptoad Hollow Way                   ";
		nphon="3332221111";
		break;
	case 3: nname="Judy Grehan         ";
		naddr="Suite 3, WallState Building             ";
		nphon="9995556666";
		break;
	case 4: nname="Aaron Richards      ";
		naddr="Highway 40 OverPass, Second Pylon       ";
		nphon="8883339999";
		break;
	case 5: nname="Benjamin Davidson   ";
		naddr="Under The Bridge, HeavyWater City       ";
		nphon="7773229988";
		break;
	case 6: nname="Dayle Woolston      ";
		naddr="4040 Pleasant Way, WICAT Central        ";
		nphon="2228332299";
		break;
	case 7: nname="Jim Carls           ";
		naddr="Big Oak Tree Behind Barsodie's          ";
		nphon="32244566657";
		break;
	case 8: nname="Steve Smith         ";
		naddr="7000 Aloth Cove                         ";
		nphon="2118332929";
		break;
	case 9: 
	default: nname="Blind Willy Chitlins";
		naddr="Unavailable Until Further Notice        ";
		nphon="3456789012";
		break;
	}

	/*
	** Fill the structure with fake data.
	*/
	strncpy(myrec.name,nname,NAMELEN);
	strncpy(myrec.address,naddr,ADDRLEN);
	strncpy(myrec.phone,nphon,PHONLEN);

	return;
}


