/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: mem.c   SID: 2.1 8/6/89 22:24:26
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 *  $Header: mem.c,v 3.5 87/08/06 08:11:10 kenj Exp $
 *
 ******************************************************************************/
char SCCSid[] = "@(#) @(#)mem.c:2.1 -- 8/6/89 22:24:26";
/*
 * mem [ -ssize ] [ -niter ]
 *
 *  perform int array accesses
 *  array size (if given) is in bytes, default is 8K
 *  iter accesses of each type, default is iter=1,000,000
 *  Configuration options
 *  #ifdef random	random access
 *  #ifndef random	sequential access
 *  #ifdef awk		output on stderr for benchmark script
 *
 *  #ifdef BSD4v1	4.1 BSD, ftime() exists
 *  #ifdef BSD4v2	4.2 BSD, gettimeofday() exists
 *  #ifdef SysV		System V, times() returns real time
 *
 */

#include <sys/types.h>
#include <sys/times.h>
#ifdef BSD4v1
#include <sys/timeb.h>
#endif
#ifdef BSD4v2
#include <sys/time.h>
#include <sys/resource.h>
#endif
#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
        int            *tab;
        register char   *p;
        register int    i;
        register int    j;
        register int    mask;
        register int    k;
	long	     	iter = 1000000;
	int     	size = 8*1024 / sizeof(int);
	struct tms	tbuffer;
	long		access[2];
	long		ohead[2];
#ifdef BSD4v1
	struct timeb	tbuf;
	int		msec;
#endif
#ifdef BSD4v2
	struct timeval	tbuf;
	struct timezone	tzone;
	struct rusage	rubuf;
	long		rusec, cpusec;
#endif
	char		*prog = argv[0];
        char            *malloc();
#ifdef random
	long		index[1000];
#endif

        while (argc-- > 1) {
                switch (argv[1][1]) {
                case 's':
                        size = atoi(&argv[1][2]) / sizeof(int);
                        break;
                case 'n':
                        iter = atoi(&argv[1][2]);
                        break;
                default:
                        printf("Usage: %s [-ssize] [-niter]\n", prog);
                        exit(1);
                }
                argv++;
        }

        mask = size / sizeof(int);

	/* create memory space for data */
        if ((tab = (int *)malloc(size*sizeof(int))) == (int *)0) 
		{
                fprintf(stderr,"%s: malloc failed for %d bytes\n",
		      prog, size*sizeof(int));
                exit(1);
                }

#ifdef random
	/* build random array index map */
	for (i = 0; i < 1000; i++)
		index[i] = rand() % mask;
#endif

        /* measure overhead for loop */
	srand(1);
#ifdef SysV
        ohead[0] = -times(&tbuffer);
	ohead[1] = -tbuffer.tms_utime - tbuffer.tms_stime;
#else
#ifdef BSD4v1
        times(&tbuffer);
	ftime(&tbuf);
	ohead[0] = -tbuf.time;
	msec = tbuf.millitm;
	ohead[1] = -tbuffer.tms_utime - tbuffer.tms_stime;
#else
#ifdef BSD4v2
	gettimeofday(&tbuf, &tzone);
	getrusage(RUSAGE_SELF, &rubuf);
	ohead[0] = -tbuf.tv_sec;
	rusec = tbuf.tv_usec;
	ohead[1] = -rubuf.ru_utime.tv_sec - rubuf.ru_stime.tv_sec;
	cpusec = rubuf.ru_utime.tv_usec + rubuf.ru_stime.tv_usec;
#else
	What sort of Unix system is this?
#endif
#endif
#endif
        /* this loop doesn't look like it will be optimized out of
	existence, but be careful -ben */
        for (i = 0, k = 0; i < iter; i++) {
#ifdef random
                j = index[k];
		k++;
		if (k >= 1000) k = 0;
#else
		j = i % mask;
#endif
	}
#ifdef SysV
	ohead[0] += times(&tbuffer);
	ohead[1] += tbuffer.tms_utime + tbuffer.tms_stime;
#else
#ifdef BSD4v1
        times(&tbuffer);
	ftime(&tbuf);
	ohead[0] += tbuf.time;
	ohead[0] = ohead[0]*1000 + tbuf.millitm - msec;
	ohead[1] += tbuffer.tms_utime + tbuffer.tms_stime;
#else
#ifdef BSD4v2
	gettimeofday(&tbuf, &tzone);
	getrusage(RUSAGE_SELF, &rubuf);
	ohead[0] += tbuf.tv_sec;
	ohead[0] = ohead[0]*1000 + (tbuf.tv_usec - rusec)/1000;
	ohead[1] += rubuf.ru_utime.tv_sec + rubuf.ru_stime.tv_sec;
	ohead[1] = ohead[1]*60 + 60*(rubuf.ru_utime.tv_usec + rubuf.ru_stime.tv_usec - cpusec)/1000000;
#endif
#endif
#endif
        
        /* perform accesses */
	srand(1);
#ifdef SysV
        access[0] = -times(&tbuffer);
	access[1] = -tbuffer.tms_utime - tbuffer.tms_stime;
#else
#ifdef BSD4v1
        times(&tbuffer);
	ftime(&tbuf);
	access[0] = -tbuf.time;
	msec = tbuf.millitm;
	access[1] = -tbuffer.tms_utime - tbuffer.tms_stime;
#else
#ifdef BSD4v2
	gettimeofday(&tbuf, &tzone);
	getrusage(RUSAGE_SELF, &rubuf);
	access[0] = -tbuf.tv_sec;
	rusec = tbuf.tv_usec;
	access[1] = -rubuf.ru_utime.tv_sec - rubuf.ru_stime.tv_sec;
	cpusec = rubuf.ru_utime.tv_usec + rubuf.ru_stime.tv_usec;
#endif
#endif
#endif
        for (i = 0, k = 0; i < iter; i++) {
#ifdef random
                j = tab[index[k]];
		k++;
		if (k >= 1000) k = 0;
#else
		j = tab[i % mask];
#endif
	}
#ifdef SysV
	access[0] += times(&tbuffer);
	access[1] += tbuffer.tms_utime + tbuffer.tms_stime;
#else
#ifdef BSD4v1
        times(&tbuffer);
	ftime(&tbuf);
	access[0] += tbuf.time;
	access[0] = access[0]*1000 + tbuf.millitm - msec;
	access[1] += tbuffer.tms_utime + tbuffer.tms_stime;
#else
#ifdef BSD4v2
	gettimeofday(&tbuf, &tzone);
	getrusage(RUSAGE_SELF, &rubuf);
	access[0] += tbuf.tv_sec;
	access[0] = access[0]*1000 + (tbuf.tv_usec - rusec)/1000;
	access[1] += rubuf.ru_utime.tv_sec + rubuf.ru_stime.tv_sec;
	access[1] = access[1]*60 + 60*(rubuf.ru_utime.tv_usec + rubuf.ru_stime.tv_usec - cpusec)/1000000;
#endif
#endif
#endif
#ifdef awk
	fprintf(stderr, "%d %d %.3f\n", iter, access[0] - ohead[0],
			((float)(access[1] - ohead[1]))/60.);
#endif

	exit(0);
}
