      SUBROUTINE COEF24(JDIM,KDIM,COEF2X,COEF4X,COEF2Y,COEF4Y,
     +           PCOEF,SPECT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/BASE/
     1  JMAX,       KMAX,     JM,          KM,          JBEGIN,   JEND,
     1  KBEGIN,     KEND,     JPLUS(999),  JMINU (999), JLOW,     JUP,
     1  KLOW,       KUP,      PERIDC  ,    NP,          DT,   CP2TIM,
     1  FSMACH,     ALPHA,    GAMMA,       GAMI,        PI,
     1  DIS2X,      DIS2Y,    DIS4X,       DIS4Y,       PHIDT,    
     1  THETAD ,    RESID,    JACDT,       IPRINT,      NPCP,
     1  JTAIL1,     JTAIL2,   NUMITE ,     ISTART,      NSTEPS
      LOGICAL PERIDC  
      COMMON/GRID/DYM,YMAX,XMIN,XMAX,THICK
C
      DIMENSION COEF2X(JDIM,KDIM),COEF4X(JDIM,KDIM)
      DIMENSION COEF2Y(JDIM,KDIM),COEF4Y(JDIM,KDIM)
      DIMENSION PCOEF(JDIM,KDIM),SPECT(JDIM,KDIM)
C
C   COEF2X,Y COMES IN AS COEFX,Y (PRESSURE GRADIANT COEFFICIENT)
C   COEF4X,Y COMES IN AS SPECX,Y (SPECTRAL RADIUS)
C
      DO 1 K = KBEGIN,KEND
      DO 1 J = JBEGIN,JEND
         PCOEF(J,K) = COEF2Y(J,K)
         SPECT(J,K) = COEF4Y(J,K)
1     CONTINUE
C
       EPS4Y = DIS4Y/64.
       EPS2Y = DIS2Y    
C
C  FORM 2ND AND 4TH ORDER DISSIPATION COEFFICIENTS IN Y
C
       DO 10 K = KBEGIN,KUP
       DO 10 J = JLOW,JUP
C
         FIL = SPECT(J,K+1) + SPECT(J,K)
         C2 = PCOEF(J,K)*FIL*EPS2Y
         C4 = EPS4Y*FIL
         C4 = C4 - MIN(C4,C2)
C-old         C4 = C4 - AMIN1(C4,C2)
         COEF2Y(J,K) = C2
         COEF4Y(J,K) = C4
10       CONTINUE

C
C
      DO 2 K = KBEGIN,KEND
      DO 2 J = JBEGIN,JEND
         PCOEF(J,K) = COEF2X(J,K)
         SPECT(J,K) = COEF4X(J,K)
2     CONTINUE
C
       EPS4X = DIS4X/64.
       EPS2X = DIS2X    
C
C  FORM 2ND AND 4TH ORDER DISSIPATION COEFFICIENTS IN Y
C
       DO 20 J = JBEGIN,JUP
       JPL = JPLUS(J)
       DO 20 K = KLOW,KUP
C
         FIL = SPECT(JPL,K) + SPECT(J,K)
         C2 = PCOEF(J,K)*FIL*EPS2X
         C4 = EPS4X*FIL
         C4 = C4 - MIN(C4,C2)
C-old         C4 = C4 - AMIN1(C4,C2)
         COEF2X(J,K) = C2
         COEF4X(J,K) = C4
20       CONTINUE

         RETURN
         END
