      SUBROUTINE BASTR(DIR,REC,VOL)
C========================================================================
C
C{{{{{{{{{{{{{{{{{{{{{{{{ SUBROUTINE BAS_TR }}}}}}}}}}}}}}}}}}}}}}}}}}}}}
C                       18/2/90: WRITTEN BY BH
C
C THIS SUBROUTINE CALCULATES THE SET OF BASIS VECTORS IN RECIPROCAL
C SPACE.
C                                          
C IN REAL SPACE THE BASIS VECTORS A1, A2 AND A3 ARE STORED IN DIR(i,j):
C
C                ( DIR(1,1) DIR(2,1) DIR(3,1) )   ( '  '  ' )
C     DIR(i,j) = ( DIR(1,2) DIR(2,2) DIR(3,2) ) = ( A1 A2 A3)
C                ( DIR(1,3) DIR(2,3) DIR(3,3) )   ( '  '  ' )
C     
C     A1 = ( DIR(1,1) , DIR(1,2) , DIR(1,3) )
C     
C     A2 = ( DIR(2,1) , DIR(2,2) , DIR(2,3) )
C     
C     A2 = ( DIR(3,1) , DIR(3,2) , DIR(3,3) )
C
C THE VOLUME OF THE UNIT CELL IS GIVEN BY:
C                     
C     VOL = | A1*( A2 x A3) |
C
C THE BASISVECTORS IN RECIPROCAL SPACE WILL BE GIVEN BY:
C                      
C     B1 = 2*PI*( A2 x A3 ) / VOL
C                      
C     B2 = 2*PI*( A3 x A1 ) / VOL
C                      
C     B3 = 2*PI*( A1 x A2 ) / VOL
C
C WHICH IS STORED IN REC(i,j):
C
C                ( REC(1,1) REC(2,1) REC(3,1) )   ( '  '  ' )
C     REC(i,j) = ( REC(1,2) REC(2,2) REC(3,2) ) = ( B1 B2 B3)
C                ( REC(1,3) REC(2,3) REC(3,3) )   ( '  '  ' )
C
C========================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION DIR(3,3)
      DIMENSION REC(3,3)
      DATA TPI /6.2831853072/
C
      REC(1,1)=DIR(2,2)*DIR(3,3)-DIR(3,2)*DIR(2,3)
      REC(1,2)=DIR(2,3)*DIR(3,1)-DIR(3,3)*DIR(2,1)
      REC(1,3)=DIR(2,1)*DIR(3,2)-DIR(3,1)*DIR(2,2)
      REC(2,1)=DIR(3,2)*DIR(1,3)-DIR(1,2)*DIR(3,3)
      REC(2,2)=DIR(3,3)*DIR(1,1)-DIR(1,3)*DIR(3,1)
      REC(2,3)=DIR(3,1)*DIR(1,2)-DIR(1,1)*DIR(3,2)
      REC(3,1)=DIR(1,2)*DIR(2,3)-DIR(2,2)*DIR(1,3)
      REC(3,2)=DIR(1,3)*DIR(2,1)-DIR(2,3)*DIR(1,1)
      REC(3,3)=DIR(1,1)*DIR(2,2)-DIR(2,1)*DIR(1,2)
      VOL=DIR(1,1)*REC(1,1)+DIR(1,2)*REC(1,2)+DIR(1,3)*REC(1,3)
      DO 100 I=1,3
        DO 50 J=1,3
          REC(I,J)=TPI*REC(I,J)/VOL
50      CONTINUE
100   CONTINUE
      VOL=ABS(VOL)
      RETURN
      END
