C***********************************************************************
C FILE BMDTR.FOR
C
C HISTORY: 23/2/90: COPIED FROM FSIDYN.FOR
C                   FSIDYN() CHANGED TO BMDTR()
C                   ALLMOST STARTED OUT AGAIN FROM SCRATCH
C          25/2/90: OFF-DIAGONAL ELEMENTS IN STRESS TENSOR
C          27/2/90: NEW SCHEME: CALCULATING SIGMA-ZZ
C          29/3/90: NEW SCHEME FOR INTEGRATING EQ. OF MOTION
C           7/5/90: ADAPTING METHOD OF JOURNAL 1
C***********************************************************************
      SUBROUTINE BMDTR(DIRL,DIRC,RECC,VOLC,SIGTO,
     &    TIME,SIDAMP,SIMASS,SIDISP)
C=======================================================================
C
C{{{{{{{{{{{{{{{{{{{{{{{{ SUBROUTINE BMDTR }}}}}}}}}}}}}}}}}}}}}}}}}}}}
C
C THIS SUBROUTINE INTEGRATES THE EQUATIONS OF MOTION FOR THE SIZE THE
C UNIT CELL
C
C=======================================================================
      DIMENSION DIRL(3,*)
      DIMENSION DIRC(3,*)
      DIMENSION RECC(3,*)
      DIMENSION SIGTO(*)
C=======================================================================
C
      DATA TPI /6.2831853072/
C=======================================================================
C
C NOW CALCULATE THE CHANGE OF THE UNITCELL 
C
C=======================================================================
      F3Z=-VOLC*DIRC(3,1)*SIGTO(3)/
     &             (DIRC(3,1)**2+DIRC(3,2)**2+DIRC(3,3)**2)
      DENOM=SIMASS+0.5*SIDAMP*TIME  
      ALPHA1=(2.0*SIMASS)/DENOM
      ALPHA2=-(SIMASS-0.5*SIDAMP*TIME)/DENOM
C=======================================================================
C INTEGRATE THE EQUATIONS OF MOTION FOR THE SIZE OF THE UNIT CELL
C=======================================================================
      DIRN3Z=ALPHA1*DIRC(3,3)+ALPHA2*DIRL(3,3)+F3Z
      IF (ABS(DIRN3Z-DIRC(3,3)).GT.SIDISP) THEN
        DIRN3Z=DIRC(3,3)+SIDISP*SIGN( 1.0,(DIRN3Z-DIRC(3,3)) )
      ENDIF
C=======================================================================
C UPDATE THE SIZE OF THE CELL
C=======================================================================
      DO 1200 J=1,3
        DO 1100 I=1,3
          DIRL(I,J)=DIRC(I,J)
1100    CONTINUE
1200  CONTINUE
      DIRC(3,3)=DIRN3Z
      RETURN
      END
