C***********************************************************************
C FILE FEICTR.FOR
C
C HISTORY: 23/2/90: COPIED FROM FEICGB.FOR
C                   FEIC16 CHANGED TO FEICTR
C                   EISIF TO SIGEI
C                   RECC, VOLC FOR TRICLINIC GEOMETRY
C                   STATZD AND ITS CODE REMOVED
C                   CPHFX-Z REMOVED WHILST UNUSED
C          25/2/90: OFF-DIAGONAL ELEMENTS IN STRESS TENSOR
C           8/3/90: SIGN OF STRESS-CONTRIB. CHANGED
C***********************************************************************
      SUBROUTINE FEICTR(NGX,NGY,NGZ,NPLWV,CSTRF,RECC,VOLC,DVPS, VPS,
     & SIGEI,CHDEN,LPCTX,LPCTY,LPCTZ,NSPEC,CPSCD,NIONSP,POSION,NIONS)
C=======================================================================
C
C{{{{{{{{{{{{{{{{{{{{{{{{ SUBROUTINE FEICTR }}}}}}}}}}}}}}}}}}}}}}}}}}}}
C
C THIS SUBROUTINE CALCULATES THE STRESS ON THE UNIT CELL WHICH RESULTS
C FROM TO THE CHANGE IN THE ELECTRON-ION ENERGY ON CHANGING THE BASIS OF
C THE CELL
C                                  dv (G)
C                    -- !        [   I                         ]     *
C     Sigma      = - >     S (G) [ ----- G  G   + v (G) &      ] n(G)
C          Ai,Aj     --     I    [  d(G)  Ai Aj    I     Ai,Aj ]
C                    G,I
C
C=======================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION CSTRF(*)
      DIMENSION RECC(3,3)
      DIMENSION DVPS(*)
      DIMENSION VPS(*)
      DIMENSION SIGEI(*)
      DIMENSION CHDEN(*)
      DIMENSION LPCTX(*),LPCTY(*),LPCTZ(*)
      DIMENSION NIONSP(*)
      DIMENSION POSION(3,*)
C=======================================================================
C
C                  DIMENSION STATEMENTS
C
C CSIGEI = USED TO SUM THE FORCE ON THE UNIT CELL, (THE FORCE ON THE
C UNIT CELL IS REAL BUT CONTRIBUTIONS FROM INDIVIDUAL RECIPROCAL LATTICE
C VECTORS WILL BE COMPLEX, THE SUM OVER ALL G VECTORS MAKES THE FORCE
C REAL
C CPSCD = STRUCTURE FACTOR * CHARGE DENSITY * DERIVATIVE OF THE
C PSEUDOPOTENTIAL ON THE GRID OF RECIPROCAL LATTICE VECTORS
C=======================================================================
      DIMENSION CSIGEI(6)
      DIMENSION CPSCD(*)
      DATA TPI,CI / 6.2831853072,(0.0,1.0) /
C=======================================================================
C THERE ARE TWO CONTRIBUTIONS TO THE FORCE ON THE UNIT CELL DUE TO THE
C ELECTRON-ION ENERGY, ONE DUE TO THE TENDENCY TO PUT THE CHARGE DENSITY
C AT THE LARGEST VALUES OF THE PSEUDOPOTENTIAL AND THE OTHER DUE TO THE
C 1/ATOMIC VOLUME DEPENDENCE OF THE ELECTRON-ION ENERGY (WHICH COMES
C FROM THE DEPENDENCE OF THE MAGNITUDE OF THE IONIC POTENTIAL ON THE
C NUMBER DENSITY OF THE IONS)
C=======================================================================
C INITIALISE THE FORCE ON THE UNIT CELL TO ZERO
C=======================================================================
      DO 6500 M=1,6
      CSIGEI(M)=(0.0,0.0)
 6500 CONTINUE
C=======================================================================
C INITIALISE THE ELECTRON-ION ENERGY CPSCV TO ZERO
C=======================================================================
      CPSCV=0.0
      DO 6501 N=1,NPLWV
      CPSCD(N)=(0.0,0.0)
 6501 CONTINUE
C=======================================================================
C CALCULATE THE STRUCTURE FACTOR * CHARGE DENSITY * DERIVATIVE OF THE
C PSEUDOPOTENTIAL ON THE GRID OF RECIPROCAL LATTICE VECTORS AND THE
C TOTAL ELECTRON-ION ENERGY
C=======================================================================
      DO 6511 NSP=1,NSPEC
      NINDX=NPLWV*(NSP-1)
      DO 6510 N=1,NPLWV
      CPSCD(N)=CPSCD(N)+CSTRF(N+NINDX)*CONJG(CHDEN(N))*DVPS(N+NINDX)
      CPSCV=CPSCV+CSTRF(N+NINDX)*CONJG(CHDEN(N))*VPS(N+NINDX)
 6510 CONTINUE
 6511 CONTINUE
C=======================================================================
C CALCULATE THE CONTRIBUTION TO THE FORCE ON THE UNIT CELL DUE TO THE
C CHANGE IN THE ELECTRON-ION ENERGY THAT RESULTS FROM THE CHANGE IN THE
C MAGNITUDE OF THE PSEUDOPOTENTIAL ON THE RECIPROCAL LATTICE GRID AS THE
C SIZE OF THE CELL CHANGES
C=======================================================================
      NG=1
      DO 6520 N=1,NGZ
      GZX=RECC(3,1)*LPCTZ(N)
      GZY=RECC(3,2)*LPCTZ(N)
      GZZ=RECC(3,3)*LPCTZ(N)
      DO 6521 NN=1,NGY
      GYX=RECC(2,1)*LPCTY(NN)
      GYY=RECC(2,2)*LPCTY(NN)
      GYZ=RECC(2,3)*LPCTY(NN)
      DO 6522 NNN=1,NGX
      GXX=RECC(1,1)*LPCTX(NNN)
      GXY=RECC(1,2)*LPCTX(NNN)
      GXZ=RECC(1,3)*LPCTX(NNN) 
      GX=GXX+GYX+GZX
      GY=GXY+GYY+GZY
      GZ=GXZ+GYZ+GZZ
      GMOD=SQRT((GX**2+GY**2+GZ**2))
C=======================================================================
C THE CONTRIBUTION TO THE FORCE ON THE UNIT CELL FROM THE G=0 PART OF
C THE PSEUDOPOTENTIAL HAS BEEN DEALT WITH IN SUBROUTINE FVP16. THE
C FOLLOWING IF STATEMENT IS PRESENT MERELY TO AVOID A DIVIDE BY ZERO
C ERROR AT G=0
C=======================================================================
      IF(GMOD.LT.0.1) GMOD=1.0
      CSIGEI(1)=CSIGEI(1)+CPSCD(NG)*(GX**2)/GMOD
      CSIGEI(2)=CSIGEI(2)+CPSCD(NG)*(GY**2)/GMOD
      CSIGEI(3)=CSIGEI(3)+CPSCD(NG)*(GZ**2)/GMOD
      CSIGEI(4)=CSIGEI(4)+CPSCD(NG)*GY*GZ/GMOD
      CSIGEI(5)=CSIGEI(5)+CPSCD(NG)*GZ*GX/GMOD
      CSIGEI(6)=CSIGEI(6)+CPSCD(NG)*GX*GY/GMOD
      NG=NG+1
 6522 CONTINUE
 6521 CONTINUE
 6520 CONTINUE
C=======================================================================
C SCALE THE FORCES ON THE UNIT CELL BY 1/SIZEX, ETC AND ADD THE
C CONTRIBUTION TO THE TOTAL FORCE FROM THE 1/(UNIT CELL VOLUME)
C DEPENDENCE OF THE ELECTRON-ION ENERGY
C=======================================================================
      SIGEI(1)=-(REAL(CSIGEI(1))+REAL(CPSCV))/VOLC
      SIGEI(2)=-(REAL(CSIGEI(2))+REAL(CPSCV))/VOLC
      SIGEI(3)=-(REAL(CSIGEI(3))+REAL(CPSCV))/VOLC
      SIGEI(4)=-(REAL(CSIGEI(4))            )/VOLC
      SIGEI(5)=-(REAL(CSIGEI(5))            )/VOLC
      SIGEI(6)=-(REAL(CSIGEI(6))            )/VOLC
      RETURN
      END
