C***********************************************************************
C FILE: FELITR.FOR
C
C HISTORY: 23/4/90: COPIED FROM FELIGB.FOR
C                   CHANGED TO NON-ORTHOGONAL GEOMETRY
C***********************************************************************
      SUBROUTINE FELITR(NGX,NGY,NGZ,NIONS,POSION,CHDEN,RECC,
     &    VPS,EIFOR,LPCTX,LPCTY,LPCTZ,LPCTFX,LPCTFY,LPCTFZ,
     &    CPHFX,CPHFY,CPHFZ)
C=======================================================================
C
C{{{{{{{{{{{{{{{{{{{{{{{{ SUBROUTINE FELI16 }}}}}}}}}}}}}}}}}}}}}}}}}}}}
C
C THIS SUBROUTINE CALCULATES THE HELLMANN-FEYNMAN FORCES EXERTED ON THE
C IONS BY THE ELECTRONS WHICH EQUALS THE SUM OVER RECIPROCAL LATTICE
C VECTORS OF IG*EXP(-IG.R)* CHARGE DENSITY AT WAVEVECTOR G * THE VALUE
C OF THE PSEUDOPOTENTIAL AT WAVEVECTOR -G
C
C=======================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION POSION(3,*)
      DIMENSION CHDEN(*)
      DIMENSION RECC(3,*)
      DIMENSION VPS(*)
      DIMENSION EIFOR(3,*)
      DIMENSION LPCTX(*),LPCTY(*),LPCTZ(*)
      DIMENSION LPCTFX(*),LPCTFY(*),LPCTFZ(*)
      DIMENSION CPHFX(*),CPHFY(*),CPHFZ(*)
C=======================================================================
C
C                     DIMENSION STATEMENTS
C
C CEIFOR = ARRAY USED TO SUM THE FORCE EXERTED ON AN ION BY THE
C          ELECTRONS. THE FORCE BECOMES REAL AFTER SUMMING OVER ALL
C          RECIPROCAL LATTICE VECTORS
C=======================================================================
      DIMENSION CEIFOR(3)
      DATA CITPI,TPI / (0.0,6.283185307179),6.283185307179 /
      DO 6100 NI=1,NIONS
C=======================================================================
C INITIALISE THE FORCE ON THE ION TO ZERO
C=======================================================================
        DO 6101 M=1,3
          CEIFOR(M)=(0.0,0.0)
 6101   CONTINUE
C=======================================================================
C CGXDX,Y,Z = I* THE CHANGES IN THE PHASE FACTOR G.R ON MOVING ONE
C RECIPROCAL LATTICE VECTOR IN THE X,Y,Z DIRECTIONS, RESPECTIVELY
C=======================================================================
        CGXDX=POSION(1,NI)*CITPI
        CGYDY=POSION(2,NI)*CITPI
        CGZDZ=POSION(3,NI)*CITPI
C=======================================================================
C  COMPUTE THE PHASE FACTORS ONCE AND FOR ALL
C=======================================================================
        DO 6102 N=1,NGX
          CDUMMY=-CGXDX*LPCTX(N)
          CPHFX(N)=CEXP(CDUMMY)
 6102   CONTINUE
        DO 6103 N=1,NGY
          CDUMMY=-CGYDY*LPCTY(N)
          CPHFY(N)=CEXP(CDUMMY)
 6103   CONTINUE
        DO 6104 N=1,NGZ
          CDUMMY=-CGZDZ*LPCTZ(N)
          CPHFZ(N)=CEXP(CDUMMY)
 6104   CONTINUE
C=======================================================================
C NG = AN INDEX USED TO LABEL THE RECIPROCAL LATTICE VECTORS
C=======================================================================
        NG=1
C=======================================================================
C CALCULATE THE TOTAL FORCE ON THE IONS BY SUMMING OVER RECIPROCAL
C LATTICE VECTORS
C=======================================================================
        DO 6110 N=1,NGZ
          G3X=RECC(3,1)*LPCTFZ(N)
          G3Y=RECC(3,2)*LPCTFZ(N)
          G3Z=RECC(3,3)*LPCTFZ(N)
          DO 6111 NN=1,NGY
            CPHFYZ=CPHFY(NN)*CPHFZ(N)
            G2X=RECC(2,1)*LPCTFY(NN)
            G2Y=RECC(2,2)*LPCTFY(NN)
            G2Z=RECC(2,3)*LPCTFY(NN)
            DO 6112 NNN=1,NGX
C=======================================================================
C CALCULATE THE COMPLEX EXPONENTIAL OF THE PHASE FACTOR
C=======================================================================
              CEXPF=CPHFX(NNN)*CPHFYZ
C=======================================================================
C ADD THE CONTRIBUTION TO THE FORCE FROM THE PRESENT RECIPROCAL LATTICE
C VECTOR
C=======================================================================
              GX=RECC(1,1)*LPCTFX(NNN)+G2X+G3X
              GY=RECC(1,2)*LPCTFX(NNN)+G2Y+G3Y
              GZ=RECC(1,3)*LPCTFX(NNN)+G2Z+G3Z
              CPROD=CHDEN(NG)*VPS(NG)*CEXPF
              CEIFOR(1)=CEIFOR(1)+GX*CPROD
              CEIFOR(2)=CEIFOR(2)+GY*CPROD
              CEIFOR(3)=CEIFOR(3)+GZ*CPROD
C=======================================================================
C INCREASE THE RECIPROCAL LATTICE VECTOR INDEX BY ONE
C=======================================================================
              NG=NG+1
 6112       CONTINUE
 6111     CONTINUE
 6110   CONTINUE
C=======================================================================
C MULTIPLY FORCES BY I (IE TAKE -1* IMAGINARY PART)
C=======================================================================
        EIFOR(1,NI)=-AIMAG(CEIFOR(1))
        EIFOR(2,NI)=-AIMAG(CEIFOR(2))
        EIFOR(3,NI)=-AIMAG(CEIFOR(3))
C=======================================================================
C MOVE ONTO THE NEXT ION
C=======================================================================
 6100 CONTINUE
      RETURN
      END
