C----------------------------------------------------------------------C 
C File : forlnl.f                                                      C 
C Created: 08/05/91 IS                                                 C 
C History: See below                                                   C 
C----------------------------------------------------------------------C 
C                                                                       
C   02-JUN-91  THE ORDER OF LOOPS OVER IONS AND NON-LOCAL POTENTIALS    
C              HAS BEEN CHANGED. IN THE PARALLEL VERSION THE LOOP       
C              OVER IONS MUST BE THE LAST ONE.   (IS)                   
C
C   15-JUL-91  NODE INDEX REMOVED FROM ALL LOOKUP TABLES; I.E. EACH NODE 
C              STORES ONLY ITS OWN LOOKUP TABLE.   (IS)                  
C
C   12-MAR-92  INCORRECT FORCE ADMINISTRATION FOR MORE THAN ONE
C              SPECIES AT THE END OF THIS ROUTINE CORRECTED.   (IS/ADV)
C---------------------------------------------------------------------- 
      SUBROUTINE FORLNL(VOL,NGX,NGY,NGZ,CPTWFP,NPKPT,NPLWV,
     &   NRPLWV,NRGRPT,NIONSP,NRLPPI,NBANDS,NKPTS,NSPEC,CRWFPI,CRSPWF,
     &   CPHGRD,NRLNL,NIONST,MXRLNL,IRLNL,PRLSCA,VRLGRD,NADGRD,MXRLSH,
     &   FNLRL,DVRLGR,NINDPW,NPLWKP,OCC,IOCCUP,NGPTAR,WTKPT,
     &   CESAVE)
      IMPLICIT REAL*8 (A,B,D-H,O-Z) 
      IMPLICIT COMPLEX*16 (C)       
C                                   
C
C======================================================================
C THIS SUBROUTINES CALCULATES THE CONTRIBUTION TO THE IONIC FORCE
C TO THE NON-LOCAL PSEUDOPOTENTIAL USING THE REAL SPACE METHOD OF
C KING-SMITH AND PAYNE
C======================================================================
      DIMENSION NIONSP(NSPEC),NRLPPI(NIONST)
      DIMENSION CRWFPI(NPLWV),CRSPWF(NPLWV),CPHGRD(NRGRPT,NIONST)
      DIMENSION NRLNL(NSPEC),IRLNL(MXRLNL,NSPEC),PRLSCA(MXRLNL,NSPEC)
      DIMENSION VRLGRD(NRGRPT,MXRLSH,NIONST),NADGRD(NRGRPT,NIONST)
      DIMENSION CPTWFP(NRPLWV,NBANDS),FNLRL(3,NIONST),NPLWKP(NKPTS)
      DIMENSION DVRLGR(NRGRPT,3,MXRLSH,NIONST),OCC(NBANDS,NKPTS)
      DIMENSION WTKPT(NKPTS),NGPTAR(3),NINDPW(NRPLWV,NKPTS)
C======================================================================
C THE FOLLWOING ARE WORK ARRAYS THAT HOLD THE X,Y,Z DERIVATIVES OF THE
C RESPECTIVE NON-LOCAL POTENTIALS TIMES THE WAVEFUNCTION
C======================================================================
      DIMENSION CDSDS(3),CDPXDS(3),CDPYDS(3),CDPZDS(3),CDD1DS(3),
     &          CDD2DS(3),CDD3DS(3),CDD4DS(3),CDD5DS(3)
C========================================================================
C WORK ARRAYS FOR COMMUNICATIONS IN REAL SPACE NON-LOCAL PSEUDOPOTENTIALS 
C========================================================================
      DIMENSION CESAVE(NIONST,20)
C======================================================================
C CRWFPI IS USED TO STORE THE WAVEFUNCTION COMPONENTS AROUND A
C PARTICULAR ATOM
C CRSPWF IS THE WAVEFUNCTION OF THE PRESENT BAND ON THE REAL SPACE GRID
C NN IS THE CURRENT BAND INDEX AND NPKPT THE PRESENT K POINT
C======================================================================
C SCALE IS THE SCALING FACTOR THAT ACCOUNTS FOR THE VOLUME ELEMENT
C IN THE REAL SPACE INTEGRAL AND THE NORMALISATION APPLIED TO THE
C SHPERICAL HARMONICS
C======================================================================
      DATA PI / 3.14159265359 /
      SCALE=VOL/(4.D0*PI*(DFLOAT(NGX*NGY*NGZ))**2)
C=======================================================================
C START THE LOOP OVER BANDS
C=======================================================================
      DO 120 NN=1,NBANDS
C=======================================================================
C SET OCCUPANCY FACTOR FOR PRESENT BAND INCLUDING FACTOR OF 2 FOR SPIN
C AND K POINT WEIGHT
C=======================================================================
      IF(IOCCUP.EQ.1) THEN
      OCCPB=OCC(NN,NPKPT)*2.D0*WTKPT(NPKPT)
      ELSE
      OCCPB=2.D0*WTKPT(NPKPT)
      ENDIF
C=======================================================================
C INITIALISE ARRAY FOR FOURIER TRANSFORM OF WAVEFUNCTIONS
C=======================================================================
      DO 121 M=1,NPLWV
      CRSPWF(M)=(0.D0,0.D0)
 121  CONTINUE
C=======================================================================
C PUT WAVEFUNCTION ELEMENTS INTO ARRAY
C=======================================================================
      DO 122 M=1,NPLWKP(NPKPT)
      CRSPWF(NINDPW(M,NPKPT))=CPTWFP(M,NN)
 122  CONTINUE
C=======================================================================
C PERFORM FOURIER TRANSFORM
C=======================================================================
      CALL FFT3D(CRSPWF,CRWFPI,NGPTAR,1)
C=======================================================================
C START THE LOOP OVER SPECIES
C=======================================================================
      NINTOS=0
      NINTOP=0
      NINTOD=0
      DO 123 NSP=1,NSPEC
      NPIONT=0                             
      DO 40 IS=1,NSP-1                    
      NPIONT=NPIONT+NIONSP(IS)     
 40   CONTINUE                            
      NIND=1
C=======================================================================
C START LOOP OVER NON-LOCAL POTENTIALS FOR THIS ATOM
C=======================================================================
      DO 126 NNL=1,NRLNL(NSP)
C=======================================================================
C INITIALISE THE WORK ARRAY TO ZERO
C=======================================================================
      DO 50 I=1,20
      DO 50 J=1,NIONST
      CESAVE(J,I)=(0.D0,0.D0)
  50  CONTINUE
C=======================================================================
C START THE LOOP OVER THE IONS
C=======================================================================
      DO 124 NI=1,NIONSP(NSP)
C=======================================================================
C SET THE ION COUNTER                                                   
C=======================================================================
      NPION=NPIONT+NI                              
C====================================================================== 
C INITIALISE THE WORK VARIABLES TO ZERO                                 
C====================================================================== 
      CVDSS =(0.D0,0.D0)
      DO 220 M=1,3
      CDSDS(M)=(0.D0,0.D0)
 220  CONTINUE
      CVDSPX=(0.D0,0.D0)
      CVDSPY=(0.D0,0.D0)
      CVDSPZ=(0.D0,0.D0)
      DO 223 M=1,3
      CDPXDS(M)=(0.D0,0.D0)
      CDPYDS(M)=(0.D0,0.D0)
      CDPZDS(M)=(0.D0,0.D0)
 223  CONTINUE
      CVDSD1=(0.D0,0.D0)
      CVDSD2=(0.D0,0.D0)
      CVDSD3=(0.D0,0.D0)
      CVDSD4=(0.D0,0.D0)
      CVDSD5=(0.D0,0.D0)
      DO 226 M=1,3
      CDD1DS(M)=(0.D0,0.D0)
      CDD2DS(M)=(0.D0,0.D0)
      CDD3DS(M)=(0.D0,0.D0)
      CDD4DS(M)=(0.D0,0.D0)
      CDD5DS(M)=(0.D0,0.D0)
 226  CONTINUE
C=======================================================================
C GATHER THE WAVEFUNCTION COEFFICIENTS FOR THIS ION WITH THE
C RELEVANT PHASE FACTORS
C=======================================================================
      DO 125 NRG=1,NRLPPI(NPION)
      CRWFPI(NRG)=CRSPWF(NADGRD(NRG,NPION))*CPHGRD(NRG,NPION)
 125  CONTINUE
C=======================================================================
C 'S' POTENTIAL
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.0) THEN
      DO 127 NRG=1,NRLPPI(NPION)
      CVDSS=CVDSS+VRLGRD(NRG,NIND,NPION)*CRWFPI(NRG)
      DO 221 M=1,3
      CDSDS(M)=CDSDS(M)+DVRLGR(NRG,M,NIND,NPION)*CRWFPI(NRG)
 221  CONTINUE
 127  CONTINUE
      CESAVE(NI,1)=CVDSS 
      DO 331 M=1,3
      CESAVE(NI,1+M)=CDSDS(M)
 331  CONTINUE
      GO TO 124         
      ENDIF              
C=======================================================================
C 'P' POTENTIAL
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.1) THEN
      DO 128 NRG=1,NRLPPI(NPION)
      CVDSPX=CVDSPX+VRLGRD(NRG,NIND,NPION)*CRWFPI(NRG)
      CVDSPY=CVDSPY+VRLGRD(NRG,NIND+1,NPION)*CRWFPI(NRG)
      CVDSPZ=CVDSPZ+VRLGRD(NRG,NIND+2,NPION)*CRWFPI(NRG)
      DO 224 M=1,3
      CDPXDS(M)=CDPXDS(M)+DVRLGR(NRG,M,NIND,NPION)*CRWFPI(NRG)
      CDPYDS(M)=CDPYDS(M)+DVRLGR(NRG,M,NIND+1,NPION)*CRWFPI(NRG)
      CDPZDS(M)=CDPZDS(M)+DVRLGR(NRG,M,NIND+2,NPION)*CRWFPI(NRG)
 224  CONTINUE
 128  CONTINUE
      CESAVE(NI,1)=CVDSPX
      CESAVE(NI,2)=CVDSPY
      CESAVE(NI,3)=CVDSPZ
      DO 332 M=1,3
      CESAVE(NI,3+M)=CDPXDS(M)
 332  CONTINUE
      DO 333 M=1,3
      CESAVE(NI,6+M)=CDPYDS(M)
 333  CONTINUE
      DO 334 M=1,3
      CESAVE(NI,9+M)=CDPZDS(M)
 334  CONTINUE
      GO TO 124         
      ENDIF              
C======================================================================
C 'D' POTENTIAL
C======================================================================
      IF(IRLNL(NNL,NSP).EQ.2) THEN
      DO 129 NRG=1,NRLPPI(NPION)
      CVDSD1=CVDSD1+VRLGRD(NRG,NIND,NPION)*CRWFPI(NRG)
      CVDSD2=CVDSD2+VRLGRD(NRG,NIND+1,NPION)*CRWFPI(NRG)
      CVDSD3=CVDSD3+VRLGRD(NRG,NIND+2,NPION)*CRWFPI(NRG)
      CVDSD4=CVDSD4+VRLGRD(NRG,NIND+3,NPION)*CRWFPI(NRG)
      CVDSD5=CVDSD5+VRLGRD(NRG,NIND+4,NPION)*CRWFPI(NRG)
      DO 227 M=1,3
      CDD1DS(M)=CDD1DS(M)+DVRLGR(NRG,M,NIND,NPION)*CRWFPI(NRG)
      CDD2DS(M)=CDD2DS(M)+DVRLGR(NRG,M,NIND+1,NPION)*CRWFPI(NRG)
      CDD3DS(M)=CDD3DS(M)+DVRLGR(NRG,M,NIND+2,NPION)*CRWFPI(NRG)
      CDD4DS(M)=CDD4DS(M)+DVRLGR(NRG,M,NIND+3,NPION)*CRWFPI(NRG)
      CDD5DS(M)=CDD5DS(M)+DVRLGR(NRG,M,NIND+4,NPION)*CRWFPI(NRG)
 227  CONTINUE
 129  CONTINUE
      CESAVE(NI,1)=CVDSD1
      CESAVE(NI,2)=CVDSD2
      CESAVE(NI,3)=CVDSD3
      CESAVE(NI,4)=CVDSD4
      CESAVE(NI,5)=CVDSD5
      DO 335 M=1,3
      CESAVE(NI,5+M)=CDD1DS(M)
 335  CONTINUE
      DO 336 M=1,3
      CESAVE(NI,8+M)=CDD2DS(M)
 336  CONTINUE
      DO 337 M=1,3
      CESAVE(NI,11+M)=CDD3DS(M)
 337  CONTINUE
      DO 338 M=1,3
      CESAVE(NI,14+M)=CDD4DS(M)
 338  CONTINUE
      DO 339 M=1,3
      CESAVE(NI,17+M)=CDD5DS(M)
 339  CONTINUE
      ENDIF              
C====================================================================== 
C END ION LOOP                                                          
C====================================================================== 
 124  CONTINUE                                                          
C=======================================================================
C ADD THE 'S' CONTRIBUTION TO THE NON-LOCAL FORCE
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.0) THEN   
      DO 10 NION=1,NIONSP(NSP)
      NI=NINTOS+NION
      DO 222 M=1,3
      FNLRL(M,NI)=FNLRL(M,NI)-2.D0*DBLE(CESAVE(NION,1)*
     &     CONJG(CESAVE(NION,1+M)))*OCCPB*SCALE/PRLSCA(NNL,NSP)
 222  CONTINUE
  10  CONTINUE 
      NINTOS=NINTOS+NIONSP(NSP)
      NIND=NIND+1
      GO TO 126
      ENDIF
C=======================================================================
C ADD THE 'P' CONTRIBUTION TO THE NON-LOCAL FORCE
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.1) THEN     
      DO 20 NION=1,NIONSP(NSP)
      NI=NINTOP+NION
      DO 225 M=1,3
      FNLRL(M,NI)=FNLRL(M,NI)-2.D0*DBLE(
     &              CESAVE(NION,1)*CONJG(CESAVE(NION,3+M))+
     &              CESAVE(NION,2)*CONJG(CESAVE(NION,6+M))+
     &              CESAVE(NION,3)*CONJG(CESAVE(NION,9+M)))*
     &              OCCPB*SCALE/PRLSCA(NNL,NSP)
 225  CONTINUE
  20  CONTINUE
      NINTOP=NINTOP+NIONSP(NSP)
      NIND=NIND+3
      GO TO 126
      ENDIF
C=======================================================================
C ADD THE 'D' CONTRIBUTION TO THE NON-LOCAL FORCE
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.2) THEN     
      DO 30 NION=1,NIONSP(NSP)
      NI=NINTOD+NION
      DO 228 M=1,3
      FNLRL(M,NI)=FNLRL(M,NI)-2.D0*DBLE(
     &               CESAVE(NION,1)*CONJG(CESAVE(NION,5+M))+
     &               CESAVE(NION,2)*CONJG(CESAVE(NION,8+M))+
     &               CESAVE(NION,3)*CONJG(CESAVE(NION,11+M))+
     &               CESAVE(NION,4)*CONJG(CESAVE(NION,14+M))+
     &               CESAVE(NION,5)*CONJG(CESAVE(NION,17+M)))*
     &               OCCPB*SCALE/PRLSCA(NNL,NSP)
 228  CONTINUE
  30  CONTINUE
      NINTOD=NINTOD+NIONSP(NSP)
      NIND=NIND+5
      ENDIF
C======================================================================  
C END LOOP OVER NON-LOCAL POTENTIALS                                     
C======================================================================  
 126  CONTINUE                                                           
C======================================================================
C END SPECIES LOOP
C======================================================================
 123  CONTINUE
C======================================================================
C GO ON TO NEXT WAVEFUNCTION
C======================================================================
 120  CONTINUE
      RETURN
      END


