      SUBROUTINE MOVOUT

C************************************************************
C**                                                        **
C** PASSES EDGE OF SIMULATION BOX TO NEIGHBOURS AND ADDS   **
C** THOSE PASSED TO IT TO THE ARRAYS OF COORDINATES.       **
C** DURING THIS PROCESS ATOMS THAT HAVE MOVED INTO OTHER   **
C** PROCESSOR'S SIMULATION SPACE ARE PASSED TO THEIR       **
C** NEW HOME PROCESSOR.                                    **
C**                                                        **
C************************************************************

      IMPLICIT CHARACTER ( A-Z )

      COMMON/COORS/RX,RY,RZ
      COMMON/VELOC/VX,VY,VZ
      COMMON/ATOMS/NATM
      COMMON/LSTDAT/LIST,HEAD,MAP
      COMMON/LSTDT2/SFX,SFY,SFZ,CELLIX,CELLIY,CELLIZ,MX,MY,MZ

      INTEGER     NMAX, MMX, MMY, MMZ,  NCELL, MAPSIZ

      PARAMETER ( NMAX = 60000 )
      PARAMETER ( MMX=50, MMY=50, MMZ=50, NCELL=MMX*MMY*MMZ )
      PARAMETER ( MAPSIZ = 13*NCELL )

      REAL        RX(NMAX), RY(NMAX), RZ(NMAX)
      REAL        VX(NMAX), VY(NMAX), VZ(NMAX)
      REAL        SFX,SFY,SFZ,CELLIX,CELLIY,CELLIZ

      INTEGER     HEAD(NCELL), LIST(NMAX), MAP(MAPSIZ), MX, MY,MZ
      INTEGER     NATM, I, J, K, ICELL, NEDGE

C**   ZERO LINKED LIST

      DO 5 ICELL = 1, MX*MY*MZ
        HEAD(ICELL) = 0
 5      CONTINUE

      DO 10 I = 1, NATM
        ICELL = 1+INT((RX(I)*SFX+0.5)*CELLIX)
     &           +INT((RY(I)*SFY+0.5)*CELLIY)*MX
     &           +INT((RZ(I)*SFZ+0.5)*CELLIZ)*MX*MY
        LIST(I) = HEAD(ICELL)
        HEAD(ICELL) = I
 10     CONTINUE

      NEDGE = NMAX+1

C**   CREATE WEST FACE OF BOX

      DO 20 K = 0,MZ-1
        DO 20 I= MX-1,MX*MY-1,MX
          J=HEAD(I+K*MX*MY)
 21       IF (J.EQ.0) GOTO 20
          NEDGE = NEDGE-1
          RX(NEDGE) = RX(J)-1.0
          RY(NEDGE) = RY(J)
          RZ(NEDGE) = RZ(J)
          ICELL = 1+INT((RY(NEDGE)*SFY+0.5)*CELLIY)*MX
     &             +INT((RZ(NEDGE)*SFZ+0.5)*CELLIZ)*MX*MY
          LIST(NEDGE) = HEAD(ICELL)
          HEAD(ICELL) = NEDGE

          J = LIST(J)
          GOTO 21
 20       CONTINUE

C**   CREATE EAST FACE OF BOX

      DO 30 K = 0,MZ-1
        DO 30 I = 2, MX*(MY-1)+2,MX
          J=HEAD(I+K*MX*MY)
 31       IF (J.EQ.0) GOTO 30
          NEDGE = NEDGE-1
          RX(NEDGE) = RX(J)+1.0
          RY(NEDGE) = RY(J)
          RZ(NEDGE) = RZ(J)
          ICELL = MX+INT((RY(NEDGE)*SFY+0.5)*CELLIY)*MX
     &              +INT((RZ(NEDGE)*SFZ+0.5)*CELLIZ)*MX*MY
          LIST(NEDGE) = HEAD(ICELL)
          HEAD(ICELL) = NEDGE

          J = LIST(J)
          GOTO 31
 30       CONTINUE

C**   CREATE SOUTH FACE OF BOX

      DO 100 K = 0,MZ-1
        DO 100 I= MX*(MY-2)+1,MX*(MY-1)
          J=HEAD(I+K*MX*MY)
 101      IF (J.EQ.0) GOTO 100
          NEDGE = NEDGE-1
          RX(NEDGE) = RX(J)
          RY(NEDGE) = RY(J)-1.0
          RZ(NEDGE) = RZ(J)
          ICELL = 1+INT((RX(NEDGE)*SFX+0.5)*CELLIX)
     &             +INT((RZ(NEDGE)*SFZ+0.5)*CELLIZ)*MX*MY
          LIST(NEDGE) = HEAD(ICELL)
          HEAD(ICELL) = NEDGE

          J = LIST(J)
          GOTO 101
 100      CONTINUE

C**   CREATE NORTH FACE OF BOX

      DO 130 K = 0,MZ-1
        DO 130 I = MX+1,2*MX
          J=HEAD(I+K*MX*MY)
 131      IF (J.EQ.0) GOTO 130
          NEDGE = NEDGE-1
          RX(NEDGE) = RX(J)
          RY(NEDGE) = RY(J)+1.0
          RZ(NEDGE) = RZ(J)
          ICELL = 1+INT((RX(NEDGE)*SFX+0.5)*CELLIX)+MX*(MY-1)
     &             +INT((RZ(NEDGE)*SFZ+0.5)*CELLIZ)*MX*MY
          LIST(NEDGE) = HEAD(ICELL)
          HEAD(ICELL) = NEDGE

          J = LIST(J)
          GOTO 131
 130      CONTINUE

C**   CREATE DOWN FACE OF BOX

      DO 220 K = MX*MY*(MZ-2)+1,MX*MY*(MZ-1)
        J=HEAD(K)
 221    IF (J.EQ.0) GOTO 220
        NEDGE = NEDGE-1
        RX(NEDGE) = RX(J)
        RY(NEDGE) = RY(J)
        RZ(NEDGE) = RZ(J)-1.0
        ICELL = 1+INT((RX(NEDGE)*SFX+0.5)*CELLIX)
     &           +INT((RY(NEDGE)*SFY+0.5)*CELLIY)*MX
        LIST(NEDGE) = HEAD(ICELL)
        HEAD(ICELL) = NEDGE

        J = LIST(J)
        GOTO 221
 220    CONTINUE


C**   CREATE UP FACE OF BOX

      DO 270 K = MX*MY+1,2*MX*MY
        J=HEAD(K)
 271    IF (J.EQ.0) GOTO 270
        NEDGE = NEDGE-1
        RX(NEDGE) = RX(J)
        RY(NEDGE) = RY(J)
        RZ(NEDGE) = RZ(J)+1.0
        ICELL = 1+INT((RX(NEDGE)*SFX+0.5)*CELLIX)
     &           +INT((RY(NEDGE)*SFY+0.5)*CELLIY)*MX
     &           +(MZ-1)*MX*MY
        LIST(NEDGE) = HEAD(ICELL)
        HEAD(ICELL) = NEDGE

        J = LIST(J)
        GOTO 271
 270    CONTINUE

C**   TEST TO SEE IF WE HAVE TOO MANY EDGE ATOMS FOR ARRAYS

      IF (NEDGE.LT.NATM) WRITE(*,*) ' LINKED LIST RECURSIVE '

      RETURN
      END
