      SUBROUTINE FFTTST (ER, FP, TM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C   2-D FFT TEST PROGRAM
C
      PARAMETER (M=128, N=256, M1=128, F7=78125., T30=1073741824.)
      COMPLEX X, Y, CT
      COMMON /ARRAYS/ X(M1,N), W1(M), W2(N), IP(2*N)
      DATA IT/100/, ANS/0.894799941219277/
C
C   INITIALIZE
C
      AMN = M * N
      RMN = 1. / AMN
      T2 = F7 / T30
      DO 100 J = 1, N
        DO 100 I = 1, M
          T1 = MOD (F7 * T2, 1.0D0)
          T2 = MOD (F7 * T1, 1.0D0)
          X(I,J) = CMPLX (T1, T2)
100   CONTINUE
      CALL CFFT2D1 (0, M, M1, N, X, W1, IP)
      CALL CFFT2D2 (0, M, M1, N, X, W2, IP)
      TM = CPTIME ()
C
C   TEST ITERATIONS
C
      DO 120 K = 1, IT
        DO 110 J = 1, N
          DO 110 I = 1, M
            X(I,J) = RMN * X(I,J)
110     CONTINUE
C
        CALL CFFT2D1 (1, M, M1, N, X, W1, IP)
        CALL CFFT2D2 (1, M, M1, N, X, W2, IP)
        CALL CFFT2D2 (-1, M, M1, N, X, W2, IP)
        CALL CFFT2D1 (-1, M, M1, N, X, W1, IP)
120   CONTINUE
C
      TM = CPTIME ()
      ER = ABS ((REAL(X(19,19)) - ANS) / ANS)
      FP = IT * AMN * (2.  +  10. * LOG (AMN)/LOG (2.))
C
      RETURN
      END
