      SUBROUTINE MXMTST (ER, FP, TM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C   FLOATING-POINT MATRIX MULTIPLY TEST
C
      PARAMETER (L=256, M=128, N=64, F7=78125., T30=1073741824.)
      COMMON /ARRAYS/ A(L,M), S1, B(M,N), S2, C(L,N)
      DATA IT/100/, ANS/35.2026179738722/
C
C   INITIALIZATION
C
C   THE ARRAYS A AND B ARE FILLED WITH PSEUDO-RANDOM  (0., 1.)  DATA
C   USING A RANDOM NUMBER GENERATOR BASED ON THE RECURSION
C           X(N+1) = 5**7 * X(N)  (MOD 2**30)
C   THIS RECURSION WILL GENERATE 2**28 (APPROX. 268 MILLION) NUMBERS
C   BEFORE REPEATING.  FOR THIS SCHEME TO WORK PROPERLY, THE HARDWARE
C   MULTIPLY OPERATION MUST BE CORRECT TO 47 BITS OF PRECISION.
C   THIS SAME SCHEME IS USED TO INITIALIZE DATA ARRAYS FOR ALL TESTS.
C
      T = F7 / T30
      DO 100 J = 1, M
        DO 100 I = 1, L
          T = MOD (F7 * T, 1.0D0)
          A(I,J) = T
100   CONTINUE
      DO 110 J = 1, N
        DO 110 I = 1, M
          T = MOD (F7 * T, 1.0D0)
          B(I,J) = T
110   CONTINUE
      TM = CPTIME ()
C
C   TIMING TEST
C
      DO 120 II = 1, IT
        CALL MXM (A, B, C, L, M, N)
120   CONTINUE
C
      TM = CPTIME ()
      ER = ABS ((C(19,19) - ANS) / ANS)
      FP = 2. * IT * L * M * N
C
      RETURN
      END
