C----------------------------------------------------------------------
C
C   D O U T
C
C   COMPUTE EQUATORIAL COORDINATES FROM THE RECTANGULAR BARYCENTRIC
C   COORDINATES
C
C----------------------------------------------------------------------
      SUBROUTINE DOUT (T)
      REAL T 
C
C  CONSTANTS
C
      REAL  PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
      COMMON /CONST/    PI,PI2,CPI,DTORAD,RTODEG,
     .                  GRAVIT,OBLIQ
C
C  DATA IS COLLECTED FROM THE GLOBAL VARIABLES
C
      INTEGER MAXOBJ, MAXDAY, MMM, ORDER
      PARAMETER (MAXOBJ=10, MAXDAY=10000, ORDER=7, MMM=3)
      REAL
     .    EPOCH,
     .    SBINC(0:ORDER,0:ORDER),
     .    DD(0:ORDER),
     .    KK(-MMM:MMM,-MMM:MMM),
     .    MASS(MAXOBJ),
     .    COORD(3,MAXOBJ),
     .    VELOC(3,MAXOBJ),
     .    XDIFF(3,MAXOBJ),      
     .    ACCEL(-MMM:MMM,3,MAXOBJ,0:1),
     .    ADIFF(maxobj,0:ORDER,3),  
     .    DISTNC(MAXOBJ,MAXOBJ)        
      INTEGER SWAP
      COMMON /INTTAB/    SBINC,DD,KK,
     .                   COORD,VELOC,MASS,
     .                   XDIFF,ACCEL,ADIFF,DISTNC,SWAP,
     .                   EPOCH
C
C  COMMON OUT IS USED TO STORE OUTPUT 
C
      REAL
     .    PLANET(3,MAXOBJ),      
     .    OLDPL(2,MAXOBJ)    
      INTEGER
     .    TODAY
      REAL
     .    OUTBUF(MAXDAY,3,MAXOBJ)      
C
      COMMON /OUT/ OUTBUF, PLANET, OLDPL, TODAY
C
C
      INTEGER I  
      REAL
     .    JD, CX, CY, CZ, XX, YY, ZZ
C
C  COMPUTE  PRECESSED HELIOCENTRIC COORDINATES
C
      JD = T + 2415020.0E+0
      DO 10 I=1,MAXOBJ
         CX=COORD(1,I)-COORD(1,1)   
         CY=COORD(2,I)-COORD(2,1)
         CZ=COORD(3,I)-COORD(3,1)
         CALL PRECES(2433282.423E+0, JD, CX,CY,CZ, XX,YY,ZZ)
         PLANET(1,I)=XX
         PLANET(2,I)=YY
         PLANET(3,I)=ZZ
 10   CONTINUE
C
C  CONVERT HELIOCENTRIC COORDINATES TO EQUATORIAL
C 
      CALL EQC (T)
      RETURN
      END
