      PROGRAM PDE1
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C     MAIN PROGRAM FOR PDE1 BENCHMARK - SIMD/VECTOR VERSION
C
C     SUPPLIED BY   PALLAS GmbH
C
C     AUTHOR:  GENESIS BENCHMARK VERSION:
C		  M. LEMKE (1989, PALLAS GMBH)
C
C     FOR NUMERICAL VERIFICATION:
C	 THE AVERAGE CONVERGENCE RATE SHOULD BE SOMEWHERE BETWEEN
C	 0.7 AND 0.98
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C     THE TIMER (DOUBLE PRECISION IN SECONDS) IS CALLED IN MAIN PROGRAM.
C     THE MACHINE DEPENDENT TIMING ROUTINE HAS TO BE INCLUDED.
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      INCLUDE 'pde1.inc'
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      PARAMETER (NPMAX=2**(MMAX+6)+1)
      PARAMETER (NPMIN=2**(MMAX-3)+1)
      PARAMETER (IDIM=NPMAX*NPMIN**2)
      PARAMETER(NW1=6)

      DOUBLE PRECISION U(IDIM),F(IDIM)
      COMMON U,F
      ITER = MAXIT

c--      OPEN(NW1,FILE='result')
      CALL HEADER(NW1)
      WRITE(NW1,91000)
91000 FORMAT(' ***** 3D RED BLACK RELAXATION BENCHMARK ************* '/
     *    )
C
C---> LOOP OVER THE FINEST GRIDS IN ORDER TO GET RESULTS FOR DIFFERENT
C     PROBLEM SIZES
      DO 1 N=3,MMAX
        NP=2**N+1
        CALL TESTA(U,F,NP,NP,NP,ITER,NW1)
c--        CALL TESTB(U,F,NP,NP,NP,ITER,NW1)
c--        CALL TESTC(U,F,NP,NP,NP,ITER,NW1)
        ITER = MAX(ITER/8,5)
C
1     CONTINUE
      NX = NP-1
      NY = NP-1
      NZ = NP-1
      DO 2 N=1,3
         NX = NX * 4
         NY = NY / 2
         NZ = NZ / 2
         IF (NY.GE.3.AND.NZ.GE.3) THEN
            CALL TESTA(U,F,NX+1,NY+1,NZ+1,ITER,NW1)
c--            CALL TESTB(U,F,NX+1,NY+1,NZ+1,ITER,NW1)
c--            CALL TESTC(U,F,NX+1,NY+1,NZ+1,ITER,NW1)
         ENDIF
2     CONTINUE
C
c--      CLOSE(NW1)

      STOP
      END
