      DOUBLE PRECISION FUNCTION LIQINF(ALFA,RR,BETA,Y,NY)
      DOUBLE PRECISION ALFA,RR,BETA,Y
      INTEGER NY

      DOUBLE PRECISION PI,HH,A,XX,ALFAR
      DOUBLE PRECISION DSQRT,DLOG
      PARAMETER(PI=3.141592653589793D0)

      ALFAR=PI/180.0D0*ALFA
      HH=DSQRT(2.0D0*(1.0D0-DCOS(ALFAR))+
     +     (DSIN(ALFAR)/(2.0D0*RR))**2.0D0)-
     +     DSIN(ALFAR)/(2.0D0*RR)
      A=0.5D0*(1.0D0+DSIN(ALFAR)/(RR*HH))

      IF (Y**2.0D0 .GT. 2.0D0/A) THEN
         NY=1
         LIQINF=0.0D0
         GOTO 100
      ENDIF

      XX=RR+DSQRT(2.0D0/A-HH**2.0D0)-DSQRT(2.0D0/A-Y**2.0D0)-
     +     1.0D0/DSQRT(2.0D0*A)*DLOG(DABS(Y/HH*
     +     (DSQRT(2.0D0)+DSQRT(2.0D0-A*HH**2.0D0))/
     +     (DSQRT(2.0D0)+DSQRT(2.0D0-A*Y**2.0D0))))

      LIQINF=XX
 100  CONTINUE
      RETURN
      END
