/*--------------------------------------------------------------------------*
 *
 * Usage :
 *
 *   ras2hdf hdf_file [-append] < ras_file
 *
 * Compile :
 *
 *   cc ras2hdf.c rasutils.o utils.o -o ras2hdf -lpixrect -ldf
 *
 * 				NO WARRANTY
 *  
 *  This software is distributed free of charge and is in the public domain.
 *  Anyone may use, duplicate or modify this program.  Thinking Machines
 *  Corporation does not restrict in any way the use of this software by
 *  anyone.
 *  
 *  Thinking Machines Corporation provides absolutely no warranty of any kind.
 *  The entire risk as to the quality and performance of this program is with
 *  you.  In no event will Thinking Machines Corporation be liable to you for
 *  damages, including any lost profits, lost monies, or other special,
 *  incidental or consequential damages arising out of the use of this program.
 * 
 * Jim Salem 9/26/89
 * Please keep this notice with the file.
 *
 * RCS: $Id: ras2hdf.c,v 2.0 90/08/01 11:04:07 salem Exp $
 *  $Log:	ras2hdf.c,v $
 * Revision 2.0  90/08/01  11:04:07  salem
 * Bump to next release, no changes
 * 
 * Revision 1.1  90/07/30  18:36:03  salem
 * Initial revision
 * 
 *
 *--------------------------------------------------------------------------*/

#include <stdio.h>

/*--------------------------------------------------------------------------*
 * Global Vars.
 *--------------------------------------------------------------------------*/

static
  char *filename;		/* The input file name */
static
  char *progname;		/* argv[0] */
static
  int appendp = 0;		/* The index */

/*--------------------------------------------------------------------------*
 * Utilities
 *--------------------------------------------------------------------------*/

extern void signal_hdf_error();
extern long strtol();

static
  int parse_append (string)
char *string;
/* Returns 1 if string is -append or -a or otherwise 0 */
{
  if (strcmp(string,"-append") || strcmp(string,"-a"))
    return 1;
  else
    return 0;
}

static
  void bad_usage ()
{
  fprintf(stderr,"Usage: %s hdf_file [-append]\n\
  If -append is given, the image is appended to the file\n\
  Normally, you should pipe the rasterfile into standard input.\n", progname);
  exit (1);
}

/*--------------------------------------------------------------------------*
 * Main
 *--------------------------------------------------------------------------*/

void
  main (argc, argv)
int argc;
char **argv;
{
  progname = argv[0];

  /* argument parsing */
  if (argc < 2) bad_usage();
  filename = argv[1];
  if (argc == 3)
    if (parse_append (argv[2]))
      appendp = 1;
    else bad_usage();
  if (argc > 3) bad_usage();

  if (! rasterfile_to_hdf (stdin, filename, appendp))
    signal_hdf_error(progname);

  exit(0);
}

    
