#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define FUNC     gb1dot
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gdot.h"

#define FUNC     gi2dot
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gdot.h"

#define FUNC     gi4dot
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gdot.h"

#define FUNC     gr4dot
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gdot.h"

#define FUNC     gr8dot
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gdot.h"

#define MULTIP   2*
#define FUNC     gz8dot
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gdot.h"

#define MULTIP   2*
#define FUNC     gz16dot
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gdot.h"


int gdot(data1, data2, ndata, result)
     void *data1; 
     void *data2; 
     int ndata; 
     void *result;
{
  int retcode = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

    switch (DATATYPE) {
    case BYTE1:
      retcode = gb1dot(data1,data2,ndata,result);
      break;
    case INTEGER2:
      retcode = gi2dot(data1,data2,ndata,result);
      break;
    case INTEGER4:
      retcode = gi4dot(data1,data2,ndata,result);
      break;
    case REAL4:
      retcode = gr4dot(data1,data2,ndata,result);
      break;
    case REAL8:
      retcode = gr8dot(data1,data2,ndata,result);
      break;
    case COMPLEX8:
      retcode = gz8dot(data1,data2,ndata,result);
      break;
    case COMPLEX16:
      retcode = gz16dot(data1,data2,ndata,result);
      break;
    default:
      fprintf(stderr,
	      "gdot(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

  }

  return retcode;
}

