#       enwrite - write RIPE database entry
#
#	$RCSfile: enwrite.pl,v $
#	$Revision: 0.23 $
#	$Author: marten $
#	$Date: 1994/09/20 12:17:11 $
#
#	This routine writes a RIPE database entry to standard output
#	in long or short form.
#
#       Arguments:
#	*object		pointer to assoc array with database entry
#	$long		boolean flag for long or short format output
#	$witherror	boolean flag for with or without error messages
#       $withsugar      boolean flag for with or without syntactic sugar

require "entype.pl";

sub enwrite {

    local(*object, $long, $witherrors, $withsugar) = @_;
    local($ok) = 0;
    local($ie) = 0;
    local(@val, $key, $kie);
    local($errs) = "";
    local(@fields);

    $errs = "uw ue" if $witherrors;

    # If not long format, and we have an unknown object, let's try
    # and print this anyway to inform the user ...

    if (!&entype(*object)) {
	return 0 if (!$long);
	return 0 if (!$witherrors);
	$ok = 1;
	foreach (keys %object) {
	    next if (($_ eq "uw") || ($_ eq "ue"));
	    @val = split(/\n/, $object{$_});
	    for ($ie = 0; $ie<=$#val;$ie++) {
		$kie = $_;
		printf "%-15s %s\n", $kie.":", $val[$ie];
	    }
	}
	printf "%-15s %s\n", $ATTL{"ue"}.":", "Unknown object type";
	return $ok;
    }

    @fields = split(/\s+/, "$OBJATSQ{&entype(*object)} $errs");
    foreach $key (@fields) {
	if ($object{$key}) {
	    $ok = 1;
	    @val = split(/\n/, $object{$key});
	    for ($ie = 0; $ie<=$#val;$ie++) {
		if ($long) {

		    # HARDCODED SYNTACTIC SUGAR !!!!

		    if ($withsugar) {
			local($M) = "\\S+\\s+\\S+\\s+\\S+";
			if ($key eq "ae") {
			    $val[$ie] =~ s/^(AS\d+)/exclude \1 to/;
			}
			elsif ($key eq "ai") {
			    $val[$ie] =~ s/^(AS\d+\s+\d+)/from \1 accept/;
			}
			elsif ($key eq "ao") {
			    $val[$ie] =~ s/^(AS\d+)(\s+)/to \1 announce\2/;
			}
			elsif ($key eq "it") {
			    $val[$ie] =~ s/^($M)\s+(\(\s*pref[=\s\S]+\))/from \1 \2 accept/ ||
				$val[$ie] =~ s/^($M)\s+/from \1 accept /;
			}
			elsif ($key eq "io") {
			    $val[$ie] =~ s/^($M)\s+(\(\s*metric\-out[=\s\S]+\))/to \1 \2 announce/ ||
				$val[$ie] =~ s/^($M)\s+/to \1 announce /;
			}
		    }

		    # END HARDCODED

		    printf "%-12s %s\n", $ATTL{$key}.":",$val[$ie];
		}
		else {
		    print "*".$key.": ".$val[$ie]."\n";
		}
	    }
	}
    }
    return $ok;
}

1;
