#include <rip.h>
#include <glib.h>

typedef struct {
  GString* from;
  GString* subject;
  GString* date;
  GString* reply_to;
  GString* cc;
  GString* message_id;
} ep_mail_info_t;

typedef struct {
  gboolean is_mail;
  ep_mail_info_t* mail_info;
  GList* flattened_authenticated_data;
  // ..
} ep_input_structure_t;

typedef enum {EP_TEXT, EP_MAIL} ep_data_type_t;

typedef struct {
  ep_data_type_t type;
  GString* data;
} ep_exploded_data_t;

typedef struct {
  ep_exploded_data_t* data;
  GList* credentials;
} ep_authenticated_data_t;

/* codes used by the X509 verification functions */

typedef enum
{
  EP_GOOD_SIG      =0, /* verified with good signature */
  EP_BAD_SIG       =1, /* verified with bad signature */
  EP_NOT_SMIME     =2, /* not an s/mime message */
  EP_NO_DNAME      =4, /* no dname found */
  EP_VERIFY_FATAL  =8  /* fatal error */
} EP_verify_codes;

/* convert the enum to a printable string */
#define EP_verify_ret2str(r) \
  (((r) == EP_GOOD_SIG)       ? "EP_GOOD_SIG" : \
   ((r) == EP_BAD_SIG)        ? "EP_BAD_SIG" : \
   ((r) == EP_NOT_SMIME)      ? "EP_NOT_SMIME" : \
   ((r) == EP_NO_DNAME)       ? "EP_NO_DNAME" : \
   ((r) == EP_VERIFY_FATAL)   ? "EP_VERIFY_FATAL" : \
                              "UNKNOWN" )

ep_input_structure_t* ep_explode(ep_authenticated_data_t* data);
ep_input_structure_t* ep_input_structure_new();

ep_authenticated_data_t* ep_authenticated_data_new();
void ep_authenticated_data_free(ep_authenticated_data_t* data);

ep_exploded_data_t* ep_exploded_data_new();
void ep_exploded_data_free(ep_exploded_data_t* data);
ep_mail_info_t* ep_mail_info_new();
void ep_mail_info_free(ep_mail_info_t *);

ep_input_structure_t* ep_text_driver(ep_authenticated_data_t* data);
ep_input_structure_t* ep_mail_driver(ep_authenticated_data_t* data);

GList* ep_split_text(gchar** split, GList* creds);

GList* ep_flatten(GList* list);

int ep_stream_to_string(FILE* stream, GString **return_string);

GList* ep_content_explode(MM_content_t* content, GList* credentials);

GList* ep_plain_process(gchar* content, GList* credentials);
GList* ep_mixed_process(MM_content_t* content, GList* credentials);
GList* ep_pgp_process(MM_content_t* content, GList* credentials) ;


extern LG_context_t* ep_ctx;
extern gchar* ep_temporary_directory;
extern gchar* ep_ca_file;
extern gchar* ep_crl_dir;

CR_credential_t* x509_process(gchar* stream);
