/* 
 * $Id: idrp_ps_set.c,v 1.2 1995/08/01 20:26:05 sjr Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

/*
 *  idrp_ps_set.c -- sjr
 *
 *  Function for setting IDRP's ps (process-specific) data. 
 */

#include "include.h"
#include "inet.h"
#include "iso.h"   
#include "idrp.h"
#include "parse.h"

idrp_ps_set __PF3(adv_ps_field, void *,
		qos_flag, flag_t,
		ps_data, void_t)
{
	struct _idrp_ps_t *idrp_ps;

	idrp_ps = (struct _idrp_ps_t *) adv_ps_field;
	switch (idrp_ps->ps_flag) {
    		case (IDRP_PSFT_RIBID):
			idrp_ps->ps_rib_id = *((int *) ps_data); 
        	break;

#ifdef PROTO_RDPATHS
    		case (IDRP_PSFT_DISTINCL):
    	idrp_ps->ps_DIST_LIST_INCL = (idrp_canon_rdpath *) ps_data; 
		break;

    		case (IDRP_PSFT_DISTEXCL):
    	idrp_ps->ps_DIST_LIST_EXCL = (idrp_canon_rdpath *) ps_data; 
		break;
#endif

    		case (IDRP_PSFT_HOPCNT):
    		case (IDRP_PSFT_DISTATT):
    		case (IDRP_PSFT_NEXTHOP_SNPA):
    		case (IDRP_PSFT_NEXTHOP_NET):
    		case (IDRP_PSFT_CAPACITY):
    		case (IDRP_PSFT_ROUTESERV):
    		case (IDRP_PSFT_EXTINFO):
    		case (IDRP_PSFT_HIERARCH):
    		case (IDRP_PSFT_NEXTHOP_IPGW):
    		case (IDRP_PSFT_NEXTHOP_IPINTF):
		break;
	default:
		fprintf(stderr, "%s (%d):  found bad ps_flag for IDRP:  0x%lx\n",
			__FILE__, __LINE__, idrp_ps->ps_flag);
		assert(FALSE);
		break;
	}

	return;
}
