/*
 * $Id: dvmrp_targets.h,v 1.1 1995/10/12 20:27:06 root Exp $
 *
 *  Authors:
 *	Jeffrey C Honig <jch@nr-atp.cit.cornell.edu>
 *	Tom Pusateri <pusateri@netedge.com>
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


/* Target definitions. */

#define	TDF_HOLDDOWN	0x8000	/* This entry is in holddown */
#define	TDF_POISON	0x4000	/* This entry is in poison reverse */
#define	TDF_CHANGED	0x2000	/* This entry is changed */

#define	target_set_holddown(tdp, count) { \
	 (tdp)->td_flags = TDF_HOLDDOWN|TDF_CHANGED; \
	 (tdp)->td_metric = (count); \
     }

#define	target_set_poison(tdp, count) { \
	 (tdp)->td_flags = TDF_POISON|TDF_CHANGED; \
	 (tdp)->td_metric = (count); \
     }

#define	target_set_metric(tdp, metric) { \
	 (tdp)->td_flags = TDF_CHANGED; \
	 (tdp)->td_metric = (metric); \
     }

#define	DVMRP_TD_CLEANUP(tlp, tdp) \
	{ \
	    dvmrp_td_delete(tlp, tdp); \
	    task_block_free(dvmrp_td_block_index, (void_t)tdp);\
	}

#define DVMRP_TD_NOMASK     0xffffffff


#define	TARGETF_BROADCAST	0x01		/* This is a broadcast address */
#define	TARGETF_SOURCE		0x02		/* This is a P2P client */
#define	TARGETF_SUPPLY		0x04		/* We supply updates to this client */
#define	TARGETF_ALLINTF		0x08		/* We want to see all interfaces */
#define	TARGETF_POLICY		0x10		/* Initial policy has been run */

#define	TARGETF_USER4		0x1000
#define	TARGETF_USER3		0x2000
#define	TARGETF_USER2		0x4000
#define	TARGETF_USER1		0x8000		/* For protocol use */


#define	TARGET_LIST(tlp, list) \
	{ \
	    for ((tlp) = (list)->target_forw; (tlp) != (list); (tlp) = (tlp)->target_forw)
#define	TARGET_LIST_END(tlp, list) \
	    if ((tlp) == (list)) { \
		tlp = (dvmrp_target *) 0; \
	    } \
	}

PROTOTYPE(dvmrp_target_locate,
	  extern dvmrp_target *,
	  (dvmrp_target *,
	   if_addr *,
	   gw_entry *));
PROTOTYPE(dvmrp_target_free_list,
	  extern void,
	  (task *,
	   dvmrp_target *));
PROTOTYPE(dvmrp_target_build,
	  extern int,
	  (task *,
	   dvmrp_target *y,
	   gw_entry *,
	   flag_t,
	   _PROTOTYPE(dump,
		      void,
		      (FILE *,
		       rt_head *,
		       void_t,
		       const char *))));
PROTOTYPE(dvmrp_target_dump,
	  extern void,
	  (FILE *,
	   dvmrp_target *,
	   const bits *));

/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
