/*
 * ------------------------------------------------------------------------
 * 
 * GateD, Release 3.5.5 
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit at the University of Michigan.
 * 
 * Merit GateDaemon Project
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ---------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * GateDaemon Project
 * Information Technologies/Network Resources
 * 200 CCC
 * Cornell University
 * Ithaca, NY  14853-2601  USA
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * This copyright has ben automaticly added by the util/addcopyright.pl program.
 * __END_OF_COPYRIGHT__
 */

/*
 *  krt_lladdr_sunos4.c,v 1.5.2.2 1995/01/23 12:40:14 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */

#define	INCLUDE_TIME
#define	INCLUDE_IOCTL
#define	INCLUDE_ETHER
#define	INCLUDE_FILE
#define	INCLUDE_IF
#include "include.h"
#include "krt.h"
#include "krt_var.h"
#include <net/nit_if.h>

sockaddr_un *
krt_lladdr __PF1(ifr, struct ifreq *)
{
    static int s_nit = -2;
    sockaddr_un *addr = (sockaddr_un *) 0;

    switch (s_nit) {
    case -1:
	/* Previous open failed */
	break;

    case -2:
	/* Try to open it */
	NON_INTR(s_nit, open("/dev/nit", O_RDONLY));
	if (s_nit < 0) {
	    if (!BIT_MATCH(task_state, TASKS_TEST|TASKS_NODUMP)) {
		trace_only_tp(krt_task,
			      0,
			      ("krt_lladdr: open(\"/dev/nit\"): %m"));
	    }
	    break;
	}
	(void) task_floating_socket(krt_task, s_nit, "/dev/nit");
	/* Fall through */

    default:
	/* Bind the NIT socket to this interface */
	bzero ((caddr_t) &ifr->ifr_ifru, sizeof (ifr->ifr_ifru));
	if (task_ioctl(s_nit,
		       (u_long) NIOCBIND,
		       (caddr_t) ifr, 
		       sizeof (ifr)) < 0) {
	    int rc;
	    
	    trace_only_tp(krt_task,
			  0,
			  ("krt_lladdr: NIOCBIND could not bind to interface %.*s: %m",
			   IFNAMSIZ, ifr->ifr_name));

	    /* Close the socket */
	    NON_INTR(rc, close(s_nit));
	    if (rc < 0) {
		trace_only_tp(krt_task,
			      0,
			      ("krt_lladdr: close(\"/dev/nit\"): %m"));
	    }
	    s_nit = -1;
	    break;
	}

	bzero ((caddr_t) &ifr->ifr_ifru, sizeof (ifr->ifr_ifru));
	if (task_ioctl(s_nit,
		       (u_long) SIOCGIFADDR,
		       (caddr_t) ifr,
		       sizeof (ifr)) < 0) {
	    switch (errno) {
	    case EINVAL:
	    case EOPNOTSUPP:
		break;

	    default:
		trace_only_tp(krt_task,
			      0,
			      ("krt_lladdr: could not get link layer address for interface %.*s: %m",
			       IFNAMSIZ, ifr->ifr_name));
	    }
	    break;
	}

	addr = sockbuild_ll(LL_8022,
			    (byte *) ifr->ifr_addr.sa_data,
			    sizeof (struct ether_addr));
    }

    return addr;
}
