/*
 *  krt_lladdr_sioc.c,v 1.5.2.2 1995/01/23 12:40:14 jch Exp
 */



#define       INCLUDE_CTYPE
#define       INCLUDE_FILE
#define       INCLUDE_IOCTL
#define       INCLUDE_IF
#include "include.h"
#include "krt.h"
#include "krt_var.h"
#define PATH  "/dev/ip" 


static sockaddr_un *
krt_lladdr_get __PF2(fd, int,
                   ifr, struct ifreq *)
{
    int rc;
    struct strioctl si;
    struct ifreq ifreq_enaddr;

    si.ic_cmd = SIOCGENADDR;
    si.ic_timout = 0;
    si.ic_len = sizeof(ifreq_enaddr);
    si.ic_dp = (caddr_t) &ifreq_enaddr;
    bcopy(ifr->ifr_name, ifreq_enaddr.ifr_name, IFNAMSIZ);

    rc = ioctl(fd, I_STR, &si);

    if (rc != 0)
      return (sockaddr_un *) 0;

    return sockbuild_ll(LL_8022, (byte *) (ifreq_enaddr.ifr_enaddr), 6);
}


sockaddr_un *
krt_lladdr __PF1(ifr, struct ifreq *)
{
    int fd;
    sockaddr_un *lladdr = (sockaddr_un *) 0;

    fd = open(PATH, O_RDWR);
    if (fd < 0) {
      /* Do not report an error */
      return lladdr;
    }

    lladdr = krt_lladdr_get(fd, ifr);

    (void) close(fd);

    return lladdr;
}

