/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

/*
 * UMD_OSPF V3 (umd_ospf.9207) (OSPF V2) -- Date: 2/14/92
 * Last merge with gated: 2/14/92
 */

#include "port/ospf_types.h"
#include "ospf_rtab.h"			/* routing table */
#include "port/ospf_port.h"
/*
 * state transition routines from ospf_state.c
 */

/* state and event ranges - states.c */

#define	NINTF_STATES	7
#define	NINTF_EVENTS	7

/* MODIFIED 2/6/92  states = 8 */
#define NNBR_STATES	8
#define NNBR_EVENTS	14



extern void (*if_trans[NINTF_EVENTS][NINTF_STATES]) ();
extern void (*nbr_trans[NNBR_EVENTS][NNBR_STATES]) ();

extern u_short16 inet_chksum();
extern void fletch();
extern int rxpkt(), RxMon(), RxHello(), RxDb(), RxLsAck(), RxLsReq(), RxLinkUp();

#include "ospf_timer_calls.h"		/* timer calls */
#include "ospf_lsdb.h"			/* link-state database */

#ifdef UMBC_SIM
#include "port/osp_umbc_sim.h"
#else
#include "ospf_const.h"			/* OSPF constants */
#endif

#include "ospf_pkts.h"			/* packet formats */

#define 	OSPF_VERSION 0x02

#define 	RX_RUN_SPF(A) run_spf(A,0)
#define 	PARTIAL_RUN_SPF(A) run_spf(A,1)
	
#define 	NUKE	TRUE
#define 	NONUKE	FALSE

#define 	DONTFLOOD 	1
#define 	FLOOD 		0

#define		IS_RETRANS	1
#define		NOT_RETRANS	0

/* default values */
#define 	OSPF_NBMA_DFLT_HELLO	30
#define 	OSPF_BC_DFLT_HELLO	10
#define 	OSPF_PTP_DFLT_HELLO	30
#define 	OSPF_VIRT_DFLT_HELLO	60

#define 	ADV_NETNUM(A)  	((A)->ls_hdr.ls_id & (A)->net_mask)
#define 	RTR_ADV_NETNUM(A)  ((A)->lnk_id & (A)->lnk_data)


/***************************************************************************

	   		PROTOCOL DATA STRUCTURES

****************************************************************************/


struct LSDB_SUM {
    struct LSDB_SUM *next;
    struct OSPF_HDR *dbpkt;		/* for dbsum pkts */
    u_short16 len;			/* length of this pkt including ospf hdr size */
    u_short16 cnt;			/* number of lsdb entries in this pkt */
};

#define 	LSDB_SUM_NULL ((struct LSDB_SUM *)0)

struct LS_REQ {
    struct LS_REQ *ptr[2];
    u_long32 ls_id;
    u_long32 adv_rtr;
    u_long32 ls_seq;
    u_short16 ls_chksum;
    u_short16 ls_age;
};

#define 	LS_REQ_NULL ((struct LS_REQ *) 0)


/*
 *		Events causing neighbor state changes
 */

#define		HELLO_RX	0
#define		START		1
#define		TWOWAY		2
#define		ADJ_OK		3
#define		NEGO_DONE	4
#define		EXCH_DONE	5
#define		SEQ_MISMATCH	6
#define		BAD_LS_REQ	7
#define		LOAD_DONE	8
#define		ONEWAY		9
#define		RST_ADJ		10
#define		KILL_NBR	11
#define		INACT_TIMER	12
#define		LLDOWN		13

struct NBR {
    struct NBR *next;
    u_short16 ifspfndx;		/* indx to ifspf */
    u_char8 I_M_MS;		/* for passing init, more and mast/slave bits */
    u_char8 mode;		/* master or slave mode */
#define		SLAVE		1
#define		MASTER		2
#define		SLAVE_HOLD	4	/* holding the last dbsum delay */
    int state;
#define		NDOWN		0
#define		NATTEMPT 	1
#define		NINIT		2
#define		N2WAY		3
#define		NEXSTART	4
#define		NEXCHANGE	5
#define		NLOADING	6
#define		NFULL		7

    u_long32 seq;
    u_long32 nbr_id;
    u_long32 nbrip_addr;
    time_t last_hello;		/* time of rx last hello */
    time_t last_exch;		/* time rx last exchange - hold tmr */
    				/* for multi-access nets */
    u_long32 dr;
    u_long32 bdr;
    u_short16 pri;		/* 0 means not elig */
    u_short16 rtcnt;		/* retrans queue cnt */
    u_short16 dbcnt;		/* dbsum queue cnt */
    u_short16 reqcnt;		/* ls_req queue cnt */
    struct DBRT_LIST *retrans;	/* currently unacked ls advs */
    struct LSDB_SUM *dbsum;	/* dbsum pkts that make up area db */
    struct LS_REQ *ls_req[6];	/* the ones this rtr wants from this nbr */
    int	events;			/* State change counter for MIB */
};

#define		NBRNULL	((struct NBR *)0)

#define 	NO_REQ(N)      ((N)->reqcnt == 0)

/* txpkt defines for NBMA sends */
#define 	ALL_UP_NBRS 	1
#define 	ALL_ELIG_NBRS   2
#define 	ALL_EXCH_NBRS   3
#define 	DR_and_BDR	4


/*
 * 		Events causing IF state changes
 */
#define		INTF_UP		0
#define		WAIT_TIMER	1
#define		BACKUP_SEEN	2
#define		NBR_CHANGE	3
#define		LOOP_IND	4
#define		UNLOOP_IND	5
#define		INTF_DOWN	6


struct INTF {			/* structure contained within the area */
    u_char8 ifspfndx;		/* indx to ifspf which contains socket number */
    u_char8 lsalock;		/* when DR: semaphor for generating LSAs */
    u_char8 type;
#define		BROADCAST	1
#define		NONBROADCAST	2
#define		POINT_TO_POINT	3
#define		VIRTUAL_LINK	4
#define		NBR_TYPE	5	/* general flag */
    u_char8 build_net;		/* Flag to build_net_lsa */
    u_char8 nbr_change;		/* FLag to call nbr_change */
    u_char8 state;
#define		IDOWN		0
#define		ILOOPBACK	1
#define		IWAITING	2
#define		IPOINT_TO_POINT	3
#define		IDr		4
#define		IBACKUP		5
#define		IDrOTHER	6
    u_char8 admstat;		/* enable or disable */
#define 	OSPF_INTF_DISABLE 0
#define 	OSPF_INTF_ENABLE 1
    u_char8 status_check;	/* Check at next hello time */
    time_t lock_time;		/* net lock timer */
    u_short16 cost;		/* one for each tos */
#define 	POLLMOD 0x03
    u_char8 pollmod;		/* poll timer is 4 * hello timer */
#define 	STATUS_MOD 4
    u_char8 status_mod;		/* check status 4 * hello timer */
    time_t wait_time;		/* interface is in waiting state */
    u_short16 hello_timer;	/* interface sends hello (seconds) */
    u_short16 poll_timer;	/* nbma reduced hello tmr, nbr gone */
    time_t dead_timer;		/* time since last recieved hello */
    u_short16 retrans_timer;	/* retransmit interval */
    u_short16 transdly;		/* seconds to transmit a lsu over IF */
    u_char8 authkey[OSPF_AUTH_SIZE];	/* 64 bits of auth */
    int 	nbrIcnt;	/* Count of neighbors > NINIT */
    u_short16 nbrEcnt;		/* Count of neighbors >= EXCHAGE */
    u_short16 nbrFcnt;		/* Count of neighbors == NFULL */
    int events;			/* Cound of state changes */
    struct ACK_LIST *acks;	/* Delayed ack list */
    struct NBR nbr;		/* linked list of nbrs; if we have to select
				   dr then head is fake 'this rtr' nbr
				   if this IF is virtual or point to point
				   use head of list */
    /* the following are used for interfaces that select dr and bdr */
    u_short16 pri;		/* if priority - if 0 not elig */
    u_short16 transarea;	/* Virtual link transit area ndx */
    struct NBR *dr;		/* ptr to dr */
    struct NBR *bdr;		/* ptr to bdr */
};

#define 	INTFNULL ((struct INTF *) 0)

/* Multi-access nets use intf nbr structure for electing dr */
#define 	FirstNbr(I) ( (((I)->type == BROADCAST) ||\
		      	      ((I)->type == NONBROADCAST)) ?\
			       (I)->nbr.next : &((I)->nbr) )

/*
 *  list of configured hosts
 */
struct OSPF_HOSTS {
    struct OSPF_HOSTS *ptr[2];
    u_long32 if_addr;
    u_long32 cost;
};

#define 	HOSTSNULL ((struct OSPF_HOSTS *) 0)

/*
 *  list of nets associated with an area
 */
struct NET_RANGE {
    struct NET_RANGE *ptr[2];
    u_long32 net, mask;
    u_long32 cost; 
};

#define 	NRNULL ((struct NET_RANGE *) 0)

struct AREA {
    u_long32 area_id;
    u_short16 area_ndx;		/* this area's index (ospf.area[ndx]) */

    u_short16 nrcnt;		/* count of net ranges defined for this area */
    struct NET_RANGE nr;	/* list of component networks */
#define		AddAreaNets(A)	(TRUE)

    /* A few stats for the MIB */
    /* MODIFIED 11/24 */
    u_long32 spfcnt;		/* # times spf has been run for this area */
    u_short16 db_int_cnt; 	/* Intra + inter LSDB entry count */
    u_short16 db_cnts[5];	/* Counts for each type of LSDB entry */
    u_long32 db_chksumsum;	/* Checksum sum */
    u_char8 is_trans_area;	/* True if this area is trans area */
    u_char8 virtual_up;		/* True if this trans area has up vl */
    u_short16 ext_option;	/* Defined by the following #defines */
#define		EXT_OPT_NORMAL		0
#define		EXT_OPT_STUB		1
#define		EXT_OPT_NODEFAULT	2

    u_short16 asbr_cnt;		/* count of as bdr rtrs local to this area */
    u_short16 abr_cnt;		/* count of area bdr rtrs local to this area */
    RTR_ROUTE asbrtab;		/* as bdr rtrs local to this area */
    RTR_ROUTE abrtab;		/* area bdr rtrs local to this area */

    u_short16 nbrIcnt;		/* Count of neighbors > NINIT (area) */
    u_short16 nbrEcnt;		/* neighbors >= EXCHANGE (area) */
    u_short16 nbrFcnt;		/* neighbors == NFULL (area) */
    u_short16 ifcnt;		/* will allocate an array at config */
    struct INTF *intf;		/* setup at config time  */

    struct LSDB *htbl[6];	/* the lsdb - O is for stub nets */

    u_short16 authtype;		/* authentication type */
    /* MODIFIED 11/24 */
    u_short16 ifUcnt;		/* count of up INTFs include virt lnks for BB */
    struct LSDB spf;		/* area's spf tree; head is this rtr */
    struct LSDB candidates;	/* area'scandidate list for dijkstra */
    struct LSDB asblst;		/* reachable asbs (connected areas) */
    struct LSDB sumnetlst;	/* reachable nets from attached areas */
    struct LSDB interlst;	/* reachable inter-area routes from backbone */
    struct LSDB dflt_sum;	/* used if ABRtr and stub area */
    u_long32 dflt_metric;	/* metric for default route */
    struct LSDB_LIST *txq;	/* for building and sending sum lsa */
    time_t lock_time;		/* rtr lock timer */

    struct OSPF_HOSTS hosts;
    u_char8 hostcnt;

    u_char8 lsalock;		/* MinLsInterval semaphore for LSA origination*/
    u_char8 spfsched;		/* Schedule flags for spf algorithm */
    u_char8 build_rtr;		/* Schedule build_rtr_lsa */

#define		FLAG_NO_PROBLEM	0x0
#define 	RTRSCHED 	0x02
#define 	NETSCHED 	0x04
#define 	INTRASCHED 	0x07
#define 	SUMNETSCHED 	0x08
#define 	SUMASBSCHED 	0x10
#define 	SUMSCHED 	(SUMNETSCHED | SUMASBSCHED)
#define 	INTSCHED 	(INTRASCHED | SUMSCHED)
#define 	ASESCHED 	0x20
#define 	SUMASESCHED 	(SUMSCHED | ASESCHED)
#define 	ALLSCHED 	(INTSCHED | ASESCHED)
#define		FLAG_BUILD_RTR	0x40
#define		FLAG_BUILD_NET	0x80
#define		FLAG_LOAD_DONE	0x100
#define  	FLAG_FOUND_REQ	0x400
#define		FLAG_NO_BUFS	0x800
#define		FLAG_BAD_REQ	0x1000
#define 	SCHED_BIT(T) 	(1 << (T))
#define 	RTRLOCK  	0x40
#define 	NETLOCK  	0x80
};

#define AREANULL ((struct AREA *)0)

/* GLOBAL FOR THE PROTOCOL */

struct OSPF {
#define MY_ID   ospf.my_rtr_id
    u_long32 my_rtr_id;		/* this router's ID  */
    /* MODIFIED 1/28/92 */
    timer_t	ospf_start_time;/* when ospf was initialized */
#define 	OSPF_ENABLED 	1
#define 	OSPF_DISABLED 	0
    int nintf;			/* number of ospf interfaces */
    int nh_high;		/* high count of nh block */
    int nbrcnt;			/* number of neighbors known to this router */
    int nbrIcnt;		/* number of neighbors >= Init state */
    int nbrEcnt;		/* number of neighbors >= Exchange state */
    int nbrFcnt;		/* number of neighbors == Full state */
    int acnt;			/* number of areas, 0 will allways be bacbone */
    struct AREA *area;		/* areas connected to this router -
				   an array which will be allocated
				   at init time, area[0] is the bacbone */
    int vcnt;			/* number of virtual links */
    int vUPcnt;
    struct INTF *vl;		/* list of configured virtal links */
    struct LSDB ase[HTBLSIZE];	/* external ls advertisements */
    int fwd_cnt;		/* Forward address cache count */
    time_t ase_start;		/* time started tq_AseLsa */
    int ase_age_ndx;		/* starting index of next dbage */
    struct LSDB *cur_ase;	/* current ptr */
    struct LSDB my_ase_list;	/* self generated ase list */
    struct LSDB db_free_list;	/* list of LSAs to be freed */
    int asbr;			/* as border rtr flag */
    struct LSDB dflt_ase;	/* used for generating OSPF default */
    u_long32	dflt_metric;	/* Default metric */
    int preference_external;	/* Preference for OSPF ASE routes */
    long32 rtab_rev;		/* Rev number of ospf's portion of the rtab */

    /* A few stats for the MIB */
    u_long32 db_chksumsum;	/* Checksum sum of external ASEs */
    int ospf_admin_stat;	/* Enabled or Disabled */
    int db_ase_cnt;		/* Number of ASEs in the LSDB */
    /* MODIFIED 1/17 */
    int db_cnt;			/* Total number of entries in the LSDB */
    int rx_new_lsa;		/* Number of new LSAs received */
    int orig_new_lsa;		/* Number of self originated LSAs */

    /* A few mib things */
	
    /* MODIFIED 1/17 */
    /*
     * A single trap is generated per event where an event is a 
     * timer expiring or a packet being received 
     */
#define TRAP_REF_LEN		2
#define TRAP_REF_UPDATE\
	{ospf.trap_ref[1] += (!(++(ospf.trap_ref[0]))) ? 1 : 0;}
#define TRAP_REF_CURRENT(T) \
	( ((T)[0] == ospf.trap_ref[0]) && ((T)[1] == ospf.trap_ref[1]) )
	/* Set T to equal ospf.trap_ref */
#define TRAP_REF_SET(T) \
	{ (T)[0] = ospf.trap_ref[0]; (T)[1] = ospf.trap_ref[1]; }
    u_long32	trap_ref[TRAP_REF_LEN];	

    /* MODIFIED 1/17 */
    /* LSDB limits */
    int		lsdb_limit;	/* Configured upper limit of LSDBs */
    int		lsdb_overflow;
    int		lsdb_hiwater;	/* Hi water mark for LSDB. 95% of lsdb_limit */
    int		lsdb_hiwater_exceeded;

    /* Sort block for INTFs */
    struct IF_SB *if_sb;
    int 	if_sb_nel;

    /* Sort block for virtual INTFs */
    struct IF_SB *virt_if_sb;
    int 	virt_if_sb_nel;

    /* Sort block for NBRs */
    struct NBR 	**nbr_sb;
    int 	nbr_sb_nel;
    u_short16	nbr_sb_not_valid;
    short16	nbr_sb_size;

    /* Sort block for lsdb */
    struct LSDB **ls_sb;	/* ptr to array of LSDB ptrs for MIB sorting */
    int	sb_size;		/* Size of allocated ls_sb */
    int	sb_nel;			/* Number of elements in sb */
    u_short16	sb_area_ndx;	/* Area ndx and ls type sorted in ls_sb */
    u_char8	sb_ls_type;
    u_char8	sb_not_valid;	/* If a new db entry has been added within
				   the range of area and type mark sb invalid */
				   

#define  	OSPF_BACKBONE	0
#define  	SPFCNT  	(ospf.rtab_rev)
#define  	RTAB_REV	SPFCNT		/* use as rtab revision # */
#define 	GOTBACKBONE	(ospf.vcnt || ospf.area[0].ifcnt)
#define 	IAmBorderRtr	(GOTBACKBONE && ospf.acnt > 1)
#define 	IAmASBorderRtr  (ospf.asbr)
#define 	FirstArea	(GOTBACKBONE) ? ospf.area : &(ospf.area[1])

#ifdef  DBG
    FILE *logfp;
#endif	/* DBG */

#ifdef PKTLOG
    FILE *dmpfp;
#endif	/* PKTLOG */
}
#ifndef UMBC_SIM
 ospf;
#else
 ospf_sim[RTR_CNT];
#endif
