/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions: 						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

#define MaxNbr(MAX,N){\
	 if ((N->pri > MAX->pri) ||\
	    ((N->pri == MAX->pri) && (ntohl(N->nbr_id) > ntohl(MAX->nbr_id))))\
			MAX = N;}

/*
 *	Choose bdr for intf
 *	- Event: nbr change or wait timer
 */
void
bdr_bakeoff(intf)
struct INTF *intf;
{

    struct NBR *n = NBRNULL;
    struct NBR *BestBDr = NBRNULL;

    /* Hi is for nbrs who haven't declaired themselves bdr or dr */
    struct NBR *BestBDrHi = NBRNULL;

    /* 
     * choose bdr 
     */
    for (n = &(intf->nbr); n != NBRNULL; n = n->next) {
	/* if we can't see ourself, n isn't elig or n is dr... */
	if ((n->state < N2WAY) ||
	    (!n->pri) ||
	    (n->dr == n->nbrip_addr) ||
	    (intf->dr == n))
	    continue;

	if (n->bdr == n->nbrip_addr) {	
	    /* 
	     * nbr has declaired himself bdr 
	     */
	    if (BestBDr == NBRNULL) {
		BestBDr = n;
	    } else {
		MaxNbr(BestBDr, n);
	    }
	} else {	/* keep track of the highest priority choice */
	    /* exclude nbrs that are think they are dr */
	    if (BestBDrHi == NBRNULL) {
		BestBDrHi = n;
	    } else {
		MaxNbr(BestBDrHi, n);
	    }
	}
    }

    if (BestBDr != NBRNULL) {
	intf->bdr = BestBDr;
    } else if (BestBDrHi != NBRNULL) {
	intf->bdr = BestBDrHi;
    }

    /* 
     * set this rtr's nbr structure to correct bdr 
     */
    if (intf->bdr != NBRNULL) {
	intf->nbr.bdr = intf->bdr->nbrip_addr;
#ifdef DBG
	sprintf(_ospf_prt_buf, "BDR is %s\n", lntoa(intf->nbr.bdr));
	DBG_LOG(_ospf_prt_buf);
#endif
    }
}


/*
 *	Choose dr for intf
 *	- Event: nbr change or wait timer
 *	  Return 1 if DR = BDR else return 0
 */
void
dr_bakeoff(intf)
struct INTF *intf;
{

    struct NBR *n = NBRNULL;
    struct NBR *BestDr = NBRNULL;

    /* choose dr */
    for (n = &(intf->nbr); n != NBRNULL; n = n->next) {
	/*
	 * can see ourself in nbrs hello && nbr
	 *  has declaired himself dr
	 */
	if ((n->state >= N2WAY) &&
	    (n->pri) &&
	    (n->dr == n->nbrip_addr)) {
	    if (BestDr == NBRNULL) {
		BestDr = n;
	    } else {
		MaxNbr(BestDr, n);
	    }
	}
    }

    if (BestDr != NBRNULL) {
	intf->dr = BestDr;
	intf->nbr.dr = intf->dr->nbrip_addr;
#ifdef DBG
	sprintf(_ospf_prt_buf, ">DR is %s\n", lntoa(intf->nbr.dr));
	DBG_LOG(_ospf_prt_buf);
#endif
    } else if (intf->bdr != NBRNULL) {
	/* promote backup */
	intf->dr = intf->bdr;
	intf->nbr.dr = intf->bdr->nbrip_addr;
	/* This rtr can't be DR and BDr */
	if (intf->dr == &(intf->nbr)) {
	    intf->nbr.bdr = 0;
	    intf->bdr = NBRNULL;
	}
#ifdef DBG
	sprintf(_ospf_prt_buf, "DR is %s\n", lntoa(intf->nbr.dr));
	DBG_LOG(_ospf_prt_buf);
#endif
    }
}

void
choose_dr(intf)
struct INTF *intf;
{

    struct NBR *olddr = intf->dr;
    struct NBR *oldbdr = intf->bdr;
    struct NBR *n;

    CHOOSE_DR_LOG(lntoa(NDX_IP_ADDR(intf->ifspfndx)));
    intf->bdr = intf->dr = NBRNULL;
    bdr_bakeoff(intf);
    dr_bakeoff(intf);

    /* 
     * rerun backup if bdr or dr and this rtr is either or used to be 
     */
    if ( ((olddr != intf->dr) &&
		((olddr == &(intf->nbr)) || (intf->dr == &(intf->nbr)))) ||
         ((oldbdr != intf->bdr) &&
		((oldbdr == &(intf->nbr)) || (intf->bdr == &(intf->nbr)))) )
	bdr_bakeoff(intf);

    /* 
     * set to correct state 
     */
    if (intf->dr == &(intf->nbr))	/* I am dr */
	intf->state = IDr;
    else if (intf->bdr == &(intf->nbr))	/* I am bdr */
	intf->state = IBACKUP;
    else
	intf->state = IDrOTHER;

    if (intf->dr != NBRNULL) {
	DR_LOG(lntoa(intf->dr->nbr_id));
    } else {
	DR_LOG(" None chosen");
    }
    if (intf->bdr != NBRNULL) {
	BDR_LOG(lntoa(intf->bdr->nbr_id));
    } else {
	BDR_LOG(" None chosen");
    }

    /* handle adjacency madness */
    if (intf->state == IDr || intf->state == IBACKUP) {
	/* 
	 * if we weren't dr or bdr do the adj_ok thing to nbrs 
	 */
	if ((olddr != &(intf->nbr) && oldbdr != &(intf->nbr))) {
	    for (n = intf->nbr.next; n != NBRNULL; n = n->next) {
		if (n->state == N2WAY)
		    (*(nbr_trans[ADJ_OK][n->state])) (intf, n);
		else if (intf->type == NONBROADCAST && n->state < N2WAY)
		    (*(nbr_trans[START][n->state])) (intf, n);
	    }
	}
	/* 
	 * flag build_net 
   	 */
	if (intf->state == IDr)
	    intf->build_net = TRUE;	
    } else {
	if (olddr == &(intf->nbr) || oldbdr == &(intf->nbr)) {
	    /* 
	     * usedta be but no more so rst adj and adj with new dr 
	     */
	    for (n = intf->nbr.next; n != NBRNULL; n = n->next)
		if ((n != intf->dr && n != intf->bdr) &&
		    (n->state > N2WAY))
		    (*(nbr_trans[RST_ADJ][n->state])) (intf, n);
	    if (intf->dr != NBRNULL && intf->dr->state <= N2WAY)
		(*(nbr_trans[ADJ_OK][intf->dr->state])) (intf, intf->dr);
	    if (intf->bdr != NBRNULL && intf->bdr->state <= N2WAY)
		(*(nbr_trans[ADJ_OK][intf->bdr->state])) (intf, intf->bdr);
	} else {
	    /* 
	     * we weren't dr or bdr but the current one has changed 
	     */
	    if (intf->dr != NBRNULL &&
		intf->dr != olddr &&
		intf->dr != oldbdr)
		/* establish adj with new dr */
		(*(nbr_trans[ADJ_OK][intf->dr->state])) (intf, intf->dr);
	    if (intf->bdr != NBRNULL &&
		intf->bdr != olddr &&
		intf->dr != oldbdr &&
		intf->dr != intf->bdr)
		/* establish adj with new bdr */
		(*(nbr_trans[ADJ_OK][intf->bdr->state])) (intf, intf->bdr);
	    /* 
	     * reset the old ones if necessary 
	     */
	    if (olddr != NBRNULL &&
		(olddr != intf->dr && olddr != intf->bdr) &&
		(olddr->state > N2WAY))
		(*(nbr_trans[RST_ADJ][olddr->state])) (intf, olddr);
	    if (oldbdr != NBRNULL &&
		(oldbdr != intf->dr && oldbdr != intf->bdr) &&
		(oldbdr->state > N2WAY))
		(*(nbr_trans[RST_ADJ][oldbdr->state])) (intf, oldbdr);
	}
    }
}

#endif				/* PROTO_OSPF */
