/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF

#ifdef NO_IFF_MULTICAST
int M;					/* fd for receiving multicast */
#endif

/*
 * For testing large amounts of external entries
 */
void
ase_test_config(fn)
char *fn;
{
    FILE *fp;
    OSPF_ASE_BLOCK eb;
    u_long32 addr;
    u_long32 mask;
    int type, cnt;
    char addr_st[20], mask_st[20];
    struct avl_node s;
    char buf[300];
    OROUTE *r;

    if ((fp = fopen(fn, "r")) == (FILE *) NULL) 
    {
	sprintf(_ospf_prt_buf,"Can't open %s",fn);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }

    CLEAR_BUF(&eb, sizeof(OSPF_ASE_BLOCK));
    while (fgets(buf, 300, fp)) {
    	CLEAR_BUF(&s, sizeof(AVL));
    	if(sscanf(buf, "%s %s %d", addr_st, mask_st, &type) != 3)
		adios("Bad read from ase config file");

    	addr = inet_addr(addr_st);
	mask = inet_addr(mask_st);

    	if (r = RT_FIND(addr) && RT_DEST(r) == addr)
		adios("Duplicate net read from ase config file");
	DBG_LOG("In Static add\n");

	STATIC_INFO_ALLOC(&s);
	STATIC_NH_NDX(&s) = 1;
	r = RT_INSERT(	addr,
			mask,
			&STATIC_NH_NDX(&s),
			1,
			PR_STATIC,
			STATIC_INFO(&s) );
	STATIC_PREF(r) = STATIC_ROUTE_PREF;
	eb.ce[eb.count].action = E_NEW;
	/* Will choose static... */
	choose_proto(r);
    	eb.ce[eb.count].proto 	= STATIC_OWNER;
    	eb.ce[eb.count].route 	= r;
    	eb.ce[eb.count].faddr 	= 0;
    	eb.ce[eb.count].metric 	= 1;
    	eb.ce[eb.count].age 	= 0;
    	eb.ce[eb.count].etype 	= type;
    	eb.ce[eb.count].tag 	= 0;
    	if ((++(eb.count)) == MAX_ASE_IMPORT)
	{
    		ase_import(&eb);
    		CLEAR_BUF(&eb, sizeof(OSPF_ASE_BLOCK));
	}
    }

    if (eb.count)
    	ase_import(&eb);
}

void
ospf_config(cfile)
char *cfile;
{
    char outfile[30];

    conf(cfile);

#ifdef 	DBG

#ifdef  UMBC_SIM
    sprintf(outfile, "%s%d", "iolog.out", _OSPF_INDEX);
#else
    sprintf(outfile, "%s", "iolog.out");
#endif				/* UMBC_SIM */
    if ((iologfp = fopen(outfile, "w")) == (FILE *) NULL)
	adios("Can't open iolog.out");
#endif				/* DBG */

#ifdef PKTLOG

#ifdef  UMBC_SIM
    sprintf(outfile, "%s%d", "pkt.dmp", _OSPF_INDEX);
#else
    sprintf(outfile, "%s", "pkt.dmp");
#endif				/* UMBC_SIM */

    if ((dumpfp = fopen(outfile, "w")) == (FILE *) NULL)
	adios("Can't open pkt.dmp");
#endif				/* PKTLOG */

}

#ifndef UMBC_SIM

void ospf_daemon()
{
    int fd;

    /*
     * Kill parent
     */
    if (fork())
	 exit(0);
    /* 
     * cd to root directory 
     */
    chdir("/");


    /* 
     * Close stdio and stderr and reopen as /dev/null 
     */
    fd = getdtablesize();
    while (fd) {
        fd--;
    	close(fd);
    }

    fd = fopen("/u/ospf/ospfd.log", "w");
    dup2(0, 1);
    dup2(0, 2);

#ifdef NOTDEF
    fd = open("/dev/null", O_RDONLY);
    dup2(0, 1);
    dup2(0, 2);
#endif

/*
    if ((fd = open("/dev/tty", O_RDWR)) >= 0)
    {
      ioctl(fd, TIOCNOTTY, NULLCP);
    }
*/
}

void
main(argc, argv)
int argc;
char **argv;
{

#ifdef MIB_TEST
#define MIB_STATE_ACCEPT	1
#define MIB_STATE_READ		2
#define MIB_MOD			4	/* check for a req every MODth select */
#endif

    int oldmask;
    int highfd = 0;
    int rxerr;
    int nfound;
    int cc;
    int dummy;
    int iphdrlen;
#ifdef MIB_TEST
    int mib_state = MIB_STATE_ACCEPT;
    int mib_accept_sock = 0, mib_read_sock = 0;
    int mib_mod = 0;
#endif
    struct timeval timeout;
    char packet[MAXRXPKTSIZ];
    u_long32 src, dst;
    int i;
#ifdef FD_ZERO
    fd_set readfds;
#else
    int readfds;
#define FD_ZERO(SET) (*SET) = 0
#define FD_SET(FD,SET)	((*SET) |= (1 << (FD)))
#define FD_ISSET(FD,SET) ((*SET) & (1 << (FD)))
#endif
    FILE *pid_fp;
    FILE *fopen();
    struct OSPF_HDR *ohdr;

/*
    ospf_daemon();
*/

    if (argc < 2)
	ciao("Usage: ospfd <config file>\n");

    ospf_config(argv[1]);
    ospf_init();

    /*
     * Store the PID in /etc/ospfd.pid
     */
    if ((pid_fp = fopen("/etc/ospfd.pid", "w")) == (FILE *) NULL) 
    {
	sprintf(_ospf_prt_buf,"Can't open /etc/ospfd.pid");
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }

    fprintf(pid_fp,"%d\n",getpid());
    fclose(pid_fp);
    /* 
     * ASE test config file
     */
    if (argc == 3) {
	ase_test_config(argv[2]);
    }

    /* get the high fd so we don't select more bits than we have to */
    for (i = 0; i < ospf.nintf; i++)
	if (IF_NDX[i].fd > highfd)
	    highfd = IF_NDX[i].fd;

#ifdef MIB_TEST
    mib_accept_sock = mib_sock_init();
    mib_state = MIB_STATE_ACCEPT;
#endif

#ifdef NO_IFF_MULTICAST
    if (M > highfd)
	highfd = M;			/* for receiving mulitcast */
#endif

    for (nfound = 0;; nfound = 0) {	/* forever */

#ifdef MIB_TEST
	mib_mod = (++mib_mod) % MIB_MOD;
	if (mib_state == MIB_STATE_ACCEPT) {
    	    mib_read_sock = accept(mib_accept_sock, 0, 0);
            if (mib_read_sock > 0) {
		mib_state = MIB_STATE_READ;
    		if (mib_read_sock > highfd)
		    highfd = mib_read_sock;  /* for receiving mgmt requests */
	    }
	}
#endif

	timeout.tv_sec = 30;
	timeout.tv_usec = 0;
	FD_ZERO(&readfds);

	for (i = 0; i < ospf.nintf; i++) {
	    FD_SET(IF_NDX[i].fd, &readfds);
	}


#ifdef NO_IFF_MULTICAST
	FD_SET(M, &readfds);
#endif

#ifdef MIB_TEST
	if ((!mib_mod) && mib_state == MIB_STATE_READ) {
	    FD_SET(mib_read_sock,&readfds);
	}
#endif

	if ((nfound = select(highfd + 1,
			     &readfds,
			     0,
			     0,
			     &timeout)) < 0) {
	    /* could be an alarm has gone off */
	    if (errno == EINTR)
		continue;
	    else {
		perror("ospf_rxpkt: select");
		ospf_bye();
	    }
	}

	if (!nfound)
	    continue;

	sig_block(&oldmask);

	for (i = 0; i < ospf.nintf; i++) {
	    if (FD_ISSET(IF_NDX[i].fd, &readfds)) {
		dummy = 0;
		if ((cc = recvfrom(IF_NDX[i].fd, packet, sizeof(packet),
				   0, NULL, &dummy)) <= 0) {
		    if (cc == 0 || errno == EWOULDBLOCK)
			continue;
		    else {
			perror("recvfrom 1");
			ospf_bye();
		    }
		} else {
		    src = (u_long32) ((struct ip *) packet)->ip_src.s_addr;
		    dst = (u_long32) ((struct ip *) packet)->ip_dst.s_addr;
		    if (cc < (20 + OSPF_HDR_SIZE)) {
			/* Unicast rx (hence the 0) */
			RX_LOG(0, PKT_TOO_SMALL, i, src);
			continue;
		    }
		    iphdrlen = ((struct ip *) packet)->ip_hl;
		    iphdrlen <<= 2;
		    ohdr = (struct OSPF_HDR *) & packet[iphdrlen];
		    if ((!NDX_DISABLE(i)) ||
			(NDX_DISABLE(i) && (!ohdr->type))) {
			rxerr = ospf_rxpkt((struct ip *) packet,
				      ohdr,
				      i,
				      src,
				      dst,
				      0);
			/* Unicast rx (hence the 0) */
			RX_LOG(0, rxerr, i, src);
		    }
		}
	    }
	}

#ifdef MIB_TEST
	if ( ((!mib_mod) && mib_state == MIB_STATE_READ) &&
	      (FD_ISSET(mib_read_sock,&readfds)) )
		if (!get_mib_request(mib_read_sock)) {
	    	    mib_state = MIB_STATE_ACCEPT;
		    close(mib_read_sock);
		}
#endif

#ifdef NO_IFF_MULTICAST
	if (FD_ISSET(M, &readfds)) {
	    dummy = 0;
	    if ((cc = recvfrom(M, packet, sizeof(packet), 0, NULL, &dummy)) <= 0) {
		if (cc != 0 && errno != EWOULDBLOCK) {
		    perror("recvfrom 2");
		    ospf_bye();
		}
	    } else {
		src = (u_long32) ((struct ip *) packet)->ip_src.s_addr;
		dst = (u_long32) ((struct ip *) packet)->ip_dst.s_addr;
		if (dst == AllSPFRouters || dst == AllDRouters) {
		    /* associate ifspfndx with src */
		    for (i = 0; i < ospf.nintf; i++) {
			if ((src & IF_NDX[i].ifip_mask) == ifspfNETNUM(i)) {
			    /* intf is not elig so can't rx for AllDRtrs */
			    if ((!ifspfIF(i).pri) && dst == AllDRouters)
				continue;
			    iphdrlen = ((struct ip *) packet)->ip_hl;
			    iphdrlen << = 2;
			    ohdr = (struct OSPF_HDR *) & packet[iphdrlen];
			    if ((!NDX_DISABLE(i)) ||
				(NDX_DISABLE(i) && (!ohdr->type))) {
				rxerr = ospf_rxpkt((struct ip *) packet,
					      ohdr,
					      i,
					      src,
					      dst,
					      1);
				/* Multicast rx (hence the 1) */
				RX_LOG(1, rxerr, i, src);
			    }
			    break;
			}
			/* else not multicast pkt */
		    }
		}
	    }
	}
#endif

	sig_restore(oldmask);
    }
}

#endif

#endif				/* PROTO_OSPF */
