
char *rtr_id_hdr = "###############################################################################\n#                                                                             #\n# ROUTER ID DEFINITION							      #\n# SYNTAX - 								      #\n# RTRID: <xx.xx.xx.xx>	<ASBR On/Off> <Dflt metric - if 0 will not generate>  #\n#									      #\n###############################################################################\n\n";


char *area_hdr = "###############################################################################\n#									      #\n# AREA DEFINITION							      #\n# SYNTAX -								      #\n# AREA: <area id> <area type> <default metric>    			      #\n# 	RANGE: <net> <mask> 						      #\n# 	RANGE: <net> <mask> 						      #\n#		.                        				      #\n#		.                        				      #\n#		.                        				      #\n# 	RANGE: <net> <mask> 						      #\n#	AUTH: <authentication type for area>				      #\n#									      #\n# area types: 0 = accept ASEs, 1 = stub use dflt metric, 2 = stub no dflt     #\n#									      #\n###############################################################################\n\n\nAREA: 0.0.0.0	0	0	 \n	AUTH:	0\n\n\n\n";

char *intf_hdr = "###############################################################################\n#									      #\n# INTERFACE DEFINITION							      #\n# Note: the area associated with each interface must be defined		      #\n#	 before the interface is; also all intervals are in seconds	      #\n#									      #\n# SYNTAX -  (must be on the same line)					      #\n#	IF: <Associated area id> <IP addr> <type> <if cost>          	      #\n#	    <rxmt interval> <trans delay> <priority>                          #\n#	    <Hello interval> <rtr dead interval> <Auth key - 8 Chars max>     #\n#	type could be 1 = broadcast, 2 = nonbroadcast multi access or         #\n#		3 = point to point					      #\n#									      #\n###############################################################################\n\n";



#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/socket.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <net/if.h>
#include <net/route.h>


#define		BROADCAST	1
#define		NONBROADCAST	2
#define		POINT_TO_POINT	3
#define		HOST		4

extern int errno;

int ifcnt;
u_long	rtr_id;

struct INTF {
	u_long	ip_addr;
	char 	name[IFNAMSIZ];
	int	type;
} intfs[100], *intf;


int vs;			/* socket for checking if intf is up */

const char *
lntoa(addr)
u_long addr;
{
    static int i = 0;
    static char bufs[8][20];
    unsigned char *p = (unsigned char *) &addr;

    i = (i + 1) % (sizeof bufs / sizeof bufs[0]);
    sprintf(bufs[i], "%d.%d.%d.%d", p[0], p[1], p[2], p[3]);
    return (bufs[i]);
}


/*
 *  Grab interface configuration, and create a socket for each machine
 *  interface address and bind them to an ospfigp interface
 *
 */
void
main(argc,argv)
int argc;
char **argv;
{
    char buf[2000];
    struct ifconf ifc;
    struct ifreq ifreq, *ifr;
    int n, i;
    FILE *fp, *fopen();

    if (argc < 2) {
	printf("Usage: ospfconf <output filename>\n");
	exit(1);
    }

    if ((fp = fopen(argv[1], "w")) == (FILE *) NULL) 
    {
	fprintf(stderr,"Can't open %s",argv[1]);
	exit(1);
    }

    /* 
     * Create socket for getting if information 
     */
    if ((vs = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	perror("vs=socket(AF_INET, SOCK_DGRAM)");
	exit(1);
    }

    ifc.ifc_len = sizeof(buf);
    ifc.ifc_buf = buf;
    if (ioctl(vs, SIOCGIFCONF, (char *) &ifc) < 0) {
	perror("spfconf: ioctl(SIOCGIFCONF) fails");
	exit(1);
    }

    n = ifc.ifc_len / sizeof(struct ifreq);

    intf = intfs;

    /* 
     * Get interface info from ifc 
     */
    for (ifr = ifc.ifc_req; n > 0; n--, ifr++) {
	if (ifr->ifr_addr.sa_family != AF_INET)
	    continue;
	ifreq = *ifr;

	if (ioctl(vs, SIOCGIFADDR, (char *) &ifreq) < 0) {
	    perror("makecfg: SIOCGIFADDR fails");
	    continue;
	} else {
	    intf->ip_addr = 
		 ((struct sockaddr_in*) &ifreq.ifr_addr)->sin_addr.s_addr;
	}

	if (ioctl(vs, SIOCGIFFLAGS, (char *) &ifreq) < 0) {
	    perror("ospf: SIOCGIFFFLAGS fails");
	    continue;
	}

	strncpy(intf->name, ifreq.ifr_name, IFNAMSIZ);

	if ((ifreq.ifr_flags & IFF_UP) == 0) {
	    fprintf(stderr, "makecfg: interface %s is down\n",intf->name);
	    continue;
	}

    	if (ifreq.ifr_flags & IFF_LOOPBACK) {
	     if (intf->ip_addr == htonl(0x7f000001)) continue;
	    else intf->type = HOST;
	} else if (ifreq.ifr_flags & IFF_POINTOPOINT)
		intf->type = POINT_TO_POINT;
	else if (ifreq.ifr_flags & IFF_BROADCAST)
		intf->type = BROADCAST;

	if (!rtr_id)
		rtr_id = intf->ip_addr;
	else if (intf->ip_addr < rtr_id)
		rtr_id = intf->ip_addr;

	intf++;
	ifcnt++;

    }
	
    
    fprintf(fp,"%s",rtr_id_hdr);
    fprintf(fp,"RTRID: %s	0	0\n\n\n",lntoa(rtr_id));
    fprintf(fp,"%s",area_hdr);
    fprintf(fp,"%s",intf_hdr);

    for (i=0;i<ifcnt;i++) {
    	fprintf(fp,"# %s\n\n",intfs[i].name);
	if (intfs[i].type == HOST) {
	    fprintf(fp,"HOST:	0.0.0.0		%s	1\n\n",
		lntoa(intfs[i].ip_addr));
	} else {
	    fprintf(fp,"IF: 0.0.0.0	%s	%d",
		lntoa(intfs[i].ip_addr),
		intfs[i].type);
	    fprintf(fp,"	10	5	1	");
 	    if (intfs[i].type == POINT_TO_POINT)
 		fprintf(fp,"0	10 	40	area0\n\n");
	    else
 		fprintf(fp,"5	10 	40	area0\n\n");
	}

    }
    fclose(fp);
}
