/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * These routines (along with port/ospf_rtab) manipulate the OSPF routing table.
 */
/* MODIFIED 6/15/93 */
/*
 * Is this route an active intra or inter area route?
 */
int 
int_active(from,area,r)
int from;
struct AREA *area;
OROUTE *r;
{
    int ptype = PTYPE_BIT(ORT_PTYPE(r));

    if (ptype & PTYPE_INTER) {
	if (!(from & ptype))
	    return(TRUE);
	return((ORT_REV(r) == RTAB_REV));
    }

    if (ptype & PTYPE_INTRA) {
	if (!(from & ptype))
	    return(TRUE);
	if (ORT_AREA(r) == (area)) {
	     return((ORT_REV(r) == RTAB_REV));
	}
	return(TRUE);
    }

    return(FALSE);
}


/*
 * Is this route an active intra area route?
 */
int 
intra_active(from,area,r)
int from;
struct AREA *area;
OROUTE *r;
{
    int ptype = PTYPE_BIT(ORT_PTYPE(r));

    if (ptype & PTYPE_INTRA) {
	if (!(from & ptype))
	    return(TRUE);
	if (ORT_AREA(r) == (area)) {
	     return((ORT_REV(r) == RTAB_REV));
	}
	return(TRUE);
    }

    return(FALSE);
}

/*
 * Enqueue r in order in this queue
 */
void
enq_rtab(qhp, r)
RTR_ROUTE *qhp, *r;
{
    RTR_ROUTE *o;
    u_long32 id = RRT_DEST(r);

    for ( o = qhp;
          ( (RRT_NEXT(o) != RTR_ROUTENULL) && (id < RRT_DEST(RRT_NEXT(o))) );
	  o = RRT_NEXT(o) ) ;
    /*
     * insert r between o and o->next
     */
    ADD_Q(o, r);
}


/*
 * Search for id in this linked list
 */
RTR_ROUTE *
routescan(head, id)
struct OSPF_ROUTE *head;
u_long32 id;
{
    struct OSPF_ROUTE *r = head;

    for (; (r != RTR_ROUTENULL && id < RRT_DEST(r)); r = RRT_NEXT(r)) {
    }
    if (r != RTR_ROUTENULL && id == RRT_DEST(r))
	return (r);
    return (RTR_ROUTENULL);
}


/* MODIFIED 1/13 - added rr */
/*
 * add v to the routing table
 */
int
addroute(a, v, from, from_area)
struct AREA *a, *from_area;		/* associatiated area */
struct LSDB *v;
int from;
{
    OROUTE *r;
    int nhndx = 0;
    RTR_ROUTE *rr = RTR_ROUTENULL;

    if (!DB_RTR(v))
	adios("addroute, lsdb is null");

    /*
     * The from parameter is the starting level of spf algorithm,
     * and is used to check for valid entry
     */
#ifdef DBG
    sprintf(_ospf_prt_buf, "ADD ROUTE: LS TYPE: %d ID: %s",
	    LS_TYPE(v),
	    lntoa(LS_ID(v)));
    DBG_LOG(_ospf_prt_buf);
#endif
    switch (LS_TYPE(v)) {
	case LS_STUB:
	case LS_NET:
	    /*
	     * if attached to this net, interface is the first hop
	     */
	    if (DB_ROUTE(v) != ROUTENULL) {
		/*
		 * had route, check for change
		 */
		ORT_REV(DB_ROUTE(v)) = RTAB_REV;	/* mark current */
		nexthop_cmp(DB_ROUTE(v), v);
		DB_WHERE(v) = ON_RTAB;
	    } else {
		/*
	         * Check to see if anyone else was advertising this net
	         * This will also handle the case of inter becoming intra
	         */
		if ( (r = findroute( DB_NETNUM(v),PTYPE_ANY )) != ROUTENULL ) 
		{
		    /*
		     * Bind route to this vertex
		     * There could be stub routes and net routes untill
		     * things converge, so use the best route
		     */
		    if ( (ORT_PTYPE(r) > PTYPE_INTRA) ||
			 (ORT_REV(r) != RTAB_REV) ||
			 ((ORT_REV(r) == RTAB_REV) &&
			  (ORT_COST(r) > DB_DIST(v))) )
		    {
			rvbind(r, v, a);
			DB_WHERE(v) = ON_RTAB;
		    }
		} else {
		    /*
		     * no previous net adv
		     */
		    if (!build_route(a, v))
			return (FLAG_NO_BUFS);
		    DB_WHERE(v) = ON_RTAB;
		}
	    }
	    break;

	case LS_RTR:

    	     /* MODIFIED 1/10 */
	     /* Only one next hop route is kept for ABR and ASBR */
    	     nhndx = DB_NH_NDX(v,0);

	    /*
	     * only asbr and abr are added to rtab
	     */
	    if (ntohs(DB_RTR(v)->E_B) & bit_B) {
		/*
	    	 * AREA Border
	    	 */
		/* if this is this rtr, set accordingly */
		if (v == DB_PTR(&a->spf)[NEXT])
		    DB_DIST(v) = 0;
		if (DB_AB_RTR(v) != RTR_ROUTENULL) {
		    /* MODIFIED 1/10 */
		    rr = DB_AB_RTR(v);

		    RRT_REV(rr) = RTAB_REV;
		    if ((RRT_COST(rr) != DB_DIST(v)) ||
			(RRT_NH_NDX(rr) != nhndx)) {
			RRT_COST(rr) = DB_DIST(v);
			RRT_NH_NDX(rr) = nhndx;
			RRT_CHANGE(rr) = E_NEXTHOP;
		    } else
			RRT_CHANGE(rr) = E_UNCHANGE;
		} else {
		    if (!rtr_build_route(a, v, DTYPE_ABR))
			return (FLAG_NO_BUFS);
		}
		DB_WHERE(v) = ON_RTAB;
	    }
	    /*
	     * AS Border router
	     */
	    if (ntohs(DB_RTR(v)->E_B) & bit_E) {
		/* if this is this rtr, set accordingly */
		if (v == DB_PTR(&a->spf)[NEXT])
		    DB_DIST(v) = 0;
		if (DB_ASB_RTR(v) != RTR_ROUTENULL) {
		    rr = DB_ASB_RTR(v);

		    RRT_REV(rr) = RTAB_REV;
		    if ((RRT_COST(rr) != DB_DIST(v)) ||
			(RRT_NH_NDX(rr) != nhndx)) {
			RRT_COST(rr) = DB_DIST(v);
			RRT_NH_NDX(rr) = nhndx;
			RRT_CHANGE(rr) = E_NEXTHOP;
		    } else
			RRT_CHANGE(rr) = E_UNCHANGE;
		} else {
		    /*
		     * this node is ASBR
		     */
		    if (!rtr_build_route(a, v, DTYPE_ASBR))
			return (FLAG_NO_BUFS);
		}
		DB_WHERE(v) = ON_RTAB;
	    }
	    break;

	case LS_SUM_NET:

	    if (DB_ROUTE(v) == ROUTENULL) {
		/*
		 * see if one exists on current routing table
		 */
		if ( (r = findroute( DB_NETNUM(v), PTYPE_ANY) ) != ROUTENULL ) 
		{
#ifdef DBG
		    sprintf(_ospf_prt_buf,
			    "Sum: rt found area %d rt area %d from %x ptype %d",
			    from_area->area_id,
			    ORT_AREA(r)->area_id,
			    from,
			    ORT_PTYPE(r));
		    DBG_LOG(_ospf_prt_buf);
#endif
		    /*
		     * check for possible intra-area route
		     */
		    if ((INTRA_ACTIVE(from, from_area, r))) {
			DBG_LOG("Valid Intra, returning from LS_SUM_NET");
			return (FLAG_NO_PROBLEM);
		    } else {
			/*
			 * old or ase changing to inter so bind r to this v
			 */
			DBG_LOG("Invalid Intra, doing the binding thing");
			rvbind(r, v, a);
			return (FLAG_NO_PROBLEM);
		    }
		} else {
		    /*
		     * route doesn't exist
		     */
		    DBG_LOG("Sum route not found");
		    if (!build_route(a, v))
			return (FLAG_NO_BUFS);
		}
	    } else {
		/*
		 * v->route != ROUTENULL
		 * area border checked in netsum
		 */
		DBG_LOG("route != ROUTENULL");
		ORT_REV(DB_ROUTE(v)) = RTAB_REV;
		nexthop_cmp(DB_ROUTE(v), v);
	    }
	    break;

	case LS_SUM_ASB:
	    /*
	     * have route to as bdr rtr
	     */
	    if (DB_ASB_RTR(v) == RTR_ROUTENULL) {
		/*
		 * put on inter-area asb route tab
		 */
		DBG_LOG("DB_ASB == RTR_ROUTENULL");
		if (!rtr_build_route(a, v, DTYPE_ASBR))
		    return (FLAG_NO_BUFS);
	    } else {
    	     	nhndx = DB_NH_NDX(v,0);
		rr = DB_ASB_RTR(v);

		DBG_LOG("DB_ASB != RTR_ROUTENULL");
		RRT_REV(rr) = RTAB_REV;
		if (DB_DIST(v) != RRT_COST(rr))
		    RRT_COST(rr) = DB_DIST(v);
		if (RRT_NH_NDX(rr) != nhndx) {
		    RRT_NH_NDX(rr) = nhndx;
		    RRT_CHANGE(rr) = E_NEXTHOP;
		} else
		    RRT_CHANGE(rr) = E_UNCHANGE;
	    }
	    break;

	case LS_ASE:
	    if (DB_ROUTE(v) == ROUTENULL) {
		/* see if one exists on current routing table */
		if ( (r = findroute( DB_NETNUM(v), PTYPE_ANY)) != ROUTENULL ) 
		{
		    /*
		     * may have already run intra and sum for single area
		     */
		    if ((INT_ACTIVE(from, from_area, r))) {
			DBG_LOG("ASE Add route INT active is true\n");
			return (FLAG_NO_PROBLEM);
		    } else {
			/*
			 * current route is invalid - bind route to this v
			 */
			DBG_LOG("ASE Add route INT active is false\n");
			rvbind(r, v, a);
			return (FLAG_NO_PROBLEM);
		    }
		} else {
		    /*
		     * no existing route
		     */
		    if (!build_route(a, v))
			return (FLAG_NO_BUFS);
		}
	    } else {
		/*
 		 * v->route != ROUTENULL
		 * AS border was found is ase()
		 */
		ORT_REV(DB_ROUTE(v)) = RTAB_REV;
		ase_nexthop_cmp(DB_ROUTE(v), v);
	    }
	    break;
    }
    return (FLAG_NO_PROBLEM);
}



/*
 *	Locate a router route in the router route tables
 */
RTR_ROUTE *
rtr_findroute(area, id, dtype, ptype)
struct AREA *area;
u_long32 id;
int dtype, ptype;
{
    	struct AREA *a;
	RTR_ROUTE *rr;

    	if (ptype & PTYPE_INTRA) 
	{
	    /* search intra area tables */
	    switch (dtype) 
	    {
	   	case DTYPE_ASBR:
		  /*
		   * Look for the ASBR in the defined area
		   */
		  if (area != AREANULL) {
	   		rr = routescan(area->asbrtab.ptr[NEXT], id);
	    		if (ptype == PTYPE_INTRA)
				return ( rr );
			break;
		  } else {

		  	/*
		   	 * Look for the asbr in any directly attached area
		   	 */
		  	for (a = FirstArea; a < &ospf.area[ospf.acnt]; a++)
		    	   if ( (rr = routescan(a->asbrtab.ptr[NEXT], id))
				!= RTR_ROUTENULL )
				return ( rr );
	    		if (ptype == PTYPE_INTRA)
				return ( RTR_ROUTENULL );
			
			break;
		  }

	    	  case DTYPE_ABR:
			return ( routescan(area->abrtab.ptr[NEXT], id) );

	      }
    	}

    	if (ptype & PTYPE_INTER) {
		/* 
	 	 * search inter area routing tables for the ASBR
	 	 */
		return( routescan(sum_asb_rtab.ptr[NEXT], id) );
    	}
    	return (RTR_ROUTENULL);
}


/*
 * Allocate route and install it in the router routing table
 */
int
rtr_build_route(a, v, dtype)
struct AREA *a;				/* associatiated area */
struct LSDB *v;
int dtype;
{
    RTR_ROUTE *rr;

    RRT_ALLOC(rr);
    if (rr == RTR_ROUTENULL)
	return (FALSE);

    switch (dtype) {
	case DTYPE_ABR:
	    DB_AB_RTR(v) = rr;
	    break;

	case DTYPE_ASBR:
	    DB_ASB_RTR(v) = rr;
	    break;
    }

    RRT_REV(rr) = RTAB_REV;
    RRT_AREA(rr) = a;
    RRT_DTYPE(rr) = dtype;
    RRT_COST(rr) = DB_DIST(v);
    RRT_PTYPE(rr) = LS_TYPE(v);
    /* MODIFIED 1/10 */
    RRT_NH_NDX(rr) = DB_NH_NDX(v,0);
    RRT_ADVRTR(rr) = ADV_RTR(v);
    /* set up back link */
    RRT_V(rr) = v;
    RT_DEST(rr) = LS_ID(v);
    RRT_CHANGE(rr) = E_NEW;

    /* Install on routing table */
    switch (LS_TYPE(v)) {
	case LS_SUM_ASB:
	    enq_rtab(&sum_asb_rtab, rr);
	    break;
	case LS_RTR:
	    if (dtype == DTYPE_ABR)
		enq_rtab(&a->abrtab, rr);
	    if (dtype == DTYPE_ASBR)
		enq_rtab(&a->asbrtab, rr);
	    break;
    }

    return (TRUE);
}

#endif				/* PROTO_OSPF */
