/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef IFF_MULTICAST
extern int M;

#endif

extern int RxMon();

int (*RxPktTab[6]) () = {
    RxMon,
    RxHello,
    RxDb,
    RxLsReq,
    RxLinkUp,
    RxLsAck
};


int
ospf_rxpkt(ip, o_hdr, ndx, src, dst, mc)
IP_HDR *ip;
struct OSPF_HDR *o_hdr;
int ndx;
u_long32 src, dst;
int mc;					/* true if multicast rx */
{

    struct INTF *newif = INTFNULL;
    int i, len, ret;
    u_short16 chk, oldchk;
    u_char8 newAuth[OSPF_AUTH_SIZE];
    struct AREA *area = AREANULL;

    /* Log current time */
    ospf_get_sys_time();
    /* ospf_stash_refresh(); */
    /* bypass for monitor request pkt */
    if (o_hdr->type == O_MON)
	goto bypass1;

    /*
     *  XXX if admstat is disable
     */
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */
    /* check that IP destination is to interface or IP multicast addr */
    if (dst == AllSPFRouters) {
	if (ifspfIF(ndx).type != POINT_TO_POINT &&
	    ifspfIF(ndx).type != BROADCAST)
	    return (BAD_IP_DEST);
    } else if (dst == AllDRouters) {
	if (ifspfIF(ndx).state != IDr && ifspfIF(ndx).state != IBACKUP)
	    return (BAD_IP_DEST);
    } else if (dst != NDX_IP_ADDR(ndx))
	return (BAD_IP_DEST);

    /* if it is not originated from here continue to process */
    if (src == NDX_IP_ADDR(ndx))
	return (MY_IP_SRC);

  bypass1:				/* for monitor requests */

    if (IP_PROTOCOL(ip) != IPPROTO_OSPF)
	return (BAD_IP_PROTOID);

    len = ntohs(o_hdr->length);
    if (len < OSPF_HDR_SIZE)
	return (PKT_TOO_SMALL);
    if (len > IP_LENGTH(ip))
	return (BAD_OSPF_LENGTH);

    /* OSPF hdr */
    if (o_hdr->version != OSPF_VERSION)
	return (BAD_OSPF_VERSION);
    /* Save and zero out auth fields */
    if (o_hdr->AuType) {
	AUTH_COPY(o_hdr->Auth, newAuth, 8);
    }
    CLEAR_BUF(o_hdr->Auth, 8);
    oldchk = o_hdr->checksum;
    o_hdr->checksum = 0;
    chk = inet_chksum((char *) o_hdr, len);

    if (chk != oldchk)
	return (BAD_OSPF_CHKSUM);
    o_hdr->checksum = chk;

    /* bypass for monitor request pkt */
    if (o_hdr->type == O_MON)
	goto bypass2;

    /* the area id check stuff - VIRTUAL or Standard link? */
    if (ntohl(o_hdr->area_id) == ifspfAREA(ndx).area_id) {/* not virtual */
/*
XXX didn't I have a check in here for mask?
*/
	if ((src & NDX_IP_MASK(ndx)) != (NDX_IP_ADDR(ndx) & NDX_IP_MASK(ndx)))
	    return (BAD_IF_AREAID);
	newif = &(ifspfIF(ndx));
	area = &(ifspfAREA(ndx));
    } else {				/* pkt should be from virtual link */
	if (!(IAmBorderRtr))
	    return (RXPACKET_TO_ABR);
	for (i = 0; i < ospf.vcnt; i++) {
	    /* if VL 1) should be from configured nbr
		     2) nbr is area border rtr
		     3) trans area is same as receiving IF's area */
	    if ((ospf.vl[i].nbr.nbr_id == o_hdr->rtr_id) &&
		(o_hdr->area_id == 0) &&/* from backbone */
		(ospf.vl[i].transarea == ifspfAREA(ndx).area_ndx)) {
		newif = &(ospf.vl[i]);
		area = ospf.area;
		break;
	    }
	}
	if (!newif) {
#ifdef DBG
	    sprintf(_ospf_prt_buf, "nbr id %s %s area_id %d ndx %d %d",
		    lntoa(ospf.vl[i].nbr.nbr_id),
		    lntoa(o_hdr->rtr_id),
		    o_hdr->area_id,
		    ospf.vl[i].transarea,
		    ifspfAREA(ndx).area_ndx);
	    DBG_LOG(_ospf_prt_buf);
#endif
	    return (BAD_VL);
	}
    }


#ifdef PKTLOG
    if (o_hdr->type <= 5)
	PKT_LOG(dumpfp, o_hdr, len, (o_hdr->type), 1, src);
#endif

    if (ntohs(o_hdr->AuType) != area->authtype) {
	return (BAD_AUTH_TYPE);
    }

    if (area->authtype && AUTH_FIELD_CMP(newAuth, newif->authkey)) {
	return (BAD_AUTH_KEY);
    }

  bypass2:				/* for monitor requests */


    if (o_hdr->type <= 5) {
	ret = (*RxPktTab[o_hdr->type])
	    (&(o_hdr->un), newif, src, o_hdr->rtr_id, len, mc);
	if (ret < LASTLOG) {
	    if (ret == GOOD_RX)
		ret = o_hdr->type;
	} else {
	    ospf_bye();
	}

    } else {
	return (BAD_OSPF_TYPE);
    }
    return (ret);
}
