/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF

#ifdef DBG
#define PRINTCONF
#endif

static int gotbackbone;   /* to insure if backbone is defined, ifs are also */

/*
 * SYNTAX -
 * RTRID: <xx.xx.xx.xx> <0|1> - 1 will turn on asbr bit in rtr advertisement
 */
void
rtrid(fp, buf)
FILE *fp;
char *buf;
{
    char rtr_id[30];
    u_long32 id;

    gotbackbone = FALSE;
    sscanf(buf, "%*s %s %d %ld", rtr_id, &ospf.asbr, &ospf.dflt_metric);
    if ((id = inet_addr(rtr_id)) == -1) {
	sprintf(_ospf_prt_buf, "conf: rtr_id: (%s): unknown host \n", rtr_id);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    MY_ID = id;
    /* get head of global lists */
    DBGUTS_ALLOC(&(ospf.db_free_list));
    DBGUTS_ALLOC(&(ospf.my_ase_list));
#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"conf: RTRID: %s\n", lntoa(MY_ID));
    OSPF_LOG(_ospf_prt_buf);
#endif
}


/*
 * SYNTAX -
 * AREA: <area id> <stub area option> <stub metric>
 * 	RANGE: <net> <net mask> - net ranges are optional
 * 	RANGE: <net> <net mask>
 *		.
 *		.
 *		.
 * 	RANGE: <net> <net mask>
 * AUTH: <authentication type for area>
 *
 * AREA: ...
 */
void
area(fp, buf)
FILE *fp;
char *buf;
{
    char 	what[30], net[20], mask[20], area_id_st[20];
    int 	ndx, cnt, i;
    int 	ext_option;
    u_long32 	dflt_metric;
    u_long32	area_id;
    struct 	NET_RANGE *nr;
    struct	AREA *area;

    sscanf(buf, "%*s %s %d %ld", area_id_st, &ext_option, &dflt_metric);

    if ((area_id = inet_addr(area_id_st)) == -1) {
	sprintf(_ospf_prt_buf, "conf: area_id: (%s) is bad\n",
		area_id_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    if (area_id == 0)
	gotbackbone++;

    /* allocate a new area if there are none */
    if (ospf.acnt == 0) {
	cnt = (area_id) ? 2 : 1;/* if area is backbone allocate 1 else 2 */
	ndx = cnt - 1;		/* set new area index */
	AREA_ALLOC(ospf.area, cnt);
	ospf.acnt += cnt;
    } else {			/* realloc another area structure */
	if (area_id) {		/* if not backbone realloc another */
	    ospf.acnt += 1;
	    AREA_REALLOC(ospf.area, (sizeof(struct AREA) * ospf.acnt));
	    ndx = ospf.acnt - 1;
	} else
	    ndx = 0;		/* got backbone */
    }

    area = &ospf.area[ndx];
    CLEAR_BUF(area,sizeof(struct AREA));
    area->area_ndx = ndx;	/* for routing table stuff */
    area->area_id = area_id;

    /* set up hash table for lsdb */
    for (i = LS_STUB; i < LS_ASE; i++)
	DBBLOCK_ALLOC((area->htbl[i]), HTBLSIZE);
    /* set ase to global */
    area->htbl[LS_ASE] = ospf.ase;
    area->ext_option = ext_option;
    area->dflt_metric = dflt_metric;

    /* LSDB link-list heads */
    DBGUTS_ALLOC(&area->spf);		/* spf tree */
    DBGUTS_ALLOC(&area->candidates);	/* spf candidate list */
    DBGUTS_ALLOC(&area->asblst);	/* asb rtrs from direct areas */
    DBGUTS_ALLOC(&area->sumnetlst);	/* nets from attached areas */
    DBGUTS_ALLOC(&area->interlst);	/* routes from backbone */
    DBGUTS_ALLOC(&area->dflt_sum);	/* if ABRtr and stub area */


#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"\n  AREA: id: = %s acnt: %d ext option: %d dflt metric: %d\n",
	lntoa(area->area_id),
	ospf.acnt,
    	area->ext_option,
    	area->dflt_metric);
    OSPF_LOG(_ospf_prt_buf);
#endif
    /* Get Network Info */
    /* Read in nets info assume at most 10 nets on a line;
	    first line needs the keyword RANGE: -
	    check for comments or keyword AUTH: to terminate nets */
    bzero(buf, 300);
    while (fgets(buf, 300, fp)) {
	bzero(net, 20);
	bzero(mask, 20);
	bzero(what, 20);
	sscanf(buf, "%s", what);
	if (!strlen(what))
	    continue;
	if (what[0] == '#')
	    continue;
	if (!strcmp(what, "AUTH:"))
	    break;
	if (!strcmp(what, "RANGE:")) {
	    area->nrcnt += 1;
#ifdef PRINTCONF
	    sprintf(_ospf_prt_buf,"    Adding Nets:\n");
	    OSPF_LOG(_ospf_prt_buf);
#endif
	    NR_ALLOC(nr);

	    sscanf(buf, "%*s %s %s", net, mask);
#ifdef PRINTCONF
	    sprintf(_ospf_prt_buf,"      %s %s\n", net, mask);
	    OSPF_LOG(_ospf_prt_buf);
#endif
	    if ((nr->net = inet_addr(net)) == -1) {
		sprintf(_ospf_prt_buf, "conf: %s: unknown net \n", net);
		OSPF_LOG(_ospf_prt_buf);
		exit(1);
	    }
	    if ((nr->mask = inet_addr(mask)) == -1) {
		sprintf(_ospf_prt_buf, "conf: %s: unknown mask \n", mask);
		OSPF_LOG(_ospf_prt_buf);
		exit(1);
	    }
	    range_enq(area,nr);
	} else
	    ciao(" looking for strings: RANGE: AUTH: or #");

    }
    /* net should contain "AUTH:" and mask should have auth type */
    if (strcmp(what, "AUTH:"))
	ciao("looking for string:  AUTH:");
    sscanf(buf, "%*s %d",&(area->authtype));
#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"   Authorization type: %d\n", area->authtype);
    OSPF_LOG(_ospf_prt_buf);
#endif
}


/*
 *	SYNTAX: (must be on the same line)
 *	VIRTUAL: <Virtual nghbr id > <Transit area> <trans delay> <rxmt intrvl>
 * 		 <Hello intrvl> <Router Dead intrvl> <Auth Key 8 Chars max>
 *
 */
void
virtual(fp, buf)
FILE *fp;
char *buf;
{
    char nbr_id_st[20], area_id_st[20];
    struct INTF *intf;
    struct AREA *a;
    u_long32 transarea;			/* transit area id */

    if (!gotbackbone)
	ciao("conf: virtual: VL defined but backbone hasn't been");

    ospf.vcnt += 1;
    if ((ospf.vcnt - 1) == 0) {
	INTF_ALLOC(ospf.vl);
    } else {				/* realloc another area structure */
	INTF_REALLOC(ospf.vl, (sizeof(struct INTF) * ospf.vcnt));
    }


    intf = &(ospf.vl[ospf.vcnt - 1]);
    CLEAR_BUF(intf,sizeof(struct INTF));
    intf->state = IDOWN;
    intf->admstat = OSPF_INTF_ENABLE;
    sscanf(buf, "%*s %s %s %hd %hd %hd %ld %s",
	   nbr_id_st,
	   area_id_st,
	   &(intf->transdly),
	   &(intf->retrans_timer),
	   &(intf->hello_timer),
	   &(intf->dead_timer),
	   intf->authkey);

    if ((transarea = inet_addr(area_id_st)) == -1) {
	sprintf(_ospf_prt_buf, "conf: transit area_id: (%s) is bad\n",
		area_id_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }

	
    intf->type = VIRTUAL_LINK;
    intf->nbr.state = NDOWN;
    if ((intf->nbr.nbr_id = inet_addr(nbr_id_st)) == -1) {
	sprintf(_ospf_prt_buf, "conf: virtual: (%s): weird nbr id\n",
		nbr_id_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    /* set general hello interval and check against dead interval */

#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"  VIRTUAL: nbr id: %s transarea: %s \n",
	   nbr_id_st,
	   area_id_st);
    OSPF_LOG(_ospf_prt_buf);
    sprintf(_ospf_prt_buf,"           type: %d trans delay: %d rxmt: %d \n",
	   intf->type,
	   intf->transdly,
	   intf->retrans_timer);
    OSPF_LOG(_ospf_prt_buf);
    sprintf(_ospf_prt_buf,"           hello tmr: %d dead tmr: %d authentication key: %s\n",

	   intf->hello_timer,
	   intf->dead_timer,
	   intf->authkey);
    OSPF_LOG(_ospf_prt_buf);
#endif

    for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++)
	if (transarea == a->area_id) {
	    intf->transarea = a->area_ndx;
	    a->is_trans_area = TRUE;
	    return;
	}
    sprintf(_ospf_prt_buf, "conf: virtual: transit area %d not configured)\n",
	    transarea);
    OSPF_LOG(_ospf_prt_buf);
    exit(1);
}




/* Note: the area associated with each interface must be defined
 *	 before the interface is; also all intervals are in seconds
 *
 *	Syntax: (must be on the same line)
 *	IF:<Associated area id> <IF IP addr> <type> <cost>
 *         <rxmt intrvl> <trans delay> <priority> <Hello intrvl>
 *	   <Router Dead intrvl> <Auth Key - 8 Chars max 32 bits>
 *		<NBR IP addr if point to point>
 *	type could be 1 = broadcast, 2 = nonbroadcast multi access or
 *		3 = point to point
 *	cost must have a value
 */
void
interface(fp, buf)
FILE *fp;
char *buf;
{
    int i;
    int type = 0;
    char str[30];
    char ifaddr_st[20], ptopaddr_st[20], area_id_st[20];
    u_long area_id;
    struct INTF *intf;

    sscanf(buf, "%*s %s", area_id_st);
    if ((area_id = inet_addr(area_id_st)) == -1) {
	sprintf(_ospf_prt_buf, "conf: interface: (%s) is bad\n",
		area_id_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }

    if ((area_id == 0) && (!gotbackbone))
	ciao("interface: attemp to define BkBone IF without defining BkBone");

    /* zip through the areas */
    for (i = 0;; i++)
	if (i == ospf.acnt) {
	    sprintf(_ospf_prt_buf, "conf: interface: area id %s not found\n",
		    lntoa(area_id));
	    OSPF_LOG(_ospf_prt_buf);
	    exit(1);
	} else if (area_id == ospf.area[i].area_id) {
	    IF_NDX[ospf.nintf].area_ndx = i;
	    /* allocate a new interface if none exist */
	    ospf.area[i].ifcnt += 1;
	    if (ospf.area[i].ifcnt - 1 == 0) {
		INTF_ALLOC(ospf.area[i].intf);
	    } else {			/* realloc another area structure */
		INTF_REALLOC(ospf.area[i].intf,
			     (sizeof(struct INTF) * ospf.area[i].ifcnt));
	    }

	    intf =
		&(ospf.area[i].intf[ospf.area[i].ifcnt - 1]);
    	    CLEAR_BUF(intf,sizeof(struct INTF));
	    /* set up ifspf table to lookup of socket number */
	    IF_NDX[ospf.nintf].if_ndx = ospf.area[i].ifcnt - 1;
	    break;
	}
    intf->ifspfndx = ospf.nintf;	/* facilitate output */
    intf->state = IDOWN;
    intf->admstat = OSPF_INTF_ENABLE;
    ospf.nintf += 1;			/* incriment high value for ifspf */
    sscanf(buf, "%*s %*s %s %d %hd %hd %hd %hd %hd %ld %s %s",
	   ifaddr_st,
	   &(type),
	   &(intf->cost),
	   &(intf->retrans_timer),
	   &(intf->transdly),
	   &(intf->pri),
	   &(intf->hello_timer),
	   &(intf->dead_timer),
	   intf->authkey,
	   ptopaddr_st);
    intf->type = type;

#ifndef IFF_MULTICAST
    if (intf->type == BROADCAST)
	ciao("ospf config: IFF_MULTICAST is not defined, use NBMA instead");
#endif
    if ((IF_NDX[ospf.nintf - 1].ifip_addr = inet_addr(ifaddr_st)) == -1) {
	sprintf(_ospf_prt_buf, "conf: interface: %s: unknown addr\n",ifaddr_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
#ifdef UMBC_SIM
    sim_socket(IF_NDX[intf->ifspfndx].ifip_addr, intf->ifspfndx);
#endif

#ifndef IFF_MULTICAST
    if ((intf->type == POINT_TO_POINT) &&
	((!strlen(ptopaddr_st)) ||
	 ((intf->nbr.nbrip_addr = inet_addr(ptopaddr_st)) == -1))) {
	sprintf(_ospf_prt_buf, "conf: interface: %s: unknown ptop addr\n",
		ptopaddr_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
#endif

    /* a few validation checks */
    if (!(intf->cost))
	ciao("interface: cost for tos 0 not set");
    if (!(intf->type >= 1 && intf->type <= 3)) {
	sprintf(_ospf_prt_buf, "interface: illegal type (%d)\n", intf->type);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }

    if (intf->type == BROADCAST || intf->type == NONBROADCAST) {
	if (intf->type == BROADCAST)
	    if (intf->pri > 0xFF)
		ciao("interface: illegal priority\n");
	/* set up fake nbr structure for dr election */
	intf->nbr.nbr_id = MY_ID;
	intf->nbr.nbrip_addr = IF_NDX[intf->ifspfndx].ifip_addr;
	intf->nbr.pri = intf->pri;
	intf->nbr.state = N2WAY;
    }

#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"  IF: area: %s addr: %s type: %d\n",
	   lntoa(area_id),
	   ifaddr_st,
	   intf->type);
    OSPF_LOG(_ospf_prt_buf);

    sprintf(_ospf_prt_buf,"      cost: %d rxmt: %d transdly: %d priority: %d\n",
	   intf->cost,
	   intf->retrans_timer,
	   intf->transdly,
	   intf->pri);
    OSPF_LOG(_ospf_prt_buf);

    sprintf(_ospf_prt_buf,"      hello tmr: %d dead tmr: %d authentication key: %s\n",
	   intf->hello_timer,
	   intf->dead_timer,
	   intf->authkey);
    OSPF_LOG(_ospf_prt_buf);
#endif
}

/*
 * Non-broadcast, multi-access network parameters
 *
 * SYNTAX -
 * NBMA: <interface id>
 * ATTRTR: <rtr ip addr> <priority>
 *		.
 *		.
 *		.
 *         <rtr ip addr> <priority>
 * POLLINT: <poll interval>
 */
void
nbma(fp, buf)
FILE *fp;
char *buf;
{
    u_long id;
    char str[30];
    struct INTF *intf;
    struct NBR *nbr;
    char attflag = 0;		/* haven't read in keyword ATTRTR: yet */
    int i;
    struct NB {
	char id[30];
	int pri;
    } nb;


    sscanf(buf, "%*s %s", str);
    if ((id = inet_addr(str)) == -1) {
	sprintf(_ospf_prt_buf, "conf: nbma: (%s): unknown host \n", str);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    /* first find associated interface */
    for (i = 0; i < ospf.nintf; i++) {
	/* index'o'mania */
	if (id == IF_NDX[i].ifip_addr) {
	    intf = &(ifspfIF(i));
	    goto foundif;
	}
    }
    sprintf(_ospf_prt_buf, "conf: nbma interface id %s not found\n",
	    lntoa(id));
    OSPF_LOG(_ospf_prt_buf);
    exit(1);

  foundif:
    if (intf->type != NONBROADCAST)
#ifndef TEST
	ciao("conf: nbma: if is not defined to be nonbroadcast");
#else
	sprintf(_ospf_prt_buf, "nbma: if is not defined to be nonbroadcast\n");
	OSPF_LOG(_ospf_prt_buf);
#endif
    if (!intf->pri)		/* not eligible - no params necessary */
	sprintf(_ospf_prt_buf,"NBMA config params shows that it is not eligible\n");
	OSPF_LOG(_ospf_prt_buf);

    intf->nbr.pri = intf->pri;
#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"  NBMA: if: %s pri: %d\n", lntoa(id), intf->pri);
    OSPF_LOG(_ospf_prt_buf);
#endif

    while (fgets(buf, 300, fp)) {
	bzero(&nb, sizeof(struct NB));
	sscanf(buf, "%s%d", nb.id, &(nb.pri));
	if (!strlen(nb.id))
	    continue;
	if (nb.id[0] == '#')
	    continue;
	if (!strcmp(nb.id, "POLLINT:"))
	    break;

	 if (!strncmp(nb.id, "ATTRTR:", 7)) {
		bzero(&nb, sizeof(struct NB));
		sscanf(buf, "%*s%s%d", nb.id, &nb.pri);
		attflag++;
#ifdef PRINTCONF
		sprintf(_ospf_prt_buf,"    Adding NBMA neighbor:\n");
		OSPF_LOG(_ospf_prt_buf);
#endif
	    } else
		ciao(">> looking for strings: ATTRTR: POLLINT: or #");

	if (strlen(nb.id) || (nb.id[0] != '#')) {

	    /* allocate a new nbr */
	    intf->nbrIcnt += 1;
	    NBR_ALLOC(nbr);
	    if ((nbr->nbrip_addr = inet_addr(nb.id)) == -1) {
		sprintf(_ospf_prt_buf, "conf: nbma: (%s): unknown if \n",
			nb.id);
		OSPF_LOG(_ospf_prt_buf);
		exit(1);
	    }
	    nbr->state = NDOWN;
	    nbr->ifspfndx = intf->ifspfndx;
	    nbr->pri = nb.pri;
	    /* put on interface's neighbor queue */
	    nbr_enq(intf,nbr);
#ifdef PRINTCONF
	    sprintf(_ospf_prt_buf,"    nbr's ip addr %s pri %d\n",
		   lntoa(nbr->nbrip_addr),
		   nbr->pri);
	    OSPF_LOG(_ospf_prt_buf);
#endif
	}
    }

    /* have to be able to configure a stub net */
    if (!intf->nbrIcnt) {
	sprintf(_ospf_prt_buf,"conf: nbma: no nbrs have been configured");
	OSPF_LOG(_ospf_prt_buf);
    }

    /* nbrIcnt is used to keep count of nbrs in state >= INIT */
    intf->nbrIcnt = 0;

    /* should be at POLLINT: */
    if (strcmp(nb.id, "POLLINT:"))
	ciao("conf: nbma: POLLINT: not defined\n");

    intf->poll_timer = nb.pri;

    if (intf->poll_timer <= intf->hello_timer) {
	sprintf(_ospf_prt_buf,
		"NBMA: poll intrvl for intf %s sb <= hello intrvl\n",str);
	OSPF_LOG(_ospf_prt_buf);
    }

#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"    nbr poll interval: %d\n", intf->poll_timer);
    OSPF_LOG(_ospf_prt_buf);
#endif
}

/*
 * SYNTAX -
 * HOST: <area id> <host ip address> <cost>
 *
 */
void
hroute(fp, buf)
FILE *fp;
char *buf;
{
    char area_id_st[20], addr_st[20];
    u_long32 area_id;
    struct OSPF_HOSTS *newhost;
    int i, cost;

    sscanf(buf, "%*s %s %s %d", area_id_st, addr_st, &cost);
    if ((!strlen(area_id_st)) ||
	(!strlen(addr_st)) ||
	(!cost))
	ciao("conf: hroute: illegal config param");

    HOST_ALLOC(newhost);
    if ((newhost->if_addr = inet_addr(addr_st)) == -1) {
	sprintf(_ospf_prt_buf, "conf: HOST: %s: invalid host address\n",
		addr_st);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    newhost->cost = htons(cost);

    area_id = inet_addr(area_id_st);

    /* zip through the areas */
    for (i = 0;; i++)
	if (i == ospf.acnt) {
	    sprintf(_ospf_prt_buf,"conf: HOST: area id %d not found\n",
		area_id_st);
	    OSPF_LOG(_ospf_prt_buf);
	    exit(1);
	} else if (area_id == ospf.area[i].area_id) {
	    ospf.area[i].hostcnt += 1;
	    host_enq(&(ospf.area[i]), newhost);
#ifdef PRINTCONF
/*
	    if (!ospf.area[i].ifcnt) {
		sprintf(_ospf_prt_buf,"    Warning: no interfaces configured on area %s\n",
			area_id_st);
		OSPF_LOG(_ospf_prt_buf);
	    }
*/
#endif
	    break;
	}
#ifdef PRINTCONF
    sprintf(_ospf_prt_buf,"    Adding Host %s cost %d to area %s:\n", addr_st, cost, area_id_st);
    OSPF_LOG(_ospf_prt_buf);
#endif
}

void
zip(fp, buf)
FILE *fp;
char *buf;
{
    sprintf(_ospf_prt_buf,"NULL\n");
    OSPF_LOG(_ospf_prt_buf);
}

struct CONF conftab[7] =
{
    {"RTRID:", rtrid},
    {"AREA:", area},
    {"VIRTUAL:", virtual},
    {"IF:", interface},
    {"NBMA:", nbma},
    {"HOST:", hroute},
    {"ZIP:", zip}};

#ifdef CONFTEST
main(argc, argv)
int argc;
char **argv;
{

    FILE *fp, *fopen();
    char fn[30], buf[300], new[80];
    int i;

    if (argc != 2)
	exit(1);
    if ((fp = fopen(argv[1], "r")) == (FILE *) NULL) {
	sprintf(_ospf_prt_buf, "Can't open config file %s\n", argv[1]);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
#else

void
conf(fn)
char *fn;
{
    FILE *fp, *fopen();
    char buf[300], new[80];
    int i;


    if ((fp = fopen(fn, "r")) == (FILE *) NULL) {
	sprintf(_ospf_prt_buf, "Can't open config file %s\n", fn);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
#endif

    bzero(buf, 300);
    while (fgets(buf, 300, fp)) {
	if (!strcmp(buf, "\n"))
	    continue;			/* blank line */
    	bzero(new, 80);
	sscanf(buf, "%s", new);
	for (i = 0; i < 7; i++) {
	    if (!strcmp(new, conftab[i].in)) {
		conftab[i].routine(fp, buf);
		break;
	    }

	    if (i == 6 && new[0] != '#' && new[0] != 0) {
		sprintf(_ospf_prt_buf,
			"conf: illegal input [%s] in file: %s\n",
			new, fn);
		OSPF_LOG(_ospf_prt_buf);
		exit(1);
	    }
	}
	bzero(buf, 300);
    }
    fclose(fp);
    /* recheck for a good configuration */
    if (!MY_ID)
	ciao("conf: Rtr Id has not been defined");
    if (!ospf.acnt)
	ciao("conf: No Areas defined");
    if (!ospf.nintf)
	ciao("conf: No Interfaces defined");
    if (ospf.acnt < 2 && ospf.vcnt)
	ciao("conf: virtual link configured < 2 areas");
    if (gotbackbone && !(GOTBACKBONE))
	ciao("conf: backbone is defined BUT no backbone IFs");
    if ((ospf.acnt > 2) && !(GOTBACKBONE))
	ciao("conf: 2 or more areas have been defined: need to configure backbone (area 0)");
#ifndef UMBC_SIM
    create_sockets();
#endif
}

#endif				/* PROTO_OSPF */
