/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF

extern char *lntoa();
extern char *logtype[];
extern char *IfStates[];
extern char *NbrStates[];
OROUTE *get_rtab();
OROUTE *avl_insert();

int dump = 10;
u_long32 ospf_log_flags = ( DEFAULT_LOG_FLAGS | OSPF_PKT_LOG | HELLO_LOG );


const char *nbr_modes[5] =
{"None  ",
 "Slave ",
 "Master",
 "Null  ",
 "Hold  "};

const char *if_types[] =
{"Bcast",
 "NBMA",
 "PtoP",
 "Virt"};

const char *ls_types[] =
{"STUB",
 "RTR",
 "NET",
 "SUM_NET",
 "SUM_ASB",
 "ASE"};

const char *paths[] =
{"STUB",
 "RTR ",
 "INT ",
 "SUM ",
 "SUM ",
 "EXT"};

const char *con_types[] =
{"Router",
 "Transit net",
 "Stub net",
 "Virtual"};


/*
 * Recursively calls itself doing a reverse traverse
 * - derrives levels spacing with I which is incrimented at each level
 */
void
printit(count, node)
int count;				/* used for generating blanks */
AVL *node;				/* root for subtrees */
{

    int i;
    char spaces[100];

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    CLEAR_BUF(spaces, sizeof(spaces));

    if (node != AVLNULL) {
	printit(count + 1, node->ptr[RLINK]);
	for (i = 0; i < (count * 4); i++)
	    spaces[i] = ' ';
	sprintf(_ospf_prt_buf, "%s %s %s %s owner: %d\n\n",
		spaces,
		lntoa(RT_DEST(node)),
		lntoa(RT_MASK(node)),
		(RT_DELETE(node)) ? " (Deleted)" : " ",
		(RT_OWNER(node)));
	MON_WRITE(_ospf_prt_buf);
	printit(count + 1, node->ptr[LLINK]);
    }
}

/*
 * prints the data strucure in a tree-like fashion
 *        - calls the recursive procedure printit
 */
void
printree(head, addr, mask)
AVL *head;
u_long addr, mask;			/* Unused */
{
    if (head->ptr[RLINK] == AVLNULL) {
	return;
    }
    MON_WRITE("\n\n");
    printit(0, ospf_rtab->ptr[RLINK]);
}

/*
 * Change the router asb bit and sched a build and send
 */
void
asb_toggle()
{
    struct AREA *a;

    ospf.asbr = (ospf.asbr) ? FALSE : TRUE;

    for (a = FirstArea;
	 a < &(ospf.area[ospf.acnt]);
	 a++) {
	set_rtr_sched(a);
    }
}


/*
 * For adding or deleting static entries
 */
void
static_net_action(mreq)
struct MON_HDR *mreq;
{
    OSPF_ASE_BLOCK eb;
    u_long32 addr = ntohl(mreq->p[1]);
    u_long32 mask = ntohl(mreq->p[2]);
    struct avl_node s;
    OROUTE *r;

    CLEAR_BUF(&s, sizeof(AVL));
    CLEAR_BUF(&eb, sizeof(OSPF_ASE_BLOCK));

    eb.count = 1;
    r = RT_FIND(addr);
    if (mreq->p[0]) {
	DBG_LOG("In Static add\n");

	if ((!r) || (!STATIC_INFO(r))) {
	    STATIC_INFO_ALLOC(&s);
	    STATIC_NH_NDX(&s) = 1;
	    r = RT_INSERT(addr,
			  mask,
			  &STATIC_NH_NDX(&s),
			  1,
			  PR_STATIC,
			  STATIC_INFO(&s));
	}

	if (!r)
	    return;

	STATIC_PREF(r) = STATIC_ROUTE_PREF;
	eb.ce[0].action = E_NEW;
	/* Will choose static... */
	choose_proto(r);
    } else {				/* Delete route */
	if (!r) {
	    if ((RT_DEST(r) != addr) ||
		(!STATIC_INFO(r)))
		return;			/* something is hosed */
	}
	eb.ce[0].action = E_DELETE;
    }
    eb.ce[0].proto 	= STATIC_OWNER;
    eb.ce[0].route 	= r;
    eb.ce[0].faddr 	= ntohl(mreq->p[3]);
    eb.ce[0].metric 	= ntohl(mreq->p[4]);
    eb.ce[0].age 	= ntohl(mreq->p[5]);
    eb.ce[0].etype 	= ntohl(mreq->p[6]);
    eb.ce[0].tag 	= ntohl(mreq->p[7]);
    ase_import(&eb);
    if ( (eb.ce[0].action == E_DELETE) && (STATIC_INFO(r)) )
    {
	ZAP(STATIC_INFO(r),0);
	STATIC_INFO(r) = (STATIC_RT_INFO *)0;
	choose_proto(r);
    }
}

/*
 * Set interface to administratively disabled or enabled
 */
void
toggle_intf(mreq)
struct MON_HDR *mreq;
{
    u_long32 addr = ntohl(mreq->p[0]);
    int i;

#ifdef DBG
    sprintf(_ospf_prt_buf, "In toggle_intf %s\n", lntoa(addr));
    DBG_LOG(_ospf_prt_buf);
#endif

    for (i = 0; i < ospf.nintf; i++) {
	if (addr == NDX_IP_ADDR(i)) {
	    if (NDX_DISABLE(i)) {
		NDX_DISABLE(i) = FALSE;
		ospf_ifup(i);
	    } else {
		NDX_DISABLE(i) = TRUE;
		ospf_ifdown(i);
	    }
	    return;
	}
    }
}

/*
 * Print the specific routing entry
 */
int
print_rtab_entry(r, parm1, parm2)
OROUTE *r;
int parm1, parm2;
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    if ((OSPF_IS_OWNER(r))) {
    	sprintf(_ospf_prt_buf, "%-13s %-15s %-7s %-3d %-3d %-4s %-13s %-11s %d\n",
	    lntoa(RT_DEST(r)),
	    lntoa(RT_MASK(r)),
	    (ORT_AREA(r)) ? lntoa(ORT_AREA(r)->area_id) : "0.0.0.0",
	    ORT_COST(r),
	    ORT_TYPE2COST(r),
	    paths[ORT_PTYPE(r)],
	    lntoa(RT_NH(r,0)),
	    lntoa(ORT_ADVRTR(r)),
	    RT_DIRECT(r));
    	MON_WRITE(_ospf_prt_buf);
    } else if (parm2) {
	sprintf(_ospf_prt_buf, "%-13s %-15s %s owner: %d\n\n",
		lntoa(RT_DEST(r)),
		lntoa(RT_MASK(r)),
		(RT_DELETE(r)) ? " (Deleted)" : " ",
		(RT_OWNER(r)));
	MON_WRITE(_ospf_prt_buf);
    }
    return(FLAG_NO_PROBLEM);
}

/*
 * Call the tree walker routine
 */
void
print_ospf_rtab()
{

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Nets:\n");
    MON_WRITE(_ospf_prt_buf);
    RT_WALK(print_rtab_entry, 0, TRUE);
}

/*
 * Print the asb rtr and ab rtr part of the ospf routing table
 */
void
printrtab()
{

    RTR_ROUTE *r;
    struct AREA *a;
    int flag = 0;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    /* MODIFIED 1/28/92 */
    sprintf(_ospf_prt_buf, "\nSPF algorithm run %d times since %26s\n",
	    RTAB_REV, s2c(&ospf.ospf_start_time));
    MON_WRITE(_ospf_prt_buf);
    sprintf(_ospf_prt_buf, "Dest          D_mask          Area    Cost E  Path Nexthop       AdvRtr      L\n");
    MON_WRITE(_ospf_prt_buf);
    sprintf(_ospf_prt_buf, "-------------------------------------------------------------------------------\n");
    MON_WRITE(_ospf_prt_buf);
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    /* As border rtrs */
    for (a = ospf.area; a < &ospf.area[ospf.acnt]; a++)
	for (r = a->asbrtab.ptr[NEXT]; r != RTR_ROUTENULL; r = RRT_NEXT(r)) {
	    if (!flag) {
		sprintf(_ospf_prt_buf, "AS Border Routes:\n");
		MON_WRITE(_ospf_prt_buf);
		flag++;
	    }
	    sprintf(_ospf_prt_buf, "%-13s %-15s %-7s %-3d     %-4s %-13s %-13s\n",
		    lntoa(RT_DEST(r)),
		    "--------",
		 (RRT_AREA(r)) ? lntoa(RRT_AREA(r)->area_id) : "0.0.0.0",
		    RRT_COST(r),
		    paths[RRT_PTYPE(r)],
		    lntoa(RRT_NH(r)),
		    lntoa(RRT_ADVRTR(r)));
	    MON_WRITE(_ospf_prt_buf);
	}
    flag = 0;
    /* Area border rtrs */
    for (a = ospf.area; a < &ospf.area[ospf.acnt]; a++)
	for (r = a->abrtab.ptr[NEXT]; r != RTR_ROUTENULL; r = RRT_NEXT(r)) {
	    if (!flag) {
		CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
		sprintf(_ospf_prt_buf, "Area Border Routes:\n");
		MON_WRITE(_ospf_prt_buf);
		flag++;
	    }
	    sprintf(_ospf_prt_buf, "%-13s %-15s %-7s %-3d     %-4s %-13s %-13s\n",
		    lntoa(RT_DEST(r)),
		    "--------",
		 (RRT_AREA(r)) ? lntoa(RRT_AREA(r)->area_id) : "0.0.0.0",
		    RRT_COST(r),
		    paths[RRT_PTYPE(r)],
		    lntoa(RRT_NH(r)),
		    lntoa(RRT_ADVRTR(r)));
	    MON_WRITE(_ospf_prt_buf);
	}
    flag = 0;

    /* Summary asb routes */
    for (r = sum_asb_rtab.ptr[NEXT]; r != RTR_ROUTENULL; r = RRT_NEXT(r)) {
	if (!flag) {
	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf, "Summary AS Border Routes:\n");
	    MON_WRITE(_ospf_prt_buf);
	    flag++;
	}
	sprintf(_ospf_prt_buf, "%-13s %-15s %-7s %-3d     %-4s %-13s %-13s\n",
		lntoa(RT_DEST(r)),
		lntoa(RT_MASK(r)),
		(RRT_AREA(r)) ? lntoa(RRT_AREA(r)->area_id) : "0.0.0.0",
		RRT_COST(r),
		paths[RRT_PTYPE(r)],
		lntoa(RRT_NH(r)),
		lntoa(RRT_ADVRTR(r)));
	MON_WRITE(_ospf_prt_buf);
    }
    print_ospf_rtab();
}

const char *tqtypes[] =
{"TQUnknown ",
 "TQHelloTimer",
 "TQAck       ",
 "TQRetrans   ",
 "TQLsaLock   ",
 "TQIntLsa    ",
 "TQSumLsa    ",
 "TQAseLsa    ",
 "TQIntLsdbAge",
 "TQSumLsdbAge",
 "TQAseLsdbAge"};

/*
 * Print active timer entries
 */
void
tq_dump(where)
char *where;
{
    struct OTIMER *t;
    long sec = 0;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    if (where) {
	sprintf(_ospf_prt_buf, "%s ", where);
	MON_WRITE(_ospf_prt_buf);
    }
    sprintf(_ospf_prt_buf, "Current Timerq:\n");
    MON_WRITE(_ospf_prt_buf);
    sprintf(_ospf_prt_buf, "Type         Minutes Seconds Area         Intf \n");
    MON_WRITE(_ospf_prt_buf);
    sprintf(_ospf_prt_buf, "-----------------------------------------------------------\n");
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    for (t = timerq.ptr[NEXT]; t != OTIMERNULL; t = t->ptr[NEXT]) {
	sec += SEC_SET(t);
	sprintf(_ospf_prt_buf, "%-12s  %6d  %6d %-12s %-12s\n",
		tqtypes[t->type],
		sec / 60,
		sec % 60,
		((t->type == TQLsaLock) ? lntoa( ((struct AREA *)t->tq_data)->area_id) : "No Area"),
		((t->type < TQLsaLock) ? lntoa(NDX_IP_ADDR(((struct INTF *)t->tq_data)->ifspfndx)) : "No Intf"));
	MON_WRITE(_ospf_prt_buf);
	CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    }
}



void
err_dump()
{
    int i;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    /* MODIFIED 1/28/92 */
    sprintf(_ospf_prt_buf, "ERRORS from: %26s\n", s2c(&ospf.ospf_start_time));
    MON_WRITE(_ospf_prt_buf);
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    for (i = 12; i < LASTLOG; i += 2) {
	sprintf(_ospf_prt_buf, "%4d: %-32s  %d: %-32s\n",
		cumlog[i], logtype[i],
		cumlog[i + 1], logtype[i + 1]);
	MON_WRITE(_ospf_prt_buf);
    }
}

void
io_dump()
{
    int i;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    /* MODIFIED 1/28/92 */
    sprintf(_ospf_prt_buf, "IO stats from: %26s\n", s2c(&ospf.ospf_start_time));
    MON_WRITE(_ospf_prt_buf);
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, ">> RECEIVED:\n");
    MON_WRITE(_ospf_prt_buf);
    for (i = 0; i < 12; i++) {
	sprintf(_ospf_prt_buf, "  %6d: %-40s\n", cumlog[i], logtype[i]);
	if (i == 6) {
	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf, ">> SENT:\n");
	    MON_WRITE(_ospf_prt_buf);
	} else
	    MON_WRITE(_ospf_prt_buf);
    }
}

int
monconnect(port, src)
u_short16 port;
u_long src;
{
    /* Create socket for returning monitor info */
    struct sockaddr_in ms;

    ms.sin_family = AF_INET;
    ms.sin_addr.s_addr = src;
    ms.sin_port = port;
    if ((__mon_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	__mon_fd = fileno(stdout);
	return (FALSE);
    }
    if (connect(__mon_fd, &ms, sizeof(struct sockaddr_in)) < 0) {
	shutdown(__mon_fd, 2);
	close(__mon_fd);
	__mon_fd = fileno(stdout);
	return (FALSE);
    }
    return (TRUE);
}

int
RxMon(mreq, intf, ipsrc, rtrid, olen, mc)
struct MON_HDR *mreq;
struct INTF *intf;
u_long32 ipsrc, rtrid;
u_short16 olen;
int mc;					/* multicast rx flag */
{
    OROUTE *r;

    /* for responding to monitor request if local is true */

    if (mreq->type != MREQUEST) {
	OSPF_LOG("Bad mrequest type");
	return (GOOD_RX);
    }
    if ((mreq->local) && (!TCP_MCONNECT(mreq->port, ipsrc))) {
	OSPF_LOG("Bad connect");
	return (GOOD_RX);
    }
    switch (mreq->req) {
	case 'a':
	    print_lsa(ntohl(mreq->p[0]),
		      ntohl(mreq->p[1]),
		      ntohl(mreq->p[2]),
		      ntohl(mreq->p[3]));
	    break;
	case 'b':
	    print_ospf_areas();
	    break;

	case 'c':
	    io_dump();
	    break;

	case 'd':
	    ospf_log_flags =
		(ospf_log_flags & OSPF_PKT_LOG) ?
			(ospf_log_flags & ~OSPF_PKT_LOG) :
			(ospf_log_flags | OSPF_PKT_LOG);
	    dump = ntohl(mreq->p[0]);
	    break;

	case 'e':
	    err_dump();
	    break;

	case 'f':
	    ospf_log_flags = ntohl(mreq->p[0]);
	    break;

	case 'g':
	    print_ospf_general();
	    break;

	case 'h':
	    print_host_table();
	    break;

	case 'k':
	    ospf_bye();

	case 'l':
	    lsdbdump(mreq->p[0]);
	    break;

	case 'm':
	    print_lsdb();
	    break;

	case 'n':			/* Add or delete static net */
	    static_net_action(mreq);
	    break;

	case 'o':
	    printrtab();
	    break;

	case 'q':
	    tq_dump(0);
	    break;

	case 's':
	    print_address_ranges();
	    break;

	case 't':
	    printree();
	    break;

	case 'x':
	    get_next_lsa( ntohl(mreq->p[0]),
		      	  ntohl(mreq->p[1]),
		      	  ntohl(mreq->p[2]),
		      	  ntohl(mreq->p[3]) );
	    break;

	case 'y':
	    if ((r = get_rtab(GET_NEXT,ntohl(mreq->p[0]))) != AVLNULL)
		print_rtab_entry(r, 0, 1);
	    break;

 	case 'z':
 	    test_mib();
 	    break;

	case 'A':
	    asb_toggle();
	    break;

	case 'D':
	    toggle_intf(mreq);
	    break;

	case 'I':
	    showifs();
	    break;

	case 'L':
#ifdef NOTDEF
	    lsa_log = ntohl(mreq->p[0]);
#endif
	    break;

	case 'N':
	    shownbrs(mreq->p[0]);
	    break;

	case 'O':
#ifdef NOTDEF
	    log_level = 100;
	    timer_log = 0;
	    lsa_log = 0;
#endif
	    break;
    }

    if (mreq->local) {
	shutdown(__mon_fd, 2);
	close(__mon_fd);
	__mon_fd = fileno(stdout);
    }
    return (GOOD_RX);
}

#endif				/* PROTO_OSPF */
