/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/* MODIFIED 2/13/92 - removed all references to blocksize and BLOCKSIZE */
/*
 * add db to list to be flooded by calling routine
 */
void
txadd(db, txq, len, age, area)
struct LSDB *db;
struct LSDB_LIST **txq;
int len;
u_short16 age;
struct AREA *area;
{
    struct LSDB_LIST *ll = LLNULL;

    /*
     * if there is a retrans list, free it
     */
    if (DB_RETRANS(db) != NLNULL)
	rem_db_retrans(db);
    LS_AGE(db) = 0;
    LL_ALLOC(ll);
    if (ll == LLNULL)
	return;
    ll->lsdb = db;
    ll->flood = FLOOD;
    fletch(DB_RTR(db), len);
    area->db_chksumsum += LS_CKS(db);
    LS_AGE(db) = age;
    /* 
     * put lsa on queue to be flooded 
     */
    EN_Q((*txq), ll);

    /* 
     * Increase count of self originated LSAs for MIBness 
     */
    ospf.orig_new_lsa++;
}

/*
 * 			INTRA-AREA BUILD LSAs
 */

/*
 * build ls updates - three cases where these are called
 *		   1) tq has fired
 *		   2) nbr change
 *		   3) received self orig with earlier seq number
 */
int
build_rtr_lsa(a, txq, force_flood)
struct AREA *a;
struct LSDB_LIST **txq;
int force_flood;			/* if true always flood */
{
    int foundlsa;			/* true if lsa was found when adding */
    int i, spfsched = 0;
    int addnet = 0;
    struct RTR_LA_HDR *r = (struct RTR_LA_HDR*) 0;
    struct RTR_LA_PIECES *lnk;
    struct OSPF_HOSTS *host;
    struct INTF *intf;
    struct LSDB *db;
    u_short16 len;
    u_long32 new_seq;
    time_t sec = ospf_get_time();	/* get time to check MaxAge */

    DBG_LOG("In build_rtr_lsa:");

    if (RTR_LSA_LOCK(a)) {
	/* schedule one to send */
	set_rtr_sched(a);
	return (FLAG_NO_PROBLEM);
    }

    /*
     * Enough mem for tx queues?
     */
    if (!QueueChk(LS_RTR,a)) {
	set_rtr_sched(a);
	return (FLAG_NO_PROBLEM);
    }

#ifdef DBG
    sprintf(_ospf_prt_buf,">>>>>>>SEC: %d\n",sec);
    DBG_LOG(_ospf_prt_buf);
#endif

    foundlsa = AddLSA(&db, a, MY_ID, MY_ID, 0, LS_RTR);


    /* Check seq number for max */
    if (foundlsa) {
	if ((LS_SEQ(db) == MaxSeqNum)) {
	    if (DB_SEQ_MAX(db) == TRUE && DB_RETRANS(db) != NLNULL) {
		/*
		 * Will reoriginate when the acks come home
		 */
		return (FLAG_NO_PROBLEM);
		/* If no nbrs >= exchange there will be no acks */
	    } else if (DB_SEQ_MAX(db) == FALSE && a->nbrEcnt) {
		/*
		 * Not already noted - flush from everyone's LSDB
		 */
		DB_SEQ_MAX(db) = TRUE;
		txadd(db, txq, LS_LEN(db), MaxAge, a);
		rtr_lsa_lockout(a);
		DB_TIME(db) = sec;
		return (FLAG_NO_PROBLEM);
	    }
	    /* have receive acks */
	}
	DB_SEQ_MAX(db) = FALSE;
	new_seq = NEXTNSEQ(LS_SEQ(db));
    } else {
        /*
         * Enough mem for DB?
         */
        if (db == LSDBNULL) {
	    set_rtr_sched(a);
	    return(FLAG_NO_PROBLEM);
        }
	new_seq = FirstSeq;
	spfsched = RTRSCHED;
    }

    /*
     * Allocate enough for all links
     */
    len = MY_RTR_ADV_SIZE(a);
    RTR_HDR_ALLOC(r, len);
    if (!r) {
	set_rtr_sched(a);
	return(FLAG_NO_PROBLEM);
    }

    r->ls_hdr.ls_type = LS_RTR;
    r->ls_hdr.ls_id = MY_ID;
    r->ls_hdr.adv_rtr = MY_ID;
    if (IAmBorderRtr)
	r->E_B = bit_B;
    if (IAmASBorderRtr)
	r->E_B |= bit_E;
    r->E_B = htons(r->E_B);
    len = RTR_LA_HDR_SIZE;
    lnk = &(r->link);

    for (intf = a->intf; intf < &(a->intf[a->ifcnt]); intf++) {
	if (intf->state == IDOWN)
	    continue;
	addnet = 0;

	switch (intf->state) {

	    case IPOINT_TO_POINT:

		if (intf->nbr.state == NFULL) {
		    r->lnk_cnt++;
		    /* len += RTR_LA_METRIC_SIZE - add metric lengths */
		    len += RTR_LA_PIECES_SIZE;
		    /* add for TOS here */
		    lnk->con_type = RTR_IF_TYPE_RTR;
		    lnk->lnk_id = intf->nbr.nbr_id;
		    lnk->lnk_data = NDX_IP_ADDR(intf->ifspfndx);
		    lnk->metric_cnt = 0;
		    lnk->tos0_metric = htons(intf->cost);
		    /* add metric lengths here if necessary */
		    lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						     RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
		}

		/*
		 * Add host lnk if ip address is known
		 */
		if ( (NDX_IP_ADDR(intf->ifspfndx)) &&
		     (intf->nbr.nbrip_addr) ) {
		    r->lnk_cnt++;
		    len += RTR_LA_PIECES_SIZE;
		    /* add for TOS here */
		    lnk->con_type = RTR_IF_TYPE_HOST;
		    lnk->lnk_data = HOST_NET_MASK;
		    lnk->lnk_id = intf->nbr.nbrip_addr;
		    lnk->metric_cnt = 0;
		    lnk->tos0_metric = htons(intf->cost);
		    lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						     RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
		}
		break;

	    case ILOOPBACK:
		/*
		 * Need ip address for this part...
		 */
		if (NDX_IP_ADDR(intf->ifspfndx)) {
		    r->lnk_cnt++;
		    len += RTR_LA_PIECES_SIZE;
		    /* add for TOS here */
		    lnk->con_type = RTR_IF_TYPE_HOST;
		    lnk->lnk_data = HOST_NET_MASK;
		    lnk->lnk_id = NDX_IP_ADDR(intf->ifspfndx);
		    lnk->metric_cnt = 0;
		    lnk->tos0_metric = 0;
		    lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						     RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
		}
		break;

	    case IDr:			/* have DR selected cases */
	    case IBACKUP:
	    case IDrOTHER:
#ifdef DBG
		sprintf(_ospf_prt_buf, "Checking if %s",
			lntoa(NDX_IP_ADDR(intf->ifspfndx)));
		DBG_LOG(_ospf_prt_buf);
#endif
		/*
     	     	 * If there are full nbrs and we are adjacent or are DR
	         * it is OK to add a network lnk
	         */
		if (intf->nbrFcnt) {
		    if ((intf->state == IDr) ||
			((intf->dr) && (intf->dr->state == NFULL)))
			addnet++;
		}
#ifdef DBG
		sprintf(_ospf_prt_buf, "AddNet %d fullcnt %d",
			addnet, intf->nbrFcnt);
		DBG_LOG(_ospf_prt_buf);
#endif

		if (addnet) {
		    r->lnk_cnt++;
		    len += RTR_LA_PIECES_SIZE;
		    /* add for TOS here */
		    lnk->con_type = RTR_IF_TYPE_TRANS_NET;
		    lnk->lnk_id = intf->dr->nbrip_addr;
		    lnk->lnk_data = NDX_IP_ADDR(intf->ifspfndx);
		    lnk->metric_cnt = 0;
		    lnk->tos0_metric = htons(intf->cost);
		    lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						     RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
		    break;
		}
		/*
	         * else fall through
	         */
	    case IWAITING:
		/*
	         * still determining DR
	         */
		r->lnk_cnt++;
		len += RTR_LA_PIECES_SIZE;
		/* add for TOS here */
		lnk->con_type = RTR_IF_TYPE_STUB_NET;
		lnk->lnk_data = NDX_IP_MASK(intf->ifspfndx);
		lnk->lnk_id = INTF_NETNUM(intf);
		lnk->metric_cnt = 0;
		lnk->tos0_metric = htons(intf->cost);
		lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						 RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
		break;
	}
    }

    /*
     * add virtual links
     */
    if (a == ospf.area && ospf.vcnt) {
	for (i = 0; i < ospf.vcnt; i++)
	    if ((ospf.vl[i].state == IPOINT_TO_POINT) &&
		(ospf.vl[i].nbr.state == NFULL)) {
		r->lnk_cnt++;
		len += RTR_LA_PIECES_SIZE;
		/* add for TOS here */
		lnk->con_type = RTR_IF_TYPE_VIRTUAL;
		lnk->lnk_id = ospf.vl[i].nbr.nbr_id;
		lnk->lnk_data = NDX_IP_ADDR(intf->ifspfndx);
		lnk->metric_cnt = 0;
		lnk->tos0_metric = htons(ospf.vl[i].cost);
		lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						 RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
	    }
    }
    /*
     * add host links
     */
    for (host = a->hosts.ptr[NEXT]; host != HOSTSNULL; host = host->ptr[NEXT]) {
	r->lnk_cnt++;
	len += RTR_LA_PIECES_SIZE;
	/* add for TOS here */
	lnk->con_type = RTR_IF_TYPE_HOST;
	lnk->lnk_data = HOST_NET_MASK;
	lnk->lnk_id = host->if_addr;
	lnk->metric_cnt = 0;
	lnk->tos0_metric = host->cost;
	lnk = (struct RTR_LA_PIECES *) ((long) lnk +
					 RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE));
    }

    r->ls_hdr.length = htons(len);

    if (foundlsa) {
	/*
	 * compare to see if it's the same, if not rerun spf
	 */
	if ((r->ls_hdr.length != LS_LEN(db)) ||
	    (r->E_B != DB_RTR(db)->E_B) ||
	    (LS_AGE(db) == MaxAge) ||
	    (r->lnk_cnt != ntohs(DB_RTR(db)->lnk_cnt)) ||
	    RTR_LINK_CMP(r, DB_RTR(db),
			 (ntohs(r->ls_hdr.length) - RTR_LA_HDR_SIZE)))
	    spfsched = RTRSCHED;
	if (DB_FREEME(db) == TRUE) {
	    DB_FREEME(db) = FALSE;
	    DEL_DBQ(db);		/* remove from db_free_list */
	}
    }

    /*
     * if found or changed, replace with new one and flood
     */
    if (force_flood ||
	spfsched ||
	new_seq == FirstSeq ||
	ospf.nbrEcnt != ospf.nbrFcnt) 
    {
	if (foundlsa)
	    a->db_chksumsum -= LS_CKS(db);
	DBG_LOG("RtrLsa in forceflood");
	if (DB_RTR(db))
	    DBADV_FREE(db, LS_RTR);
	DB_RTR(db) = r;
	LS_SEQ(db) = new_seq;
	RTR_LSA_LOG(a->area_id,
		    r->lnk_cnt,
		    ntohl(r->ls_hdr.ls_seq),
		    ospf_get_ctime());
	r->lnk_cnt = htons(r->lnk_cnt);
	/*
	 * lock out new instansiation for MinLSInterval
	 */
	rtr_lsa_lockout(a);
	DB_TIME(db) = sec;
	/*
	 * put lsa on queue to be flooded
	 */
	txadd(db, txq, len, 0, a);
    } else
	ADV_FREE(r, OMEM_RTR);

    /*
     * let calling routine know to rerun spf or not
     */
    return (spfsched);
}


/*
 * build net link state advertisement - this rtr is DR
 */
int
build_net_lsa(intf, txq, force_flood)
struct INTF *intf;
struct LSDB_LIST **txq;
int force_flood;			/* if true always flood */
{
    int foundlsa;			/* true if lsa was found when adding */
    int spfsched = 0;
    struct AREA *a = AREA_PTR(intf);
    struct NET_LA_HDR *nh;
    struct NET_LA_PIECES *att_rtr;
    struct NBR *nbr;
    struct LSDB *db;
    time_t sec = ospf_get_time();	/* get time to check MaxAge */
    u_long32 new_seq;
    u_short16 len;

    if (intf->state != IDr)
	return (FALSE);

    DBG_LOG("In build_net_lsa:");
    if (NET_LSA_LOCK(intf)) {
	/* schedule one to send */
	set_net_sched(intf);
	return (FLAG_NO_PROBLEM);
    }
    /*
     * Are we adjacent to any neighbors?
     */
    if ((!intf->nbrFcnt))
	return (FALSE);

    if (!QueueChk(LS_NET,a)) {
	set_net_sched(intf);
	return (FLAG_NO_PROBLEM);
    }

    foundlsa =
	AddLSA(&db, a, NDX_IP_ADDR(intf->ifspfndx), MY_ID, 0, LS_NET);
    /*
     * Check seq number for max
     */
    if (foundlsa) {
	if (DB_FREEME(db)) {
	    DB_FREEME(db) = FALSE;
	    DEL_DBQ(db);
	}
	if ((LS_SEQ(db) == MaxSeqNum)) {
	    if (DB_SEQ_MAX(db) == TRUE && DB_RETRANS(db) != NLNULL) {
		/* Will re originate when the acks come home */
		return (FALSE);
		/* If no nbrs >= exchange there will be no acks */
	    } else if (DB_SEQ_MAX(db) == FALSE && a->nbrEcnt) {
		/* Not already noted - flush from everyone's LSDB */
		DB_SEQ_MAX(db) = TRUE;
		txadd(db, txq, LS_LEN(db), MaxAge, a);
		net_lsa_lockout(intf);
		DB_TIME(db) = sec;
		return (FALSE);
	    }
	}
	/*
         * have received acks
         */
	DB_SEQ_MAX(db) = FALSE;
	new_seq = NEXTNSEQ(LS_SEQ(db));
    } else {
	if (!db) {
	    set_net_sched(intf);
	    return (FLAG_NO_PROBLEM);
	}
	new_seq = FirstSeq;
	spfsched = NETSCHED;
	DBG_LOG("   Did not find lsa in LSDB");
    }


    /*
     * Allocate enought for all links
     */
    len = MY_NET_ADV_SIZE(intf);
    NET_HDR_ALLOC(nh, len);
    if (!nh) {
    	set_net_sched(intf);
	if (!foundlsa) {
	    /* MODIFIED 1/17 */
	    ospf.db_cnt--;
	    a->db_cnts[LS_NET]--;
    	    a->db_int_cnt--;
	    db_free(db);
	}
	return (FLAG_NO_PROBLEM);
    }
    len = NET_LA_HDR_SIZE + NET_LA_PIECES_SIZE;	/* one for this rtr */
    nh->ls_hdr.ls_type = LS_NET;
    nh->ls_hdr.ls_id = NDX_IP_ADDR(intf->ifspfndx);
    nh->ls_hdr.adv_rtr = MY_ID;
    nh->net_mask = NDX_IP_MASK(intf->ifspfndx);
    att_rtr = &(nh->att_rtr);
    /*
     * set the first one to this rtr
     */
    att_rtr->lnk_id = MY_ID;
    att_rtr++;
    for (nbr = intf->nbr.next; nbr != NBRNULL; nbr = nbr->next) {
	if (nbr->state == NFULL) {
	    att_rtr->lnk_id = nbr->nbr_id;
	    len += NET_LA_PIECES_SIZE;
	    att_rtr++;
	}
    }
    nh->ls_hdr.length = htons(len);
    if (foundlsa) {
	/*
  	 * compare to see if it's the same, if not rerun spf
	 */
	if ((nh->ls_hdr.length != LS_LEN(db)) ||
	    (LS_AGE(db) == MaxAge) ||
	    NET_ATTRTR_CMP(nh, DB_NET(db), (len - NET_LA_HDR_SIZE)))
	    spfsched = NETSCHED;
	if (DB_FREEME(db) == TRUE) {
	    DB_FREEME(db) = FALSE;
	    DEL_DBQ(db);		/* remove from db_free_list */
	}
    }
    /*
     * if !found, not the same or force flood, replace with new one
     */
    if (force_flood ||
	spfsched ||
	new_seq == FirstSeq ||
	ospf.nbrEcnt != ospf.nbrFcnt) {
	if (foundlsa)
	    a->db_chksumsum -= LS_CKS(db);
	if (DB_NET(db))
	    DBADV_FREE(db, LS_NET);
	DB_NET(db) = nh;
	LS_SEQ(db) = new_seq;
	/*
	 * lock out new instansiation for MinLSInterval
	 */
	net_lsa_lockout(intf);
	DB_TIME(db) = sec;
	txadd(db, txq, len, 0, a);
	NET_LSA_LOG(a->area_id,
		    lntoa(INTF_NETNUM(intf)),
		    ntohl(nh->ls_hdr.ls_seq),
		    ospf_get_ctime());
    } else
	ADV_FREE(nh, OMEM_NETHDR);

    intf->build_net = FALSE;		/* A done deal */
    /* rerun spf? */
    return (spfsched);
}


/*
 * 			INTER-AREA BUILD-LSAs
 */

/*
 * Update seq number
 * - if current seq number == MaxSeqNum set to max age and add to queue
 */
void
sum_next_seq(db, a, metric, sec)
struct LSDB *db;
struct AREA *a;
u_long32 metric;
time_t sec;
{

    /* MODIFIED 5/21/92 */
    u_short16 age = (metric == ntohl(SUMLSInfinity)) ? MaxAge : 0;

    DB_SUM(db)->tos0.tos_metric = metric;
    if (LS_SEQ(db) == MaxSeqNum) {
	if (DB_SEQ_MAX(db) == TRUE && DB_RETRANS(db) != NLNULL)
	    return;
	if ((DB_SEQ_MAX(db) == FALSE) && (a->nbrEcnt)) {
	    /* Not noted - flush from everyone's LSDB */
	    DB_SEQ_MAX(db) = TRUE;
	    age = MaxAge;
	} else {
	    DB_SEQ_MAX(db) = FALSE;
	    LS_SEQ(db) = NEXTNSEQ(LS_SEQ(db));
	}
    } else {
	LS_SEQ(db) = NEXTNSEQ(LS_SEQ(db));
    }
    DB_TIME(db) = sec;
    a->db_chksumsum -= LS_CKS(db);
    txadd(db, &(a->txq), SUM_LA_HDR_SIZE, age, a);

}

/*
 * Build network summary link-state advertisements
 *    called by spf - just build the ones that have changed
 *    - Loop through all area and store in dst's lsdb where dst != orig area
 *    - Put on dst area's->sumnetlst
 */
int
build_sum_net(area)
struct AREA *area;
{
    int foundlsa;			/* true if lsa was found when adding */
    struct AREA *dst;			/* injecting from a - into area dst  */
    struct LSDB *db;
    struct SUM_LA_HDR *s;
    struct NET_RANGE *nr;
    time_t sec;

    sec = ospf_get_time();		/* get time to check MaxAge */

    BUILD_SUM_LOG(area->area_id, ospf_get_ctime());

    for (nr = area->nr.ptr[NEXT]; nr != NRNULL; nr = nr->ptr[NEXT])     {
	if (!QueueChk(QBuildSum,0))
	    return(FLAG_NO_BUFS);
	/* is now unreachable */
	if (nr->cost == SUMLSInfinity) {
	    for (dst = FirstArea;
		 dst < &(ospf.area[ospf.acnt]);
		 dst++) {		/* Loop through all areas */
		if (area == dst)
		    continue;
		db = FindLSA(dst, nr->net, MY_ID, LS_SUM_NET);
		if (db == LSDBNULL)
		    continue;		/* still down or unreach */
		else if (DB_WHERE(db) != ON_SUM_INFINITY) {
		    /* has become unreachable */
		    /* MODIFIED 5/21/92 */
                    DB_WHERE(db) = ON_SUM_INFINITY;
                    DEL_DBQ(db);
                    DB_FREEME(db) = TRUE;
                    ADD_DBQ(&ospf.db_free_list, db);
                    /* MODIFIED 5/1/92 */
                    DELETE_DISCARD_ROUTE(nr);
                    /* add to txq */
                    sum_next_seq(db, dst, htonl(SUMLSInfinity), sec);

		    SUM_TYPE_LOG(dst->area_id,
				 "net",
				 lntoa(nr->net),
				 ntohl(LS_SEQ(db)),
				 BIG_METRIC(db));

		}
	    }
	    continue;
	}

	/* 
	 * is not unreachable 
	 */
	for (dst = FirstArea;
	     dst < &(ospf.area[ospf.acnt]);
	     dst++) {
	    if (area == dst) {
		/* 
	 	 * Flush this asb route from this area if it existed 
		 */
		db = FindLSA(dst, nr->net, MY_ID, LS_SUM_NET);
		if ((db) && (DB_WHERE(db) == ON_SUMNET_LIST)) {
                    /* MODIFIED 5/21/92 */
                    DB_WHERE(db) = ON_SUM_INFINITY;
                    DEL_DBQ(db);
                    DB_FREEME(db) = TRUE;
                    ADD_DBQ(&ospf.db_free_list, db);
		    DELETE_DISCARD_ROUTE(nr);
		    sum_next_seq(db, dst, htonl(SUMLSInfinity), sec);
		}
		continue;
	    }
	    foundlsa =
		AddLSA(&db, dst, nr->net, MY_ID, 0, LS_SUM_NET);
	    if (!foundlsa) {		/* net has come up */
		if (!db)
		    return(FLAG_NO_BUFS);
		SUM_HDR_ALLOC(s, SUM_LA_HDR_SIZE);
		if ( (!s) || (ADD_DISCARD_ROUTE(nr) == FLAG_NO_BUFS) ) {
		    /* MODIFIED 1/17 */
		    ospf.db_cnt--;
		    dst->db_cnts[LS_SUM_NET]--;
		    dst->db_int_cnt--;
		    db_free(db);
		    return(FLAG_NO_BUFS);
		}
		s->ls_hdr.ls_type = LS_SUM_NET;
		s->ls_hdr.ls_id = nr->net;
		s->ls_hdr.adv_rtr = MY_ID;
		s->ls_hdr.ls_seq = FirstSeq;
		s->ls_hdr.length = htons(SUM_LA_HDR_SIZE);
		s->net_mask = nr->mask;
		s->tos0.tos_metric = htonl(nr->cost);
		DB_SUM(db) = s;
		/* 
		 * add to this areas net sum list 
		 */
		DB_WHERE(db) = ON_SUMNET_LIST;
		ADD_DBQ(&dst->sumnetlst, db);
		DB_TIME(db) = sec;
		/* add to txq */
		txadd(db, &(dst->txq), SUM_LA_HDR_SIZE, 0, dst);
	    } else if (DB_WHERE(db) == ON_SUM_INFINITY) {
		/* is now reachable - let the world know */
		if (ADD_DISCARD_ROUTE(nr) == FLAG_NO_BUFS)
		    return(FLAG_NO_BUFS);
		sum_next_seq(db, dst, htonl(nr->cost), sec);
		if (DB_FREEME(db) == TRUE) {
		    DB_FREEME(db) = FALSE;
		    DEL_DBQ(db);	/* remove from db_free_list */
		}
		/* 
		 * add to this area's net sum list 
		 */
		DB_WHERE(db) = ON_SUMNET_LIST;
		ADD_DBQ(&dst->sumnetlst, db);
	    } else {
		/* 
		 * had in lsdb and on netlst - if cost has changed send 
		 */
#ifdef DBG
		sprintf(_ospf_prt_buf,"SUM NET resend metric %d (%d) nr metric %d (%d)",
			ntohl(DB_SUM(db)->tos0.tos_metric),
			(DB_SUM(db)->tos0.tos_metric),
			(nr->cost),
			htonl(nr->cost));
		DBG_LOG(_ospf_prt_buf);
#endif
		if (DB_SUM(db)->tos0.tos_metric != htonl(nr->cost)) {
		    DBG_LOG("Here in resend");
		    sum_next_seq(db, dst, htonl(nr->cost), sec);
		}			/* else no changes, continue */
	    }
	    SUM_TYPE_LOG(dst->area_id,
			 "net",
			 lntoa(nr->net),
			 ntohl(LS_SEQ(db)),
			 (BIG_METRIC(db)));
	}
    }
    return(FLAG_NO_PROBLEM);
}


/*
 * Build autonomous system border rtr summary link-state advertisements
 *    from area into dest
 *    - r is passed from spf()
 *    - Store all sum links in dst area's lsdb
 *    - Put on dst area's asb list for so it is easy to do periodic update
 *    - Will also add to this area but not transmit
 */
int
build_sum_asb(area, r, from_area)
struct AREA *area, *from_area;		/* area building from */
RTR_ROUTE *r;
{
    int foundlsa;			/* true if lsa was found when adding */
    struct AREA *dst;			/* injecting into area */
    struct LSDB *db;
    struct SUM_LA_HDR *s;
    RTR_ROUTE *rr;
    time_t sec = ospf_get_time();	/* get time to check MaxAge */


    if (!QueueChk(QBuildSum,0))
	return(FLAG_NO_BUFS);

    BUILD_SUM_LOG(area->area_id, ospf_get_ctime());

    /*
     * first check known reachable ASBRs
     */
    for (dst = ospf.area;
	 dst < &(ospf.area[ospf.acnt]);
	 dst++) {
	/*
         * Don't use sum asbs to for flooding into backbone
         */
	if ((RRT_PTYPE(r) == LS_SUM_ASB) && (dst == ospf.area))
	    continue;

	rr = rtr_findroute( dst,
			    RRT_DEST(r),
			    DTYPE_ASBR,
			    PTYPE_INTRA );
	/*
         * If there is a currently valid intra-area route in dst
         * or the route passed in isn't valid, nuke the one in dst
         */
	if ( (rr != RTR_ROUTENULL) &&
	     ( ((RRT_PTYPE(r) == LS_RTR) &&
	        ( (dst != from_area) ||
	          ((dst == from_area) && (RRT_REV(rr) == RTAB_REV)) ) ) ||
	     (RRT_PTYPE(r) == LS_SUM_ASB)) ) 
	{
	    /*
     	     * If we injected one in the past, free it
	     */
	    db = FindLSA(dst, RRT_DEST(r), MY_ID, LS_SUM_ASB);
#ifdef DBG
	    sprintf(_ospf_prt_buf,"In Continue for area %s",
		lntoa(dst->area_id));
	    DBG_LOG(_ospf_prt_buf);
#endif
	    if (db != LSDBNULL) {
		/*
		 * Flush this asb route from this area if it existed
		 */
		if ((db) && (DB_WHERE(db) == ON_SUMASB_LIST)) {
                    /* MODIFIED 5/21/92 */
                    DB_WHERE(db) = ON_SUM_INFINITY;
                    DEL_DBQ(db);
                    DB_FREEME(db) = TRUE;
                    ADD_DBQ(&ospf.db_free_list, db);
                    sum_next_seq(db, dst, htonl(SUMLSInfinity), sec);
		}
	    }
	    continue;
	}
#ifdef DBG
	sprintf(_ospf_prt_buf, "Beyond contunue for area %s",
		lntoa(dst->area_id));
	DBG_LOG(_ospf_prt_buf);
#endif
	/*
         * inter area routes have been added in spf by build_inter
         */
	foundlsa = AddLSA(&db, dst, RRT_DEST(r), MY_ID, 0, LS_SUM_ASB);

	/*
         * the ones on the routing table are reachable
         */
	if (!foundlsa) {
	    if (!db)
	    	return(FLAG_NO_BUFS);
	    /*
	     * If not valid route, ignore
	     */
	    if ((RRT_REV(r) != RTAB_REV)) {
	    	/* MODIFIED 1/17 */
	    	ospf.db_cnt--;
		dst->db_cnts[LS_SUM_ASB]--;
		dst->db_int_cnt--;
		db_free(db);
		continue;
	    }
	    /*
	     * new asbr
	     */
	    SUM_HDR_ALLOC(s, SUM_LA_HDR_SIZE);
	    if (!s)
	    {
	    	/* MODIFIED 1/17 */
	    	ospf.db_cnt--;
		dst->db_cnts[LS_SUM_ASB]--;
		dst->db_int_cnt--;
		db_free(db);
		return(FLAG_NO_BUFS);
	    }
	    s->ls_hdr.ls_type = LS_SUM_ASB;
	    s->ls_hdr.ls_id = RRT_DEST(r);
	    s->ls_hdr.adv_rtr = MY_ID;
	    s->ls_hdr.ls_seq = FirstSeq;
	    s->ls_hdr.length = htons(SUM_LA_HDR_SIZE);
	    s->tos0.tos_metric = htonl(RRT_COST(r));
	    DB_SUM(db) = s;
	    ADD_DBQ(&dst->asblst, db);
	    DB_WHERE(db) = ON_SUMASB_LIST;
	    DB_TIME(db) = sec;
	    txadd(db, &(dst->txq), SUM_LA_HDR_SIZE, 0, dst);
	} else if (DB_WHERE(db) == ON_SUMASB_LIST) {
	    /*
	     * may have changed
	     */
	    /* MODIFIED 5/21/92 */
	    DB_FREEME(db) = FALSE;
	    if (RRT_REV(r) != RTAB_REV) {
		/*
	         * no longer valid route
	         */
	    	/* MODIFIED 5/21/92 */
		DB_WHERE(db) = ON_SUM_INFINITY;
                DEL_DBQ(db);
                DB_FREEME(db) = TRUE;
                ADD_DBQ(&ospf.db_free_list, db);
		sum_next_seq(db, dst, htonl(SUMLSInfinity), sec);
	    } else if (DB_SUM(db)->tos0.tos_metric != htonl(RRT_COST(r))) {
		sum_next_seq(db, dst, htonl(RRT_COST(r)), sec);
	    }
	} else if (DB_WHERE(db) == ON_SUM_INFINITY) {
	    /*
	     * If not valid route, ignore
	     */
	    if ((RRT_REV(r) != RTAB_REV)) {
		continue;
	    }
	    /*
	     * was unreachable, now reachable
	     */
	    /* MODIFIED 5/21/92 */
	    DB_FREEME(db) = FALSE;
	    DEL_DBQ(db);		/* remove from db_free_list */
	    DB_WHERE(db) = ON_SUMASB_LIST;
	    ADD_DBQ(&dst->asblst, db);
	    sum_next_seq(db, dst, htonl(RRT_COST(r)), sec);
	}
	/*
         * ones currently on infinity list will just age out
         */
	SUM_TYPE_LOG(dst->area_id,
		     "asb",
		     lntoa(RRT_DEST(r)),
		     ntohl(LS_SEQ(db)),
		     BIG_METRIC(db));
    }
    return(FLAG_NO_PROBLEM);
}

/*
 * build_sum() builds all inter area routes
 * - changes have been sent when changes have been seen
 *    as a result of running spf or receiving a new sum pkt
 * - this routine just updates the sequence numbers and sends out new sum
 *    pkts called by tq_SumLsa
 */
int
build_sum()
{
    struct LSDB *db;
    struct AREA *a;
    char *time;
    time_t sec;
    int	ret_flag = FLAG_NO_PROBLEM;

    sec = ospf_get_time();		/* get time to check MaxAge */
    time = ospf_get_ctime();
    for (a = ospf.area; a < &ospf.area[ospf.acnt]; a++) {
	BUILD_SUM_LOG(a->area_id, time);
	/* new sequence number only */

	for (db = DB_PTR(&a->asblst)[NEXT];
	     db != LSDBNULL;
	     db = DB_PTR(db)[NEXT]) 
	{
	    if ((sec - DB_TIME(db)) < MinLSInterval)
		continue;
	    if (!QueueChk(LS_SUM_ASB,a)) {
		ret_flag = FLAG_NO_BUFS;
		goto shebangee_send;
	    }
	    sum_next_seq(db, a, DB_SUM(db)->tos0.tos_metric, sec);
	    SUM_TYPE_LOG(a->area_id,
			 "asb",
			 lntoa(LS_ID(db)),
			 ntohl(LS_SEQ(db)),
			 BIG_METRIC(db));
	}

	for (db = DB_PTR(&a->sumnetlst)[NEXT];
	     db != LSDBNULL;
	     db = DB_PTR(db)[NEXT])
	{
	    if ((sec - DB_TIME(db)) < MinLSInterval)
		continue;
	    if (!QueueChk(LS_SUM_NET,a)) {
		ret_flag = FLAG_NO_BUFS;
		goto shebangee_send;
	    }
	    sum_next_seq(db, a, DB_SUM(db)->tos0.tos_metric, sec);
	    SUM_TYPE_LOG(a->area_id,
			 "net",
			 lntoa(LS_ID(db)),
			 ntohl(LS_SEQ(db)),
			 BIG_METRIC(db));
	}

	/* 
	 * Update stub area default route 
	 */
	if (a->ext_option == EXT_OPT_STUB)
	{
	    db = DB_PTR(&a->dflt_sum)[NEXT];
	    if ((sec - DB_TIME(db)) >= MinLSInterval) {
	    	if (!QueueChk(LS_SUM_NET,a)) {
		    ret_flag = FLAG_NO_BUFS;
		    goto shebangee_send;
	    	}
	    	sum_next_seq(db, a, a->dflt_metric, sec);
	    	SUM_TYPE_LOG(a->area_id,
			 "net",
			 lntoa(LS_ID(db)),
			 ntohl(LS_SEQ(db)),
			 BIG_METRIC(db));
	    }
	}

	/* 
	 * Inter area routes determined from routing table 
	 */
	for (db = DB_PTR(&a->interlst)[NEXT];
	     db != LSDBNULL;
	     db = DB_PTR(db)[NEXT]) 
	{
	    if ((sec - DB_TIME(db)) < MinLSInterval)
		continue;
	    if (!QueueChk(LS_SUM_NET,a)) {
		ret_flag = FLAG_NO_BUFS;
		goto shebangee_send;
	    }
	    sum_next_seq(db, a, DB_SUM(db)->tos0.tos_metric, sec);
	    SUM_TYPE_LOG(a->area_id,
			 "asb",
			 lntoa(LS_ID(db)),
			 ntohl(LS_SEQ(db)),
			 BIG_METRIC(db));
	}

	/* 
	 * Send the whole shebangee 
 	 */
	shebangee_send:

	if (a->txq != LLNULL) {
	    self_orig_area_flood(a, a->txq, LS_SUM_NET);
	    ospf_freeq(&(a->txq), OMEM_LL);
	}
	if (ret_flag)
	    return(FLAG_NO_BUFS);
    }

    /* If they make it on the retrans list, that's good enough */
    return (FLAG_NO_PROBLEM);
}

/*
 * Build inter-area route
 *   - db is an inter-area route belonging to the backbone area,
 *	but not originated by this router
 *   - add to every area except backbone area
 *   - called by spf and rxlinkup
 */
int
build_inter(v, area, what)
struct LSDB *v;
struct AREA *area;			/* originating area */
int what;
{
    struct LSDB *db;
    struct AREA *dst;			/* inject into this area */
    struct SUM_LA_HDR *s;
    int foundlsa = 0;
    time_t sec;
    u_long32 metric = SUMLSInfinity;
    int	ret_flag = FLAG_NO_PROBLEM;
    u_short16 age = 0;

    if (!QueueChk(QBuildSum,0))
	return(FLAG_NO_BUFS);
    sec = ospf_get_time();		/* get time to check MaxAge */
    BUILD_INTER_LOG(ospf_get_ctime());
    /* Backbone route exists */
    for (dst = FirstArea; dst < &(ospf.area[ospf.acnt]); dst++) {

	if (area == dst) {
	    /* Flush this route from this area if it existed */
	    db = FindLSA(dst, DB_NETNUM(v), MY_ID, LS_SUM_NET);
	    if ((db) && (DB_WHERE(db) == ON_SUMNET_LIST)) {
		/* MODIFIED 5/21/92 */
		DB_WHERE(db) = ON_SUM_INFINITY;
		DEL_DBQ(db);		/* remove from db_free_list */
		DB_FREEME(db) = TRUE;
		ADD_DBQ(&ospf.db_free_list, db);
		sum_next_seq(db, dst, htonl(SUMLSInfinity), sec);
	    }
	    continue;
	}

	foundlsa = AddLSA(&db, dst, DB_NETNUM(v), MY_ID, 0, LS_SUM_NET);
	if (!foundlsa) {
	    if (db == LSDBNULL)
		return(FLAG_NO_BUFS);
	    SUM_HDR_ALLOC(s, SUM_LA_HDR_SIZE);
	    if (!s) {
	    	/* MODIFIED 1/17 */
	    	ospf.db_cnt--;
    		dst->db_cnts[LS_SUM_NET]--;
		dst->db_int_cnt--;
		db_free(db);
		return(FLAG_NO_BUFS);
	    }
	    s->ls_hdr.ls_type = LS_SUM_NET;
	    s->ls_hdr.ls_id = DB_NETNUM(v);
	    s->ls_hdr.adv_rtr = MY_ID;
	    s->ls_hdr.ls_seq = FirstSeq;
	    s->ls_hdr.length = htons(SUM_LA_HDR_SIZE);
	    s->net_mask = DB_MASK(v);
	    DB_SUM(db) = s;
	    /* MODIFIED 12/17 */
	    if (DB_ROUTE(v) != ROUTENULL && what != E_DELETE) {
		s->tos0.tos_metric = htonl(ORT_COST(DB_ROUTE(v)));
		ADD_DBQ(&dst->interlst, db);
		DB_WHERE(db) = ON_INTER_LIST;
		/* MODIFIED 5/21/92 */
		age = 0;
	    } else {
		/* MODIFIED 5/21/92 */
		DB_WHERE(db) = ON_SUM_INFINITY;
		DB_FREEME(db) = TRUE;
		ADD_DBQ(&ospf.db_free_list, db);
		s->tos0.tos_metric = htonl(SUMLSInfinity);
		age = MaxAge;
	    }
	    DB_TIME(db) = sec;
	    txadd(db, &(dst->txq), SUM_LA_HDR_SIZE, age, dst);
	} else {			/* had one */
            /*
             * set db->where and put on the inter list if needed
             */
            if (what == E_DELETE) {
                metric = htonl(SUMLSInfinity);
                /* MODIFIED 5/21/92 */
                DEL_DBQ(db);
                DB_FREEME(db) = TRUE;
                ADD_DBQ(&ospf.db_free_list, db);
                DB_WHERE(db) = ON_SUM_INFINITY;
            } else if (DB_ROUTE(v)) {
                /* MODIFIED 5/21/92 */
                metric = htonl(ORT_COST(DB_ROUTE(v)));
                DB_FREEME(db) = FALSE;
                DEL_DBQ(db);    /* remove from db_free_list */
                ADD_DBQ(&dst->interlst, db);
                DB_WHERE(db) = ON_INTER_LIST;
            }
	    
	    sum_next_seq(db, dst, metric, sec);
	}

	SUM_TYPE_LOG(dst->area_id,
		     ls_types[LS_TYPE(db)],
		     lntoa(DB_NETNUM(db)),
		     ntohl(LS_SEQ(db)),
		     ntohl(DB_SUM(db)->tos0.tos_metric));

    }
    return(ret_flag);
}

/*
 * Build default AS route
 * - called by init
 */
void
build_ase_dflt()
{
    struct ASE_LA_HDR *as;
    struct LSDB *db;

    AddLSA(&db, FirstArea, 0, MY_ID, 0, LS_ASE);
    ASE_HDR_ALLOC(as, ASE_LA_HDR_SIZE);
    as->ls_hdr.ls_type = LS_ASE;
    as->ls_hdr.ls_id = 0;
    as->ls_hdr.adv_rtr = MY_ID;
    as->ls_hdr.ls_seq = FirstSeq;
    as->ls_hdr.length = htons(ASE_LA_HDR_SIZE);
    as->net_mask = 0;
    as->tos0.tos_metric = ospf.dflt_metric;
    DB_ASE(db) = as;
    /* 
     * add to my_ase list
     */
    DB_WHERE(db) = ON_ASE_LIST;
    ADD_DBQ(&ospf.my_ase_list, db);
    DB_TIME(db) = ospf_get_time();
    fletch(DB_ASE(db), ASE_LA_HDR_SIZE);
    ospf.db_chksumsum += LS_CKS(db);
    /* MODIFIED 1/17 */
    ospf.db_cnt++;
    ospf.db_ase_cnt++;
}

/*
 * Build default route for area border router
 * - called by init
 */
void
build_sum_dflt(a)
struct AREA *a;
{
    struct SUM_LA_HDR *s;
    struct LSDB *db;

    AddLSA(&db, a, 0, MY_ID, 0, LS_SUM_NET);
    SUM_HDR_ALLOC(s, SUM_LA_HDR_SIZE);
    s->ls_hdr.ls_type = LS_SUM_NET;
    s->ls_hdr.ls_id = 0;
    s->ls_hdr.adv_rtr = MY_ID;
    s->ls_hdr.ls_seq = FirstSeq;
    s->ls_hdr.length = htons(SUM_LA_HDR_SIZE);
    s->net_mask = 0;
    s->tos0.tos_metric = a->dflt_metric;
    DB_SUM(db) = s;
    /* 
     * add to this area's net sum list 
     */
    DB_WHERE(db) = ON_SUMNET_LIST;
    ADD_DBQ(&a->dflt_sum, db);
    DB_TIME(db) = ospf_get_time();
    fletch(DB_SUM(db), SUM_LA_HDR_SIZE);
    a->db_chksumsum += LS_CKS(db);
    a->db_cnts[LS_SUM_NET]++;
    /* MODIFIED 1/17 */
    ospf.db_cnt++;
}

/*
 * Acks have come home, generate new LSA with seq FirstSeq, put on txq
 */
int
beyond_max_seq(a, intf, db, txq, asetxq, from_rxlinkup)
struct AREA *a;
struct INTF *intf;
struct LSDB *db;
struct LSDB_LIST **txq;
struct LSDB_LIST **asetxq;
int from_rxlinkup;
{

    int i;

    if (LS_TYPE(db) == LS_RTR) {
	if (from_rxlinkup) {
	    a->build_rtr = TRUE;
	    return (FLAG_NO_PROBLEM);
	}
	return (build_rtr_lsa(a, txq, TRUE));
    }

    if (LS_TYPE(db) == LS_NET) {
	if (intf == INTFNULL) {
	    for (i = 0; i < a->ifcnt; i++)
		if (NDX_IP_ADDR(a->intf[i].ifspfndx) == LS_ID(db)) {
		    intf = &(a->intf[i]);
		    break;
		}
	}
	if (intf == INTFNULL) {
	    return (FLAG_NO_PROBLEM);		/* something has gone weird */
	}
	if (from_rxlinkup && intf->state == IDr) {
	    intf->build_net = TRUE;
	    return (FLAG_NO_PROBLEM);
	}
	return (build_net_lsa(intf, txq, TRUE));
    }


    DB_SEQ_MAX(db) = FALSE;
    LS_SEQ(db) = NEXTNSEQ(LS_SEQ(db));
    if (LS_TYPE(db) == LS_ASE) {
    	ospf.db_chksumsum -= LS_CKS(db);
	txadd(db, asetxq, ntohs(LS_LEN(db)), 0, a);
    }
    else {
    	a->db_chksumsum -= LS_CKS(db);
	txadd(db, txq, ntohs(LS_LEN(db)), 0, a);
    }
    return (FLAG_NO_PROBLEM);
}

#endif				/* PROTO_OSPF */
