/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * Call down event on virtual interfaces associated with intf
 */
void
virtual_intf_down(intf)
struct INTF *intf;
{
    int i;

    /* If virtual links exist that use this interface, kill it */
    if (IAmBorderRtr &&
	(ifspfAREA(intf->ifspfndx).area_id) != 0 &&
	ospf.vcnt) {
	for (i = 0; i < ospf.vcnt; i++) {
	    if (ospf.vl[i].state > IDOWN &&
		ospf.vl[i].ifspfndx == intf->ifspfndx) {
		(*if_trans[INTF_DOWN][ospf.vl[i].state]) (&(ospf.vl[i]));
		/* schedule a build_rtr for the backbone */
		set_rtr_sched(ospf.area);
	    }
	    /* set_rtr_sched will delay building */
	    ospf.area[0].build_rtr = FALSE;
	}
    }
}


/*
 *	Interface is down
 */
void
ospf_ifdown(if_ndx)
int if_ndx;
{
    struct INTF *intf = &(ifspfIF(if_ndx));
    struct AREA *area = AREA_PTR(intf);
    struct LSDB_LIST *txq = LLNULL;

    IF_DOWN_LOG("if_name",
		lntoa(NDX_IP_ADDR(if_ndx)));
    (*if_trans[INTF_DOWN][intf->state]) (intf);
    virtual_intf_down(intf);

    /* MODIFIED 2/7/92 */
    if (intf->nbr_change) {
	(*(if_trans[intf->nbr_change][intf->state])) (intf);
    }

    /* Received from outside source */
    if (area->build_rtr) {
	area->spfsched |= build_rtr_lsa(area, &txq, 0);
	area->build_rtr = FALSE;
    }

    /* build net and rtr lsa if necessary */
    if (intf->build_net) {
	area->spfsched |= build_net_lsa(intf, &txq, 0);
	intf->build_net = FALSE;
    }

    if (txq != LLNULL) {		/* may be locked out */
	self_orig_area_flood(area, txq, LS_RTR);
	ospf_freeq(&txq, OMEM_LL);
    }

    if (area->spfsched)
	run_spf(area, 0);
}

/*
 *	Interface is up
 */
void
ospf_ifup(if_ndx)
int if_ndx;
{
    struct INTF *intf = &(ifspfIF(if_ndx));
    struct LSDB_LIST *txq = LLNULL;
    struct AREA *area = AREA_PTR(intf);

    /*
     *	XXX if admstat
     */
    (*(if_trans[INTF_UP][IDOWN])) (intf);

    /* Received from outside source */
    if (area->build_rtr) {
	area->spfsched |= build_rtr_lsa(area, &txq, 0);
	area->build_rtr = FALSE;
    }
    /* build net and rtr lsa if necessary */
    if (intf->build_net) {
	area->spfsched |= build_net_lsa(intf, &txq, 0);
	intf->build_net = FALSE;
    }
    if (txq != LLNULL) {		/* may be locked out */
	self_orig_area_flood(area, txq, LS_RTR);
	ospf_freeq(&txq, OMEM_LL);
    }
    if (area->spfsched)
	run_spf(area, 0);
}


void
tq_hellotmr(t)
struct OTIMER *t;
{
    struct INTF *intf = (struct INTF *) t->tq_data;
    struct NBR *nbr, *next_nbr;
    time_t sec = ospf_get_time();
    struct LSDB_LIST *txq = LLNULL;
    struct AREA *area = AREA_PTR(intf);
    /* MODIFIED 4/2/92 */
    int do_poll = FALSE;

    TIMER_LOG("In tq_hellotmr");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    intf->status_mod = ++(intf->status_mod) % (STATUS_MOD);
    if ((intf->type != VIRTUAL_LINK) && (!intf->status_mod))
	intf->status_check = TRUE;

    /* May have been set by outside routine calling up or down */
    if ((intf->type != VIRTUAL_LINK) && (intf->status_check)) {
	intf->status_check = FALSE;
	if (INTF_STATUS_CHANGE(intf)) {
	    if (intf->state > IDOWN)
		ospf_ifdown(intf->ifspfndx);
	    else
		ospf_ifup(intf->ifspfndx);
	    return;
	}
    }


    if (intf->state > IDOWN) {

	/* MODIFIED 4/2/92 */
	/* Note: remove POLMOD in ospf.h */
	if (intf->type == NONBROADCAST) {
	    if ((intf->pollmod * intf->hello_timer) >= intf->poll_timer) {
		do_poll = TRUE;
		intf->pollmod = 0;
	    } else {
	    	intf->pollmod++;
	    }
	}
	send_hello(intf, 0);
	for (nbr = FirstNbr(intf); nbr != NBRNULL; nbr = next_nbr) {

	    next_nbr = nbr->next;
	    /* Inactivity timer */
	    if ((nbr->state >= NATTEMPT) &&
		nbr->last_hello &&
		(sec - nbr->last_hello >= intf->dead_timer)) {
		nbr->last_hello = 0;
		if (intf->type == VIRTUAL_LINK) {
		    (*if_trans[INTF_DOWN][intf->state]) (intf);
		    goto virtual_bail_out;
		} else
		    (*(nbr_trans[INACT_TIMER][nbr->state])) (intf, nbr);
	    }
	    /* Handle holding interval for Slave mode
	       - nbr state is Loading or Full */
	    if (nbr->mode == SLAVE_HOLD &&
		nbr->last_exch &&
		(sec - nbr->last_exch) > intf->dead_timer) {
		nbr->mode = SLAVE;
		if (!(nbr->dbsum == LSDB_SUM_NULL)) {
		    DB_ZAP_PKT(nbr->dbsum);
		    ZAP(nbr->dbsum, OMEM_DBSUM);
		    nbr->dbsum = LSDB_SUM_NULL;
		}
	    }
	    /* Poll timer */
	    /* MODIFIED 4/2/92 */
	    if (nbr->state == NDOWN && do_poll)
		send_hello(intf, nbr);
	}
	/* Wait timer */
	if (intf->state == IWAITING &&
	    intf->wait_time &&
	    (sec - intf->wait_time) >= intf->dead_timer)
	    (*if_trans[WAIT_TIMER][intf->state]) (intf);

	if (intf->nbr_change) {
	    /* MODIFIED 2/7/92 */
	    (*(if_trans[intf->nbr_change][intf->state])) (intf);
	}
	/* build net and rtr lsa if necessary */
	if (intf->build_net) {
	    area->spfsched |= build_net_lsa(intf, &txq, 0);
	    intf->build_net = FALSE;
	}
      virtual_bail_out:
	if (area->build_rtr) {
	    area->spfsched |= build_rtr_lsa(area, &txq, 0);
	    area->build_rtr = FALSE;
	}
	if (txq != LLNULL) {		/* may be locked out */
	    self_orig_area_flood(area, txq, LS_RTR);
	    ospf_freeq(&txq, OMEM_LL);
	}
	if (area->spfsched)
	    run_spf(area, 0);
    }
}

/*
 *	LSA Lock one shot timer - value is MinLSInterval
 *	- can't generate an LSA within MinLSInterval
 *	- check for lsdb limit and flush our LSAs if exceeded
 */
void
tq_lsa_lock(t)
struct OTIMER *t;
{
    struct AREA *a = (struct AREA *) t->tq_data;
    time_t sec = ospf_get_time();
    struct INTF *intf;
    struct LSDB_LIST *txq = LLNULL;
    struct LSDB *db, *dbnext;

    TIMER_LOG("In tq_lsa_lock");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    /*
     *  Check to-be-free list
     */
    for (db = DB_PTR(&(ospf.db_free_list))[NEXT]; db; db = dbnext) {
	dbnext = DB_PTR(db)[NEXT];
	if (DB_CAN_BE_FREED(db))
	    db_free(db);
    }

    /* MODIFIED 1/22/92 */
    /* If LSDB limit is exceeded send trap */
    if (ospf.lsdb_limit && 
	ospf.db_cnt > ospf.lsdb_limit &&
    	!ospf.lsdb_overflow) {
	ospf.lsdb_overflow++;
	ospf.lsdb_hiwater_exceeded++;
#ifdef NOTYETDEF
	ospf_lsdb_trap(ospfLSDBOverflowTrap);
#endif
    } else if (ospf.lsdb_hiwater && 
	ospf.db_cnt > ospf.lsdb_hiwater &&
    	!ospf.lsdb_hiwater_exceeded) {
	ospf.lsdb_hiwater_exceeded++;
#ifdef NOTYETDEF
	ospf_lsdb_trap(ospfLSDBHiWaterExceededTrap);
#endif
    }

    for (intf = a->intf;
	 intf < &(a->intf[a->ifcnt]);
	 intf++)
	if (intf->lock_time && (sec - intf->lock_time >= MinLSInterval)) {
	    if (intf->lsalock & NETSCHED) {
#ifdef DBG
		sprintf(_ospf_prt_buf, "In NET sched lsalock = %x\n",
			intf->lsalock);
		DBG_LOG(_ospf_prt_buf);
#endif
		reset_net_sched(intf);	/* turn off sched */
		reset_net_lock(intf);
		if (intf->state == IDr)
		    a->spfsched |= build_net_lsa(intf, &txq, TRUE);
	    } else
		reset_net_lock(intf);
	}
    if (a->lock_time && (sec - a->lock_time >= MinLSInterval)) {
	if ((a->lsalock & RTRSCHED)) {
	    DBG_LOG("In Rtr Sched");
	    reset_rtr_sched(a);		/* turn off sched */
	    reset_rtr_lock(a);
	    a->spfsched |= build_rtr_lsa(a, &txq, 1);
	} else
	    reset_rtr_lock(a);
    }

    /* MODIFIED 6/15/92 */
    /* MODIFIED 9/6/92 forgot & */
    if (txq != LLNULL) {		/* may not be adjacent to anyone */
	self_orig_area_flood(a, txq, LS_NET);
	ospf_freeq(&txq, OMEM_LL);
    }
    /* Check for a spf sched event having been run
	    - if out of memory during spf, spf may have scheduled
    */
    if (a->spfsched)
	run_spf(a, 0);
}


/*
 *	LSA update interval timer for rtr and net LSAs
 *	- generate for all areas
 */
void
tq_IntLsa(t)
struct OTIMER *t;
{
    struct AREA *a = FirstArea;
    struct INTF *intf;
    struct LSDB_LIST *txq = LLNULL;

    TIMER_LOG("In tq_IntLsa");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    while (a < &(ospf.area[ospf.acnt])) {
	a->spfsched |= build_rtr_lsa(a, &txq, 1);

	for (intf = a->intf; intf < &(a->intf[a->ifcnt]); intf++)
	    if (intf->state == IDr)
		a->spfsched |= build_net_lsa(intf, &txq, TRUE);

	if (txq != LLNULL) {		/* may be locked out */
	    self_orig_area_flood(a, txq, LS_RTR);
	    ospf_freeq(&txq, OMEM_LL);
	}
	if (a->spfsched)
	    run_spf(a, 0);
	a++;
    }
    SEC_RESET(t) = LSRefreshTime;
}


/*
 *	LSA update interval timer for summary LSAs
 *	- generate for all areas
 */
void
tq_SumLsa(t)
struct OTIMER *t;
{
    int reset = LSRefreshTime;

    TIMER_LOG("In tq_SumLsa");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    /* will send to all areas */

    /* build_sum check buffers */
    if (build_sum())
	reset = 40;
    /* If ran out of buffers - try again in 40 seconds */

    SEC_RESET(t) = reset;
}

/*
 *	LSA update interval timer for ase LSAs
 *	- Walk linked list of self-originated LSAs and generate new versions
 */
void
tq_AseLsa(t)
struct OTIMER *t;
{
    int i;
    struct LSDB *db, *last = LSDBNULL;
    time_t reset = MinASEInterval;	/* reset value for this timer */
    time_t sec = ospf_get_time();
    u_short16 age;
#ifdef NOTYETDEF
    /* MODIFIED 1/22/92 */
    struct LSDB *start_flush, *end_flush;  /* For flushing when lsdb overflow */
#endif


    TIMER_LOG("In tq_AseLsa");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    /* If no externals just return */
    if (!DB_PTR(&ospf.my_ase_list)[NEXT]) {
	SEC_RESET(t) = (MinASEInterval * 5);
	/* MODIFIED 1/22/92 */
	return;
    }

    ASE_LSA_LOG(s2c(&sec));

    /* note start time of this period to know when to resched */
    if (ospf.cur_ase == LSDBNULL) {
	ospf.ase_start = sec;
	ospf.cur_ase = DB_PTR(&ospf.my_ase_list)[NEXT];
    }

#ifdef NOTYETDEF
    /* MODIFIED 1/22/92 */
    start_flush = ospf.cur_ase;		/* Used if db overflow */
#endif

    /* 
     * set new seq and newly generated time 
     */
    for (i = 0, db = ospf.cur_ase;
	 db != LSDBNULL && i < ASEGenLimit;
	 db = DB_PTR(db)[NEXT], i++) {

	if (NO_GUTS(db))
	    continue;

	/* MODIFIED */
	if ((sec - ADV_AGE(db,sec)) < MinLSInterval)
	    continue;

	if (!QueueChk(LS_ASE,0)) {
	    reset = 40;
	    goto no_bufs;
	}

	if (DB_RETRANS(db) != NLNULL)
	    rem_db_retrans(db);

	LS_AGE(db) = 0;
#ifdef NOTYETDEF
	/* MODIFIED 1/22/92 */
	if (ospf.db_overflow) {
	    age = MaxAge;
	} else
#endif
	if ((LS_SEQ(db) == MaxSeqNum) &&
	    (DB_SEQ_MAX(db) == FALSE) &&
	    (ospf.nbrEcnt)) {
	    /* Not noted - flush from everyone's LSDB */
	    DB_SEQ_MAX(db) = TRUE;
	    age = MaxAge;
	} else {
	    DB_SEQ_MAX(db) = FALSE;
	    LS_SEQ(db) = NEXTNSEQ(LS_SEQ(db));
	    age = 0;
	}
    	ospf.db_chksumsum -= LS_CKS(db);
	fletch(DB_ASE(db), ASE_LA_HDR_SIZE);
    	ospf.db_chksumsum += LS_CKS(db);
    	ospf.orig_new_lsa++;
	DB_TIME(db) = sec;
	LS_AGE(db) = age;
	ASE_TYPE_LOG(lntoa(LS_ID(db)),
		     ((ASE_TYPE2(db)) ? 1 : 0),
		     ntohl(LS_SEQ(db)),
		     BIG_METRIC(db));
	last = db;
    }

    no_bufs:

#ifdef NOTYETDEF
    /* MODIFIED 1/22/92 */
    end_flush = last;
#endif

    /* 
     * send LS_ASEs from current to last
     */
    if (ospf.cur_ase != LSDBNULL && last)
	send_ase(ospf.cur_ase, last, sec);
 
    /* 
     * If more to send, set reset time to be MinAseInterval, else
     * set it to be LSRefreshTime - elapsed time 
     */
    if ((!last) || (last && (DB_PTR(last)[NEXT] == LSDBNULL))) {
	last = LSDBNULL;
	reset = (LSRefreshTime - (sec - ospf.ase_start));
	if (reset <= 0)
	    reset = MinASEInterval;
    } else {
    	last = DB_PTR(last)[NEXT];
    }

    ospf.cur_ase = last;

#ifdef NOTYETDEF
    /* MODIFIED 1/22/92 */
    for (db = start_flush; 
	 db != LSDBNULL;
	 db = DB_PTR(db)[NEXT]) 
    {
	if (NO_GUTS(db))
	    continue;
	if ((sec - ADV_AGE(db,sec)) < MinLSInterval)
	    continue;
	DEL_DBQ(db);
	DB_WHERE(db) = ON_ASE_INFINITY;
	DB_FREEME(db) = TRUE;
	ADD_DBQ(&ospf.db_free_list, db);
	if (db == end_flush) break;
    }
#endif

    SEC_RESET(t) = reset;
}

/*
 *	retransmit timer for this interface
 *		what to retransmit is based on state
 */
void
tq_retrans(t)
struct OTIMER *t;
{
    struct INTF *intf = (struct INTF *) t->tq_data;
    struct NBR *n;
    /* MODIFIED 5/24/92 for new queues */

    TIMER_LOG("In tq_retrans");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    for (n = FirstNbr(intf); n != NBRNULL; n = n->next) {
	if (n->state < NEXSTART)
	    continue;

	if (n->state == NEXSTART) {
	    /* retransmit dbsum if any on queue */
	    if (n->dbcnt)
		send_dbsum(intf, n, IS_RETRANS);
	    /* Could have run out of memory to build send sum last time... */
	    else send_dbsum(intf, n, NOT_RETRANS);
	    continue;
	}

	if ((n->state == NEXCHANGE) &&
	    (n->mode == MASTER) &&
	    (n->dbcnt))
	    send_dbsum(intf, n, IS_RETRANS);

	if (n->state >= NEXCHANGE) {
	    if (n->reqcnt)
		send_req(intf, n, IS_RETRANS);

	    if (n->rtcnt) {
		send_lsu(n->retrans, RETRANS_HASH_SIZE, n, intf, IS_RETRANS);
	    }
	}
    }
}


/* MODIFIED 5/24/92 new ack algorithm - system ack timer */
/*
 *	Ack timer for all interfaces
 *		Send delayed ack if there area any
 */
void
tq_ack(t)
struct OTIMER *t;
{
    struct INTF *intf;
    struct AREA *area;

    TIMER_LOG("In tq_ack");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    /* Send acks to all non-virtual interfaces */
    for (area = FirstArea; area < &(ospf.area[ospf.acnt]); area++) {
	for (intf = area->intf; intf < &(area->intf[area->ifcnt]); intf++) {
    	    if (intf->acks.ptr[NEXT]) {
		send_ack(intf, NBRNULL, &(intf->acks));	/* non-direct ack */
	    }
	}
    }

    /* Send acks to all virtual interfaces */
    if (IAmBorderRtr && ospf.vcnt) {
	for(intf = ospf.vl; intf < &(ospf.vl[ospf.vcnt]); intf++) {
    	    if (intf->acks.ptr[NEXT]) {
		send_ack(intf, NBRNULL, &(intf->acks));	/* non-direct ack */
	    }
	}
    }
}


int
dbage(a, type, trans, sec, start, stop)
struct AREA *a;
int type;
struct LSDB_LIST **trans;
time_t sec;
int start, stop;
{
    struct LSDB *hp, *db, *dblast;
    struct LSDB_LIST *ll;
    u_short16 age, chksum;
    int spfsched = 0;

    /*
     * Age DB from start to stop
     * - Ase can age pieces at a time to avoid major floods
     */
    for (hp = &(a->htbl[type][start]);
	 hp < &(a->htbl[type][stop]);
	 hp++) {
	for (dblast = hp, db = DB_NEXT(hp);
	     db != LSDBNULL;
	     dblast = db, db = DB_NEXT(db)) {
	    if (NO_GUTS(db)) {
		if (type == LS_ASE) {
		    /* 
		     * garbage collection, remove all traces of 
		     */
		    DB_NEXT(dblast) = DB_NEXT(db);
		    ZAP(db, OMEM_LSDB);
		    db = dblast;
		}
		continue;		/* was freed */
	    }
	    /* 
	     * MaxSeq and no acks, generate a new one 
	     */
	    if (DB_SEQ_MAX(db) == TRUE &&
		(QueueChk(LS_TYPE(db),a)) &&
		DB_RETRANS(db) == NLNULL &&
		DB_FREEME(db) != TRUE)
		spfsched |=
		    beyond_max_seq(a, INTFNULL, db, trans, trans, TRUE);

	    /* 
	     * Check db entry for MaxAge 
	     */
	    else if ( (DB_WHERE(db) != ON_ASE_LIST) &&
		      (ADV_AGE(db, sec) >= MaxAge) &&
		      (!(DB_SEQ_MAX(db))) ) 
	   {
		/* Currently active route? */
		if (DB_ROUTE(db) != ROUTENULL ||
		    DB_ASB_RTR(db) != RTR_ROUTENULL) {
		    if (!QueueChk(type,a))
			continue;

		    if ((LS_TYPE(db) == LS_SUM_NET) ||
			(LS_TYPE(db) == LS_SUM_ASB)) {
			if ((IAmBorderRtr && a == ospf.area) ||
			    (!(IAmBorderRtr)))
			    spfsched |= SCHED_BIT(type);
		    } else
			spfsched |= SCHED_BIT(type);

		    LS_AGE(db) = MaxAge;
		    if (DB_FREEME(db) != TRUE) {
			DEL_DBQ(db);
			DB_FREEME(db) = TRUE;
			ADD_DBQ(&ospf.db_free_list, db);
		    }

		    LL_ALLOC(ll);
		    ll->lsdb = db;
		    EN_Q((*trans), ll);
		} else if (DB_FREEME(db)) {	/* was set to be freed */
		    /* free if conditions are met */
		    if (DB_CAN_BE_FREED(db)) {
			db_free(db);
			/* Asbr rtr entries are pointed to by externals
			   so they shouldn't be freed */
			if ((NO_GUTS(db)) && (type == LS_ASE)) {
			    /* garbage collection, remove all traces of */
			    DB_NEXT(dblast) = DB_NEXT(db);
			    ZAP(db, OMEM_LSDB);
			    db = dblast;
			}
		    }
		} else {		/* db->freeme hasn't been set yet */
		    if (!QueueChk(type,a))
			continue;
		    LS_AGE(db) = MaxAge;
		    DEL_DBQ(db);
		    DB_FREEME(db) = TRUE;
		    ADD_DBQ(&ospf.db_free_list, db);
		    LL_ALLOC(ll);
		    ll->lsdb = db;
		    EN_Q((*trans), ll);
		}
		continue;
	    }

	    /* 
	     * Rerun fletch 
	     */
	    age = LS_AGE(db);
	    LS_AGE(db) = 0;
	    chksum = LS_CKS(db);
	    fletch(DB_RTR(db), ntohs(LS_LEN(db)));
	    if (chksum != LS_CKS(db)) {
#ifdef DBG
	    	/* MODIFIED 8/28/92 need lntoa */
		sprintf(_ospf_prt_buf, "Chksum failed: area %s type %d id %s adv %s",
			lntoa(a->area_id),
			type,
			lntoa(LS_ID(db)),
			lntoa(ADV_RTR(db)));
		CHECKSUM_LOG(chksum, LS_CKS(db), type, ntohs(LS_LEN(db)));
#endif
		adios(_ospf_prt_buf);
	    }
	    LS_AGE(db) = age;
	}
    }
    return (spfsched);
}



/*
 * tq_int_dbage
 *   	- Run on LS_RTR and LS_NET for all areas
 * 	- Recalculate DB checksum
 * 	- Check for MaxAge
 */
void
tq_int_age(t)
struct OTIMER *t;
{
    struct AREA *a = FirstArea;

    /* list of lsdbs to be sent */
    struct LSDB_LIST *trans = LLNULL;
    time_t sec = ospf_get_time();

    TIMER_LOG("In tq_int_age");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    while (a < &(ospf.area[ospf.acnt])) {
	a->spfsched |= dbage(a, LS_RTR, &trans, sec, 0, HTBLSIZE);
	a->spfsched |= dbage(a, LS_NET, &trans, sec, 0, HTBLSIZE);

	/* something with a valid route has aged out */
	/* this should only happen when a router goes brain dead,
           shouldn't even happen */
	/* if a db entry was newly discovered to be MaxAge, flood it */
	if (trans != LLNULL) {
	    self_orig_area_flood(a, trans, LS_RTR);
	    ospf_freeq(&trans, OMEM_LL);
	}
	if (a->spfsched)
	    run_spf(a, 0);
	a++;
    }
}

/*
 * tq_sum_age
 *   	- Run on LS_SUM_NET and LS_SUM_ASB for all areas
 * 	- Recalculate DB checksum
 * 	- Check for MaxAge
 */
void
tq_sum_age(t)
struct OTIMER *t;
{
    struct AREA *a = FirstArea;
    struct LSDB_LIST *trans = LLNULL;
    time_t sec = ospf_get_time();

    TIMER_LOG("In tq_sum_age");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    while (a < &(ospf.area[ospf.acnt])) {
	a->spfsched |= dbage(a, LS_SUM_NET, &trans, sec, 0, HTBLSIZE);
	a->spfsched |= dbage(a, LS_SUM_ASB, &trans, sec, 0, HTBLSIZE);
	/*
         * if a db entry was newly discovered to be MaxAge, flood it
         */
	if (trans != LLNULL) {
	    self_orig_area_flood(a, trans, LS_SUM_NET);
	    ospf_freeq(&trans, OMEM_LL);
	}
	if (a->spfsched)
	    run_spf(a, 0);
	a++;
    }
}


/*
 * tq_ase_age
 * 	- Age ase LSAs
 */
void
tq_ase_age(t)
struct OTIMER *t;
{
    struct AREA *area = FirstArea, *a;
    struct LSDB_LIST *trans = LLNULL;
    time_t sec = ospf_get_time();
    int ase_age_end = ospf.ase_age_ndx + ASE_AGE_NDX_ADD;
    int ase_age_start = ospf.ase_age_ndx;

    if (ase_age_end >= HTBLSIZE) {
	ase_age_end = HTBLSIZE;
	ospf.ase_age_ndx = 0;
    } else {
	ospf.ase_age_ndx = ase_age_end;
    }

    TIMER_LOG("In tq_ase_age");
    /* MODIFIED 1/22/92 */
    TRAP_REF_UPDATE;	/* Update the trap event counter */

    area->spfsched |= dbage(area,
			 LS_ASE,
			 &trans,
			 sec,
			 ase_age_start,
			 ase_age_end);

    /*
     * if a db entry was newly discovered to be MaxAge, flood it
     */
    if (trans != LLNULL) {
	for (a = area; a < &(ospf.area[ospf.acnt]); a++)
	{
	    if (a->ext_option == EXT_OPT_NORMAL)
	    	self_orig_area_flood(a, trans, LS_ASE);
	}
	ospf_freeq(&trans, OMEM_LL);
    }
    /*
     * something with a valid route has aged out
     */
    if (area->spfsched)
	run_spf(area, 0);
}

#endif				/* PROTO_OSPF */
