/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

extern int vs;				/* socket for checking if intf is up */


void
sig_restore(oldmask)
int oldmask;
{
#ifdef __OSPF_D
    sigsetmask(oldmask);		/* restore signals */
#endif
}

void
sig_block(oldmask)
int *oldmask;
{
#ifdef __OSPF_D
    *oldmask = sigblock(MASKALRM);
#endif
}

void
close_socks()
{
    int i;

    for (i = 0; i < ospf.nintf; i++)
	if (IF_NDX[i].fd)
	    close(IF_NDX[i].fd);
#ifdef NO_IFF_MULTICAST
    if (M)
	close(M);
#endif

#ifdef PKTLOG
    if (dumpfp)
	fclose(dumpfp);
#endif
#ifdef DBG
    if (iologfp)
	fclose(iologfp);
#endif
}


void
ospf_bye()
{

    sprintf(_ospf_prt_buf, "bye bye\n");
    OSPF_LOG(_ospf_prt_buf);
#ifdef NO_IFF_MULTICAST
    disable_mcast_rx();
#endif
#ifdef MIB_TEST
    mib_kill();
#endif
    close_socks();
    exit(1);
}


/*
 *	Check for up interface
 */
int
ospf_ifchk(ndx)
int ndx;
{
    struct ifreq ifreq;

    TIMER_LOG("In tq_ifchk");

    if (NDX_DISABLE(ndx))
    {
	sprintf(_ospf_prt_buf,"NDX is disabled\n");
	OSPF_LOG(_ospf_prt_buf);
	return (FALSE);
    }
#ifdef UMBC_SIM
    return (sim_ifcheck(ndx));
#else
    strncpy(ifreq.ifr_name, IF_NDX[ndx].ifip_name, IFNAMSIZ);
    if (ioctl(vs, SIOCGIFFLAGS, (char *) &ifreq) < 0) {
    	if (!strlen(IF_NDX[ndx].ifip_name))
		return(TRUE);
	IF_DOWN_LOG(ifreq.ifr_name,
		    lntoa(NDX_IP_ADDR(ndx)));
/*
	perror("SIOCGIFFLAGS fails");
*/
	return (FALSE);
    }
    return (ifreq.ifr_flags & IFF_UP);
#endif
}


void
ospf_init()
{
    int 	i;
    struct 	avl_node s, *r;
    u_long32	dest, mask;

    /* Create OSPF routing table */
    AVLALLOC(ospf_rtab);
    ospf_rtab->ptr[RLINK] = AVLNULL;

    __mon_fd = fileno(stdout);		/* for monitor request */
    ospf_get_sys_time();
    /*
     * Init without default route
     */
    RT_DELETE(&avl_dflt_rt) = TRUE;

    /*
     * Install directly attached routes as static/direct
     */
    for ( i = 0; i < ospf.nintf; i++ ) {
	/*
	 * Dont' add if unnumberd ptop link
	 */
	if (!(NDX_IP_ADDR(i)))
	    continue;

	STATIC_INFO_ALLOC(&s);
	STATIC_NH_NDX(&s) =
	    add_nh_entry(i, NDX_IP_ADDR(i), NH_DIRECT, AREANULL);
	STATIC_PREF(&s) = STATIC_ROUTE_PREF;

	/* MODIFIED 12/20 */
	if (ifspfIF(i).type == POINT_TO_POINT) {
	    dest = NDX_IP_ADDR(i);
	    mask = HOST_NET_MASK;
	} else {
	    dest = (NDX_IP_ADDR(i) & NDX_IP_MASK(i));
	    mask = NDX_IP_MASK(i);
	}

	r = RT_INSERT(dest,
		      mask,
		      &STATIC_NH_NDX(&s),
		      1,
		      PR_STATIC,
		      STATIC_INFO(&s));
	RT_DIRECT(r) = TRUE;
	/* Will choose static... */
	choose_proto(r);
    }

#ifdef BSD_TEST
    krt_sock_init();
#endif

    /* should do a stash init in here */
    signal(SIGINT, ospf_bye);
    signal(SIGALRM, tqhandler);
    timerqinit();			/* fire up them timers */
    /* MODIFIED 1/28/92 */
    ospf.ospf_start_time = ospf_get_time();
    ospf.ospf_admin_stat = OSPF_ENABLED;

#ifndef UMBC_SIM
    if (SEC_SET(timerq.ptr[NEXT]) > 0)
	sys_timer_set(timerq.ptr[NEXT]);
#endif
}
