/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#ifndef __HOSTS_H__
#define __HOSTS_H__

#include "classes.h"

struct hostrange {
	unsigned long start, end;
};

struct hosttable {
     struct hosttable *next;
     int size;
     unsigned int network;
     unsigned char *table;
};

struct reject {
     unsigned int ipaddr;
     unsigned int netmask;
};


struct allow {
     unsigned int ipaddr;
     unsigned int netmask;
     struct classentry ports[CLASS_SIZE];
};

extern void init_hosts(void);
extern unsigned int getnetmask(unsigned int);
extern void writehosttables(int);
extern void do_host(unsigned int);
extern void do_network(struct hostrange, unsigned int);
extern void add_reject(unsigned int, unsigned int);
extern void add_allow(unsigned int, unsigned int);

#endif
