/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
#include "fm.h"

void longSwap(unsigned long *buf,unsigned long length)
{
    unsigned char *l;
    unsigned char c;
    int i;

    for (i = 0;i < length;++i) {
        l = (unsigned char *) (buf + i);

        c = l[0];
        l[0] = l[3];
        l[3] = c;

        c = l[1];
        l[1] = l[2];
        l[2] = c;
    }
}

void shortSwap(unsigned short *buf,unsigned long length)
{
    struct bytes {
	unsigned char byte1;
	unsigned char byte2;
    } *shortTemp;
    int i;
    unsigned char c;

    for (i = 0;i < length;++i) {
	shortTemp = (struct bytes *) (buf + i);
	
	c = shortTemp->byte1;
	shortTemp->byte1 = shortTemp->byte2;
	shortTemp->byte2 = c;
    }
}

/*
 * Prints a textual version of the error code that was returned by the filter.
 */
void printError(unsigned char code,FILE *theOutput)
{
    switch (code) {
        case FM_ERROR_INSECURE:
	    fprintf(theOutput,"filter is in insecure mode\n");
	    break;
        case FM_ERROR_SECURE:
	    fprintf(theOutput,"filter is in secure mode\n");
	    break;
        case FM_ERROR_PASSFILE:
	    fprintf(theOutput,"filter could not open the password file\n");
	    break;
        case FM_ERROR_PASSWRITE:
	    fprintf(theOutput,"filter could not write to the password file\n");
	    break;
        case FM_ERROR_NONETWORK:
  	    fprintf(theOutput,"filter does not have the specified network loaded\n");
	    break;
        case FM_ERROR_NOMEMORY:
  	    fprintf(theOutput,"filter does not have enough free memory for the operation\n");
	    break;
        case FM_ERROR_COMMAND:
  	    fprintf(theOutput,"filter did not understand the request (protocol error)\n");
	    break;
        case FM_ERROR_DATAFILE:
  	    fprintf(theOutput,"filter could not open a file for writing\n");
	    break;
        case FM_ERROR_DATAWRITE:
  	    fprintf(theOutput,"filter could not write to a file (disk is probably full)\n");
	    break;
        case FM_ERROR_INVALIDNETWORK:
  	    fprintf(theOutput,"filter cannot handle the specified network\n");
	    break;
        case FM_ERROR_LOADBUFFER:
  	    fprintf(theOutput,"a buffer error occurred in the filter during the load\n");
            break;
        case FM_ERROR_LOSTSYNC:
  	    fprintf(theOutput,"lost sync while communicating with filter\n");
	    break;
        default:
	    fprintf(theOutput,"unknown error code %d from target\n",code);
	    break;
    }
}

