/*
 * Udprelay
 *
 * Copyright 1993 Tom Fitzgerald <fitz@wang.com>; permission to use, modify
 * and distribute this source is granted provided only that this notice is
 * retained intact.
 */

#define UdpRelayVersion	1

#define UdpRelayData	0		/* Datagram carries payload */
/*
 * Errors are only returned from proxy to client, and only if twoway
 */
#define UdpRelayBusy	1		/* Proxy port is already in use */
#define UdpRelayReadErr	3		/* Error from recvfrom, enclosed */

typedef struct sockaddr_in  SockIn;

typedef struct udpEncaps {
	char		version;
	char		contents;	/* UdpRelay* value */
	char		twoway;		/* 1 if return data expected */
	char		padding1;
	SockIn		sin;		/* Far end of tunnel */
	u_short		proxyport;
	char		username [12];	/* Null-terminated, <= 11 chars */
} UdpEncaps;

