/* itemInfo.c
   collect for display information about a gopher item or directory */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include "gopher.h"
#include "osdep.h"


/* showItemInfo
   Show information associated with a gopher item (or directory) */

char *
getItemInfoText(gi, level)
gopherItemP	gi;
int		level;
{
	static char	infoString[1024];
	char	temp[256];
	char	*dispString;

	*infoString = '\0';

	sprintf(temp, "          Gopher Item Information\n");
	strcat(infoString, temp);
	sprintf(temp, "          -----------------------\n\n");
	strcat(infoString, temp);

	sprintf(temp, "Name:  \'%s\'\n", USER_STRING(gi));
	strcat(infoString, temp);

	sprintf(temp, "Type:  %c (%s)\n",
				gi->type, gi->sc->typeName);
	strcat(infoString, temp);

	sprintf(temp, "\n");
	strcat(infoString, temp);

	sprintf(temp, "Host:  \'%s\'\n", gi->host);
	strcat(infoString, temp);
	sprintf(temp, "       (Computer where information is maintained)\n");
	strcat(infoString, temp);

	sprintf(temp, "Port:  %d\n", gi->port);
	strcat(infoString, temp);
	sprintf(temp, "       (Network connection port)\n");
	strcat(infoString, temp);

	sprintf(temp, "\n");
	strcat(infoString, temp);

	sprintf(temp, "Path:  ");
	strcat(infoString, temp);
	sprintf(temp, "\'%s\'\n", vStringValue(&(gi->selector)));
	strcat(infoString, temp);
	sprintf(temp, "       (Tells host where to find the information)");
	strcat(infoString, temp);

	/* Copy to dynamic string for display.  The dynamic string will
	   be freed when the text display is done. */

	if ((dispString =
	    (char *) malloc(1 + sizeof(char) * strlen(infoString))) != NULL) {
		strcpy(dispString, infoString);
	}

	return dispString;
}
