/*
**  SETPROCTITLE -- set process title for ps
**
**    Parameters:
**	    fmt -- a printf style format string.
**	    a, b, c -- possible parameters to fmt.
**
**    Returns:
**	    none.
**
**      Side Effects:
**	      Clobbers argv of our main procedure so ps(1) will
**	      display the title.
**
**    Stolen from IDA Sendmail - I don't think it's UCB code.
*/

#include <sys/types.h>
#include <string.h>

/*VARARGS1*/
socks_setproctitle(buf, Argv, LastArgv)
char *buf;
char **Argv, *LastArgv;
{
	register char *p;
	register int i;

	/* make ps print "(sockd)" */
	p = Argv[0];
	*p++ = '-';

	i = strlen(buf);
	if (i > LastArgv - p - 2)
	{
		i = LastArgv - p - 2;
		buf[i] = '\0';
	}
	(void) strcpy(p, buf);
	p += i;
	while (p < LastArgv)
		*p++ = ' ';
}

