/* cfhosts.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <syslog.h>
#include "firewall.h"
#include "libemfw.h"

/* Return NULL if access is denied.  Otherwise, return a pointer to
   the matching "hosts" entry. */

Cfg * config_hosts (Cfg *confp, char *rladdr, char *riaddr)
{
  Cfg *cf = cfg_get ("hosts", confp);
  int i;

  while (cf != (Cfg *)0)
    {
      if (cf->argc >= 1)
	{
	  for (i = 0; i < cf->argc && cf->argv[i][0] != '-'; ++i)
	    {
	      if (hostmatch (cf->argv[i], riaddr))
		{
		  if (cf->flags & PERM_DENY)
		    goto deny;
		  syslog (LLEV, "permit host=%s/%s use of gateway",
			  rladdr, riaddr);
		  return cf;
		}
	    }
	}
      cf = cfg_get ("hosts", (Cfg *)0);
    }
deny:
  syslog (LLEV, "deny host=%s/%s use of gateway", rladdr, riaddr);
  return (Cfg *)0;
}
