/* findcmd.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <string.h>
#include "firewall.h"
#include "libemfw.h"

/* Return NULL if the command is ambiguous, a pointer to the last
   table entry (having cnum==NULL) if the command is unknown. */

Cmd *find_command (Cmd *tab, char *cmd)
{
  Cmd *cp, *match;
  int nl;

  nl = strlen (cmd);
  match = 0;
  for (cp = tab; cp->cnam != (char *)0; cp++)
    {
      /* Check for exact match */
      if (strcmp (cp->cnam, cmd) == 0)
	return cp;
      /* Check for prefix match */
      else if (strncasecmp (cp->cnam, cmd, nl) == 0)
	{
	  if (match && cp->cfun != match->cfun)
	    return 0;		/* Ambiguous command */
	  match = cp;
	}
    }
  return match ? match : cp;
}
