#!/usr/local/bin/perl
# usage: xpm1to3.perl xpmv1-file > xpmv3-file
# perl (available by ftp on prep.ai.mit.edu script) to convert xpm v1 
# X11 pixmap files to xpm v3 (C includable format) pixmap files

sub checkname {
if ($_[0] ne $_[1]) { printf STDERR "warning, name inconsitencies in %s
%s!=%s\n", $_[2], $_[0], $_[1]; }
}

printf "/* XPM */\n";
($name, $format) = (<> =~ /^#define (\w+)_format (\d+)$/);
($name2, $width) = (<> =~ /^#define (\w+)_width (\d+)$/);
&checkname($name, $name2, "width");
($name2, $height) = (<> =~ /^#define (\w+)_height (\d+)$/);
&checkname($name, $name2, "height");
($name2, $ncolors) = (<> =~ /^#define (\w+)_ncolors (\d+)$/);
&checkname($name, $name2, "ncolors");
($name2, $chars_per_pixel) = (<> =~ /^#define (\w+)_chars_per_pixel (\d+)$/);
&checkname($name, $name2, "chars per pixel");

($name2) = (<> =~ /^static char \* (\w+)_colors\[] = {$/);
&checkname($name, $name2, "colors");

printf "static char * %s[] = {\n", $name;
printf "/* %s pixmap\n * width height ncolors chars_per_pixel */\n", $name;
printf "\"%s %s %s %s \",\n", $width, $height, $ncolors, $chars_per_pixel;

$idx = 0;
while ( ($_ = <>) =~ m/^\s*"[^"]+"\s*,\s*"[^"]+"(,)?$/ ) {
  ($codes[$idx], $color_name[$idx]) = /^\s*"([^"]+)"\s*,\s*"([^"]+)"(,)?$/;
  $idx++;
}
if ($idx != $ncolors) {
  printf STDERR "Warning, ncolors mismatch reading color %d != %d\n",
$ncolors, $idx;
}

for ($idx=0; $idx<$ncolors; $idx++) {
  printf "\"%s c %s \t s s_%s \",\n", $codes[$idx], $color_name[$idx],
$color_name[$idx];
}

($name2) = ( <> =~ /^static char \* (\w+)_pixels\[] = {$/);
&checkname($name, $name2, "pixels");

printf "/* pixels */\n";
while ( ! ( ($_ = <>) =~ /^} ;$/) ) {
	printf $_;
}
printf "} ;\n";
