/* change.c -- routines to login and change nameserver entries.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 29 10:48:58 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>

#include "fields.h"
#include "replies.h"
#include "global.h"

/* Prototype some internal functions. */
void dismiss_help(), do_change(), change_dismiss();
void show_entry(), change_help(), toggle_fields();
extern void do_edit();

/* These popup widgets are global because once created, we save them,
 * and map tham again if the user asks for them.
 */
       Widget change_popup=NULL;
static Widget chelp_popup=NULL;


/* Some variables global to this module only, for job security. */
static int all_fields=0;


void do_change(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget      cform, clabel, clist, cpsw, cquery, chelp, call, cdismiss;
    Position	x, y;
    Dimension	width, height;
    String      *list;

    /* Have we logged in yet?  If not, pop up a widget to do that first. */
    if (! logged_in) {
       do_login((Widget) widget, (XtPointer) client_data,
		(XtPointer) do_change);
       return;
    }
    
    if (change_popup == NULL) {
       change_popup = XtVaCreatePopupShell("xph_change",
					   applicationShellWidgetClass,
					   widget, XtNtitle, "Xph Change",
					   XtNiconPixmap, icon_pixmap, NULL);

       /* Create a form with a text widget and a dismiss button. */
       cform = XtCreateManagedWidget("cform", formWidgetClass, change_popup,
				     NULL, ZERO);
       clabel = XtCreateManagedWidget("clabel", labelWidgetClass, cform,
				     NULL, ZERO);

       /* Ask the nameserver for field info.  Store this and then compute
        * a subset.  By default, we show only those changeable fields
	* that are returned by default.
	*/
       list = field_list((CHANGE | DEFAULT | ENCRYPT | NOPEOPLE),
			 (CHANGE | DEFAULT));
       clist = XtVaCreateManagedWidget("clist", listWidgetClass, cform,
				       XtNlist, list, NULL);
       XtAddCallback(clist, XtNcallback, do_edit, (XtPointer) cform);
       
       /* The command buutons at the bottom pf the panel. */
       cpsw = XtCreateManagedWidget("cpsw", commandWidgetClass, cform,
				    NULL, ZERO);
       XtAddCallback(cpsw, XtNcallback, change_password, (XtPointer) cform);
       cquery = XtCreateManagedWidget("cquery", commandWidgetClass, cform,
				      NULL, ZERO);
       XtAddCallback(cquery, XtNcallback, show_entry, (XtPointer) cform);
       chelp = XtCreateManagedWidget("chelp", commandWidgetClass, cform,
				     NULL, ZERO);
       XtAddCallback(chelp, XtNcallback, change_help, (XtPointer) cform);
       call = XtCreateManagedWidget("call", toggleWidgetClass, cform,
				    NULL, ZERO);
       XtAddCallback(call, XtNcallback, toggle_fields, (XtPointer) clist);
       cdismiss = XtCreateManagedWidget("cdismiss", commandWidgetClass, cform,
					NULL, ZERO);
       XtAddCallback(cdismiss, XtNcallback, change_dismiss, (XtPointer) cform);

    }

    /* Attempt to position the widget.  We're likely to be over-ruled
     * by the window manager.  We only choose the application class
     * so we'll get a title bar and the typical resize gadgets.
     */
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(change_popup, XtNx, x, XtNy, y, NULL);

    XtPopup(change_popup, XtGrabNone);

#if 0
    /* Finally, find out the width and height of the window and set the
     * max values to this, thus disallowing any resizing.
     */
    XtVaGetValues(change_popup, XtNwidth, &width, XtNheight, &height,
		  NULL);
    XtVaSetValues(change_popup, XtNmaxWidth, width, XtNminWidth, width,
		  XtNmaxHeight, height, XtNminHeight, height, NULL);
#endif
}


static void
change_dismiss(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   /* Log out and pop down the change widget. */
   logged_in = FALSE;
   XtPopdown(change_popup);
}


static void
toggle_fields(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   String *list;

   /* Toggle our field selection state.  Then recompute the field list
    * accordingly.
    */
   all_fields = !all_fields;
   if (all_fields == 0) {
      /* Just select the default changeable fields. */
      list = field_list((CHANGE | DEFAULT | ENCRYPT | NOPEOPLE),
			       (CHANGE | DEFAULT));
   }
   else {
      /* Select all the changeable fields. */
      list = field_list((CHANGE | ENCRYPT | NOPEOPLE), CHANGE);
   }

   XawListChange((Widget) client_data, list, ZERO, ZERO, TRUE);
}


#define CHELP_WIDTH  300
#define CHELP_HEIGHT 110

static String chelp_text =
"Edit Fields Help\n\n\
Select a field to view.\n\n\
Use the 'Show Entry' button\n\
to retrieve your entire entry\n\
and display it in the main\n\
output window.\n\n\
You can select from a list\n\
of default fields (those\n\
returned by default on\n\
queries), or from a list\n\
of all fields, by clicking\n\
on the 'All Fields' toggle.\n\n\
Only those fields that are\n\
changeable are displayed.\n";

static void
change_help(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	hform, htext, hdismiss;
    Position	x, y;
    Dimension	width, height;

    if (chelp_popup == NULL) {
       chelp_popup = XtVaCreatePopupShell("login_help",
					  transientShellWidgetClass, widget,
					  XtNtitle, "Xph Change Help",
					  XtNiconPixmap, icon_pixmap, NULL);

       /* Create a form with a text widget and a dismiss button. */
       hform = XtCreateManagedWidget("hform", formWidgetClass, chelp_popup,
				     NULL, ZERO);

       htext = XtVaCreateManagedWidget("htext", asciiTextWidgetClass, hform,
				       XtNwidth, CHELP_WIDTH,
				       XtNheight, CHELP_HEIGHT,
				       XtNdisplayCaret, FALSE,
				       XtNstring, chelp_text, NULL);
       hdismiss = XtCreateManagedWidget("hdismiss", commandWidgetClass, hform,
					NULL, ZERO);
       XtAddCallback(hdismiss, XtNcallback, pop_down_widget,
		     (XtPointer) hform);
    }

    /* Position the change help widget just inside the change popup. */
    XtVaGetValues((Widget) client_data, XtNx, &x, XtNy, &y, NULL);
    XtTranslateCoords((Widget) client_data, (Position) x,
		      (Position) y, &x, &y);
    XtVaSetValues(chelp_popup, XtNx, x+5, XtNy, y+5, NULL);

    XtPopup(chelp_popup, XtGrabExclusive);
}


static void
show_entry(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   /* Retrieve the entry for the logged in user.  Ask for either the
    * default fields, or all fields.
    */
   sprintf(buf, "alias=%s %s", login_alias,
	   ((all_fields == 1) ? "return  all" : ""));
   do_query(buf);
}
