########################## -*- Mode: Perl -*- ##########################
##
## File             : config.pl.in
##
## Description      : configurations for SFgate
##
#
# Copyright (C) 1995 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Ulrich Pfeifer
## Created On       : Tue Jul 25 12:49:21 1995
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Feb 20 16:40:51 1997
##
## $State: Exp $
##
## $Id: config.pl,v 5.1.1.4 1997/04/04 17:31:10 goevert Exp goevert $
##
## $Log: config.pl,v $
## Revision 5.1.1.4  1997/04/04 17:31:10  goevert
## patch11: examine fork return code
##
## Revision 5.1.1.3  1997/02/17 12:57:51  goevert
## patch10: loading WAIT/Wais module for server version
##
## Revision 5.1.1.2  1997/01/10 10:37:00  goevert
## patch9: closing STDIN seems necessary for server restart via rsh
##
## Revision 5.1.1.1  1996/12/23 12:54:08  goevert
## patch6: use of SFgate::Config
## patch6: use OO SFgate-server now
##
## Revision 5.1  1996/11/05 16:56:01  goevert
## *** empty log message ***
##
## Revision 5.0.1.9  1996/11/04 13:11:16  goevert
## patch21: cons instead of MakeMaker
##
## Revision 5.0.1.8  1996/07/03 13:28:13  goevert
## patch19: SFgate server, logging
##
## Revision 5.0.1.7  1996/06/04 16:18:11  goevert
## patch17: SFgate-server
##
## Revision 5.0.1.6  1996/05/31 15:47:43  goevert
## patch14: SFgate-server
##
## Revision 5.0.1.5  1996/05/23 17:09:50  goevert
## patch13: conversion for headlines
## patch13: perl -wc fixes
##
## Revision 5.0.1.4  1996/05/21 15:52:42  goevert
## patch12: virtual docdir isn't set to ls6-www any longer
##
## Revision 5.0.1.3  1996/05/15 17:08:06  goevert
## patch10:
##
## Revision 5.0.1.2  1996/05/13 11:32:07  goevert
## patch1:
##
########################################################################


use strict;
no strict 'vars';


require SFgate::Databases::Databases;
require SFgate::Databases::Database;
require SFgate::Config;
require SFgate::Highlight if $SFgate::Config{VERSION} eq 'gold';


# settings for your http server
$virt_docdir       = $SFgate::Config{VIRTUAL_DOCDIR};          # virtual
$htbin             = $SFgate::Config{HTBIN};


# settings for SFgate
$seperator         = '|';           # used for descriptor
$seperatorr        = '\|';          # used for descriptor
$program           = $SFgate::Config{PROGRAM};
$revision          = "-$SFgate::Config{VERSION} $SFgate::Config{REVISION}";
$revision          =~ s/^- / /;
$logging           = 1;             # append log messages to log_file
$log_file          = $SFgate::Config{LOGFILE};
chmod(0644, $log_file) if -e $log_file;
$application_dir   = $SFgate::Config{APPDIR};
                                    # directory with application config files
$default_wais_dir  = $SFgate::Config{DBDIR};


# name of special fields (rename here to resolve conflicts)
$dmpenv_field      = 'dmpenv';      # set to 'Yes' in URL to dump environement
$debug_field       = 'debug';       # set to 'On' or 1 in URL to get debug messages
$detex_field       = 'detex';       # set to 1 to interprete "<vowel> as Umlaut
$directhttp_field  = 'directhttp';  # set to 1 to bypass SFgate when fetching http docs
$maxhits_field     = 'maxhits';     # set to change the number of hits wanted
$range_field       = 'range';       # display resulting documents from $range
$directget_field   = 'directget';   # set to 1 to bypass headline display
$tie_field         = 'tie';         # set to /and|und/ to connect fields by &&
$tieinternal_field = 'tieinternal'; # set to 'and' to connect in-field query conditions &&
$verbose_field     = 'verbose';     # set to customize headline output
$multiple_field    = 'multiple';    # set to choose multiple choice headlines
$language_field    = 'language';    # set to customize language
$listenv_field     = 'listenv';     # set to customize listenvironment
$freetext_field    = 'text';        # set to search the 'global field'
$database_field    = 'database';    # set to select databases
$document_field    = 'document';    # set to name entries in multiple choice checkboxes
$descriptor_field  = 'descriptor';  # set to waisurl
$application_field = 'application'; # set to search form url (see $application_dir)
$fieldsel_field    = 'fieldsel';    # field selection at runtime
$group_field       = 'group';       # grouping of input elements
$convert_field     = 'convert';     # set to the name of a converter
$converthl_field   = 'converthl';   # conversion of headline
$convertm_field    = 'convertm';    # configuration of converter with multiple
                                    # choice headline menus
$attributes_field  = 'attributes';  # mapping of attributes
$lattice_field     = 'lattice';     # lattice for attribute mapping
$formintern_field  = 'formintern';  # refine query with internal form
$formextern_field  = 'formextern';  # refine query with external form
$refinequery_field = 'refinequery'; # refine query for external form
$printform_field   = 'printform';   # print form to refine query?
$requestm_field    = 'requestm';    # requestmethod to use in forms
$highlight_field   = 'highlight';   # do highlighting within documents retrieved
$conditions_field  = 'conditions';  # query conditions to highlight
$transquery_field  = 'transquery';  # translated query
$_lines_field      = '_lines';      # WAIT: print how many lines around match


# start a SFgate-server (SFgate-gold)?
my $server;
if (grep /-server/, @ARGV) {
    require Getopt::Long;
    require SFgate::Server;
    eval {
        require WAIT::Wais;
        require Wais;
    };
    my %options = (port => 2100);
    Getopt::Long::GetOptions(\%options,
                             'port=i',
                             'sockfile:s',
                             'server')
        || print "text/plain\n\n$0 Illegal arguments\n", exit 1;

    $server = new SFgate::Server %options;
}


# who am i?
if ($server) {
    $me = $program;
}
else {
    ($me = $0) =~ s:.*/::;  
}


if ($me =~ /$program/) {
    
    my $request_method = $ENV{'REQUEST_METHOD'};
    my $query;
    
    if ($request_method =~ /GET/i) {
        # REQUEST_METHOD GET
        $query = $ENV{'QUERY_STRING'};
        $request_method = 'GET';
    }
    elsif ($request_method =~ /POST/i) {
        # REQUEST_METHOD POST
        if (defined($ENV{'CONTENT_LENGTH'})) {
            read(STDIN, $query, $ENV{'CONTENT_LENGTH'});
        }
        else {
            $query = <STDIN>;
        }
        $request_method = 'POST';
    }
    elsif (!$server) {
        # assume start from shell (for test purposes)
        $logging = 0;
        &main($ENV{'QUERY_STRING'}, 'GET');
        exit;
    }
    
    if ($server) {
        # perform query
        unless ($server->SFgateServerTag($query)) {
            &main($query, $request_method) if $query;
        }
        # terminate the current process to signal the httpd
        # that the cgi-job is done
        my $child = fork();
        if ($child) {
            print STDERR "$$ Couldn't fork: $!\n" if $child == -1;
            exit;
        }
        close(STDOUT);
        close(STDIN);
        # now start the server
        $server->start_server;
    }
    else {
        &main($query, $request_method);
    }
}
else {
    # '_main1' = terminated
    # '_main4' = Strange Error
    # '_main5' = is not
    # '_main6' = Who called me then?
    # '_main3' = Please contact the webmaster.
    &print_header("$me $language{'main1'}");
    print <<"EOF";
\n<H2>$language{'main4'}</H2>

"$me" $language{'main5'} "$program".

$language{'main6'}

 <P>

$language{'main3'}
EOF
    ;
    &print_footer('');
}


## #####################################################################
## subs
## #####################################################################

sub init
{
    $debug             = 0;             # calls to dprint go to std output if set to 1
    $detex             = 0;             # set to 1 to interprete "<vowel> as Umlaut
    $directhttp        = 1;             # Use direct http urls ?
    $range             = 0;             # display resulting documents from begin by default
    $maxhits           = 40;            # return maximum 40 documents
    $directget         = 0;             # do not get the documents directly
    $tie               = '';
    $tieinternal       = '';
    $verbose_headlines = 0;             # set to 1 to use verbose headlines
    $multiple_choice   = 0;             # set to 1 to use multiple choice form for headlines
    $language          = 'English';     # language to use (either 'english' or 'german')
    $listenv           = 'DL';          # listenvironement to use for headlines, either
                                        #  descriptionlist ('DL', default) or
                                        #  preformatted ('PRE')
    $application       = '';            # name of application file
    $convert           = '';            # conversion
    $converthl         = '';            # conversion of headline
    $convertm          = '';            # configuration of converter with multiple
                                        # choice headline menus
    $attributes        = '';            # mapping of attributes
    $latticefile       = "$application_dir/lattice";
                                        # file with lattice to use for attribute mapping
                                        # default directory containing wais databases
    $formintern        = '';            # refine query with internal form 
    $formextern        = '';            # refine query with external form
    $refinequery       = '';            # refine query for external form
    $requestm          = '';            # requestmethod to use in forms
    $highlight         = 0;             # disable highlighting by default
    $conditions        = '';            # query conditions to highlight
    $transquery        = '';            # translated query
    $_lines            = '';            # WAIT: print how many lines around match
    
    # some further globals (I really should avoid them...)
    $perror            = '';
    $errno             = 0;
    $listenv_open      = 0;
    $wsrc_form         = 0;
    $hr                = 0;
}


sub main
{
    my($query) = shift;
    $request_method = shift;

    &init;
    
    eval { &do_request($query) };
    if ($@) {
        &log("request failed: $@");
        # '_main1' = terminated
        # '_main2' = terminated with message
        # '_main3' = Please contact the webmaster.
        &print_header("$me $language{'main1'}") unless $debug;
        print <<"EOF"
\n<H2>$program $language{'main1'}</H2>

$program $language{'main2'}

 <P>

<B>$@</B>

 <P>

$language{'main3'}

 <HR>
EOF
    ;
        &print_footer('');
    } 
}



